/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.ui.ContentSectionPage;
import com.arsdigita.cms.ui.WorkspaceContextBar;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.toolbox.ui.ContextBar;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.URL;
import java.math.BigDecimal;
import java.util.List;
import java.util.Stack;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

class ContentSectionContextBar
extends WorkspaceContextBar {
    private static final Logger s_log = Logger.getLogger(ContentSectionContextBar.class);

    ContentSectionContextBar() {
    }

    @Override
    protected List entries(PageState state) {
        List entries = super.entries(state);
        ContentSection section = CMS.getContext().getContentSection();
        Stack<ContextBar.Entry> folderEntryStack = new Stack<ContextBar.Entry>();
        String currentFolderLabel = null;
        ParameterMap params = new ParameterMap();
        boolean isTemplate = false;
        BigDecimal templateID = null;
        if (CMS.getContext().hasContentItem()) {
            ContentItem item = CMS.getContext().getContentItem();
            if (item == null) {
                s_log.warn((Object)"item is null");
            } else if (item.getContentType() == null) {
                s_log.warn((Object)("item.getContentType() returns null. item.class.getName(): " + item.getClass().getName()));
            }
            isTemplate = item.getContentType().equals((Object)ContentType.findByAssociatedObjectType("com.arsdigita.cms.Template"));
            if (isTemplate) {
                templateID = item.getID();
            }
            ACSObject parent = item.getParent();
            while (!isTemplate && parent != null && parent instanceof ContentItem) {
                ContentItem pitem;
                if (currentFolderLabel != null) {
                    URL folderURL = URL.there((HttpServletRequest)state.getRequest(), (String)(section.getPath() + "/" + "admin/index.jsp"), (ParameterMap)params);
                    folderEntryStack.push(new ContextBar.Entry(currentFolderLabel, folderURL));
                    currentFolderLabel = null;
                    params = new ParameterMap();
                }
                if ((pitem = (ContentItem)parent) instanceof Folder) {
                    Folder folder = (Folder)pitem;
                    parent = folder.getParent();
                    currentFolderLabel = folder.getLabel();
                    if (parent == null && !folder.equals(section.getRootFolder())) continue;
                    params.setParameter("set_folder", (Object)folder.getID());
                    continue;
                }
                if (pitem instanceof ContentBundle) {
                    ACSObject ppitem = pitem.getParent();
                    if (ppitem != null && ppitem instanceof Folder) {
                        Folder folder = (Folder)ppitem;
                        parent = folder.getParent();
                        currentFolderLabel = folder.getLabel();
                        if (parent == null && !folder.equals(section.getRootFolder())) continue;
                        params.setParameter("set_folder", (Object)folder.getID());
                        continue;
                    }
                    parent = null;
                    continue;
                }
                parent = null;
            }
        }
        if (isTemplate) {
            params.setParameter("set_tab", (Object)new BigDecimal(6));
            params.setParameter("set_template", templateID);
        }
        URL url = URL.there((HttpServletRequest)state.getRequest(), (String)(section.getPath() + "/" + "admin/index.jsp"), (ParameterMap)params);
        String sectionTitle = ContentSectionContextBar.lz("cms.ui.content_section");
        String title = sectionTitle + ": " + section.getName();
        entries.add(new ContextBar.Entry(title, url));
        while (!folderEntryStack.empty()) {
            entries.add(folderEntryStack.pop());
        }
        return entries;
    }

    private static String lz(String key) {
        return (String)ContentSectionPage.globalize(key).localize();
    }
}

