/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.TabbedPane;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.dispatcher.CMSPage;
import com.arsdigita.cms.ui.BrowsePane;
import com.arsdigita.cms.ui.ContentSectionContextBar;
import com.arsdigita.cms.ui.GlobalNavigation;
import com.arsdigita.cms.ui.ImagesPane;
import com.arsdigita.cms.ui.ItemSearch;
import com.arsdigita.cms.ui.ReportPane;
import com.arsdigita.cms.ui.UserAdminPane;
import com.arsdigita.cms.ui.category.CategoryAdminPane;
import com.arsdigita.cms.ui.cse.ContentSoonExpiredPane;
import com.arsdigita.cms.ui.folder.FolderAdminPane;
import com.arsdigita.cms.ui.lifecycle.LifecycleAdminPane;
import com.arsdigita.cms.ui.role.RoleAdminPane;
import com.arsdigita.cms.ui.type.ContentTypeAdminPane;
import com.arsdigita.cms.ui.workflow.WorkflowAdminPane;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.toolbox.ui.LayoutPanel;
import com.arsdigita.ui.DebugPanel;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Web;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class ContentSectionPage
extends CMSPage
implements ActionListener {
    private static final Logger s_log = Logger.getLogger(ContentSectionPage.class);
    public static final String RESOURCE_BUNDLE = "com.arsdigita.cms.CMSResources";
    public static final String SET_FOLDER = "set_folder";
    public static final String SET_TEMPLATE = "set_template";
    public static final String SET_TAB = "set_tab";
    public static final int SEARCH_TAB = 0;
    public static final int BROWSE_TAB = 1;
    public static final int ROLES_TAB = 2;
    public static final int WORKFLOW_TAB = 3;
    public static final int LIFECYCLES_TAB = 4;
    public static final int CATEGORIES_TAB = 5;
    public static final int CONTENTTYPES_TAB = 6;
    public static final int USER_ADMIN_TAB = 7;
    private TabbedPane m_tabbedPane;
    private FolderAdminPane m_folderPane;
    private BrowsePane m_browsePane;
    private LayoutPanel m_searchPane;
    private ImagesPane m_imagesPane;
    private RoleAdminPane m_rolePane;
    private WorkflowAdminPane m_workflowPane;
    private LifecycleAdminPane m_lifecyclePane;
    private CategoryAdminPane m_categoryPane;
    private ContentTypeAdminPane m_typePane;
    private LayoutPanel m_userAdminPane;
    private LayoutPanel m_csePane;
    private ReportPane m_reportPane;

    public ContentSectionPage() {
        super(new Label((PrintListener)new TitlePrinter()), (Container)new SimpleContainer());
        this.setClassAttr("cms-admin");
        this.add((Component)new GlobalNavigation());
        this.add((Component)new ContentSectionContextBar());
        this.m_folderPane = this.getFolderAdminPane();
        this.m_browsePane = this.getBrowsePane();
        this.m_searchPane = this.getSearchPane();
        this.m_imagesPane = this.getImagesPane();
        this.m_rolePane = this.getRoleAdminPane();
        this.m_workflowPane = this.getWorkflowAdminPane();
        this.m_lifecyclePane = this.getLifecycleAdminPane();
        this.m_categoryPane = this.getCategoryAdminPane();
        this.m_typePane = this.getContentTypeAdminPane();
        this.m_userAdminPane = this.getUserAdminPane();
        this.m_csePane = this.getCSEPane();
        this.m_reportPane = this.getReportPane();
        this.m_tabbedPane = this.createTabbedPane();
        this.m_tabbedPane.setIdAttr("page-body");
        this.m_tabbedPane.addActionListener((ActionListener)this);
        this.add((Component)this.m_tabbedPane);
        this.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                String tab = state.getRequest().getParameter(ContentSectionPage.SET_TAB);
                if (tab != null) {
                    ContentSectionPage.this.m_tabbedPane.setSelectedIndex(state, Integer.valueOf(tab).intValue());
                }
                SecurityManager sm = CMS.getContext().getSecurityManager();
                User user = Web.getContext().getUser();
                ContentSectionPage.this.m_tabbedPane.setTabVisible(state, (Component)ContentSectionPage.this.m_userAdminPane, sm.canAccess((Party)user, "staff_admin"));
                if (ContentSection.getConfig().getHideAdminTabs()) {
                    ContentSectionPage.this.m_tabbedPane.setTabVisible(state, (Component)ContentSectionPage.this.m_workflowPane, sm.canAccess((Party)user, "workflow_admin"));
                    ContentSectionPage.this.m_tabbedPane.setTabVisible(state, (Component)ContentSectionPage.this.m_categoryPane, sm.canAccess((Party)user, "category_admin"));
                    ContentSectionPage.this.m_tabbedPane.setTabVisible(state, (Component)ContentSectionPage.this.m_lifecyclePane, sm.canAccess((Party)user, "lifecycle_admin"));
                    ContentSectionPage.this.m_tabbedPane.setTabVisible(state, (Component)ContentSectionPage.this.m_typePane, sm.canAccess((Party)user, "content_type_admin"));
                    ContentSectionPage.this.m_tabbedPane.setTabVisible(state, (Component)ContentSectionPage.this.m_rolePane, sm.canAccess((Party)user, "staff_admin"));
                    ContentSectionPage.this.m_tabbedPane.setTabVisible(state, (Component)ContentSectionPage.this.m_csePane, true);
                }
            }
        });
        this.add((Component)new DebugPanel());
    }

    protected FolderAdminPane getFolderAdminPane() {
        if (this.m_folderPane == null) {
            this.m_folderPane = new FolderAdminPane();
        }
        return this.m_folderPane;
    }

    protected BrowsePane getBrowsePane() {
        if (this.m_browsePane == null) {
            this.m_browsePane = new BrowsePane();
        }
        return this.m_browsePane;
    }

    protected LayoutPanel getSearchPane() {
        if (this.m_searchPane == null) {
            this.m_searchPane = new LayoutPanel();
            this.m_searchPane.setLeft((Component)new SimpleComponent());
            this.m_searchPane.setBody((Component)new ItemSearch("draft", CMS.getConfig().limitToContentSection()));
        }
        return this.m_searchPane;
    }

    protected ImagesPane getImagesPane() {
        if (this.m_imagesPane == null) {
            this.m_imagesPane = new ImagesPane();
        }
        return this.m_imagesPane;
    }

    protected RoleAdminPane getRoleAdminPane() {
        if (this.m_rolePane == null) {
            this.m_rolePane = new RoleAdminPane();
        }
        return this.m_rolePane;
    }

    protected WorkflowAdminPane getWorkflowAdminPane() {
        if (this.m_workflowPane == null) {
            this.m_workflowPane = new WorkflowAdminPane();
        }
        return this.m_workflowPane;
    }

    protected LifecycleAdminPane getLifecycleAdminPane() {
        if (this.m_lifecyclePane == null) {
            this.m_lifecyclePane = new LifecycleAdminPane();
        }
        return this.m_lifecyclePane;
    }

    protected CategoryAdminPane getCategoryAdminPane() {
        if (this.m_categoryPane == null) {
            this.m_categoryPane = new CategoryAdminPane();
        }
        return this.m_categoryPane;
    }

    protected ContentTypeAdminPane getContentTypeAdminPane() {
        if (this.m_typePane == null) {
            this.m_typePane = new ContentTypeAdminPane();
        }
        return this.m_typePane;
    }

    protected LayoutPanel getUserAdminPane() {
        if (this.m_userAdminPane == null) {
            this.m_userAdminPane = new LayoutPanel();
            this.m_userAdminPane.setLeft((Component)new SimpleComponent());
            this.m_userAdminPane.setBody((Component)new UserAdminPane());
        }
        return this.m_userAdminPane;
    }

    protected LayoutPanel getCSEPane() {
        if (this.m_csePane == null) {
            this.m_csePane = new LayoutPanel();
            this.m_csePane.setLeft((Component)new SimpleComponent());
            this.m_csePane.setBody((Component)new ContentSoonExpiredPane());
        }
        return this.m_csePane;
    }

    protected ReportPane getReportPane() {
        if (this.m_reportPane == null) {
            this.m_reportPane = new ReportPane();
        }
        return this.m_reportPane;
    }

    protected void addToPane(TabbedPane pane, String tabName, Component comp) {
        if (comp != null) {
            pane.addTab((Component)new Label(tabName), comp);
        }
    }

    private void tab(TabbedPane pane, String key, Component tab) {
        if (tab != null) {
            pane.addTab((Component)new Label(ContentSectionPage.gz(key)), tab);
        }
    }

    protected TabbedPane createTabbedPane() {
        TabbedPane pane = new TabbedPane();
        this.tab(pane, "cms.ui.browse", (Component)this.getBrowsePane());
        this.tab(pane, "cms.ui.search", (Component)this.getSearchPane());
        this.tab(pane, "cms.ui.images", (Component)this.getImagesPane());
        this.tab(pane, "cms.ui.roles", (Component)this.getRoleAdminPane());
        this.tab(pane, "cms.ui.workflows", (Component)this.getWorkflowAdminPane());
        this.tab(pane, "cms.ui.lifecycles", (Component)this.getLifecycleAdminPane());
        this.tab(pane, "cms.ui.categories", (Component)this.getCategoryAdminPane());
        this.tab(pane, "cms.ui.content_types", (Component)this.getContentTypeAdminPane());
        this.tab(pane, "cms.ui.user_admin", (Component)this.getUserAdminPane());
        this.tab(pane, "cms.ui.cse", (Component)this.getCSEPane());
        this.tab(pane, "cms.ui.reports", (Component)this.getReportPane());
        return pane;
    }

    @Override
    public ContentSection getContentSection(HttpServletRequest request) {
        ContentSection section = super.getContentSection(request);
        Assert.exists((Object)((Object)section));
        return section;
    }

    public void actionPerformed(ActionEvent event) {
        PageState state = event.getPageState();
        Component pane = this.m_tabbedPane.getCurrentPane(state);
        if (pane == this.m_searchPane) {
            this.m_searchPane.reset(state);
        } else if (pane == this.m_imagesPane) {
            this.m_imagesPane.reset(state);
        } else if (pane == this.m_folderPane) {
            this.m_folderPane.reset(state);
        } else if (pane == this.m_browsePane) {
            this.m_browsePane.reset(state);
        } else if (pane == this.m_rolePane) {
            this.m_rolePane.reset(state);
        } else if (pane == this.m_workflowPane) {
            this.m_workflowPane.reset(state);
        } else if (pane == this.m_lifecyclePane) {
            this.m_lifecyclePane.reset(state);
        } else if (pane == this.m_categoryPane) {
            this.m_categoryPane.reset(state);
        } else if (pane == this.m_typePane) {
            this.m_typePane.reset(state);
        } else if (pane == this.m_userAdminPane || pane == this.m_csePane) {
            // empty if block
        }
    }

    public static String getSectionURL(ContentItem item, int tab) {
        ContentSection section = null;
        section = ContentSection.getContentSection(item);
        String url = section.getURL() + "admin/index.jsp" + "?" + SET_TAB + "=" + tab;
        return url;
    }

    private static GlobalizedMessage gz(String key) {
        return new GlobalizedMessage(key, RESOURCE_BUNDLE);
    }

    public static GlobalizedMessage globalize(String key) {
        return new GlobalizedMessage(key, RESOURCE_BUNDLE);
    }

    private static class TitlePrinter
    implements PrintListener {
        private TitlePrinter() {
        }

        public void prepare(PrintEvent e) {
            Label l = (Label)e.getTarget();
            l.setLabel(CMS.getContext().getContentSection().getName());
        }
    }
}

