/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.PaginationModelBuilder;
import com.arsdigita.bebop.Paginator;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.cms.ImageAssetCollection;
import com.arsdigita.cms.ReusableImageAsset;
import com.arsdigita.cms.ui.DefaultImageBrowserModel;
import com.arsdigita.cms.ui.EmptyImageBrowserModel;
import com.arsdigita.cms.ui.ImageBrowser;
import com.arsdigita.cms.ui.ImageBrowserModel;
import com.arsdigita.cms.ui.ImageBrowserModelBuilder;
import com.arsdigita.util.Assert;
import com.arsdigita.util.Lockable;
import com.arsdigita.util.LockableImpl;

public class DefaultImageBrowserModelBuilder
extends LockableImpl
implements ImageBrowserModelBuilder,
PaginationModelBuilder {
    private SingleSelectionModel m_keywordModel;
    private static ImageBrowserModel EMPTY_MODEL = new EmptyImageBrowserModel();
    private ImageBrowser m_imageBrowser;
    private RequestLocal m_size;
    private String m_key;
    private RequestLocal m_imageColl;
    private String m_context;

    public DefaultImageBrowserModelBuilder(SingleSelectionModel keywordModel, String context) {
        this.m_keywordModel = keywordModel;
        this.m_context = context;
        this.m_size = new RequestLocal();
        this.m_key = "";
        this.m_imageColl = new RequestLocal();
    }

    public DefaultImageBrowserModelBuilder(SingleSelectionModel keywordModel) {
        this(keywordModel, "draft");
    }

    public ImageAssetCollection getImageCollectionByKeyword(PageState state) {
        String key = (String)this.m_keywordModel.getSelectedKey(state);
        if (!this.m_key.equals(key)) {
            this.m_key = key;
        }
        return ReusableImageAsset.getReusableImagesByKeyword(key, this.m_context);
    }

    @Override
    public ImageBrowserModel makeModel(ImageBrowser browser, PageState s) {
        return new DefaultImageBrowserModel((ImageAssetCollection)((Object)this.m_imageColl.get(s)));
    }

    public SingleSelectionModel getKeywordModel() {
        return this.m_keywordModel;
    }

    public void setContext(String context) {
        Assert.isUnlocked((Lockable)this);
        this.m_context = context;
    }

    public int getTotalSize(Paginator paginator, PageState state) {
        int size = 0;
        if (this.m_size.get(state) == null) {
            ImageAssetCollection imageCollection;
            String key = (String)this.m_keywordModel.getSelectedKey(state);
            if (this.m_key == null || key != null && !this.m_key.equalsIgnoreCase(key)) {
                paginator.setSelectedPageNum(state, 1);
                this.m_key = key;
            }
            if ((imageCollection = ReusableImageAsset.getReusableImagesByKeyword(key, this.m_context)) != null) {
                size = (int)imageCollection.size();
            }
            this.m_size.set(state, (Object)size);
            imageCollection.setRange(new Integer(paginator.getFirst(state)), new Integer(paginator.getLast(state) + 1));
            this.m_imageColl.set(state, (Object)imageCollection);
        } else {
            size = (Integer)this.m_size.get(state);
        }
        return size;
    }

    public void setImageBrowser(ImageBrowser ib) {
        this.m_imageBrowser = ib;
    }

    public boolean isVisible(PageState state) {
        return this.m_imageBrowser != null ? this.m_imageBrowser.isVisible(state) : true;
    }
}

