/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.FileUpload;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.dispatcher.MultipartHttpServletRequest;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.mimetypes.MimeTypeCollection;
import java.io.File;

public class FileUploadSection
extends FormSection {
    private SingleSelect m_mimeWidget;
    private FileUpload m_fileWidget;
    private String m_mimePrefix;
    private String m_defaultMimeType;
    private String m_parameterPrefix;
    public static final String MIME_TYPE = "mime_type";
    public static final String FILE_UPLOAD = "file_upload";
    public static final String GUESS_MIME = "-guess-";

    public FileUploadSection(GlobalizedMessage mimeLabel, String mimePrefix, String defaultMimeType, Container panel) {
        this(mimeLabel, mimePrefix, defaultMimeType, "", panel);
    }

    public FileUploadSection(String mimeLabel, String mimePrefix, String defaultMimeType, Container panel) {
        this(new GlobalizedMessage(mimeLabel), mimePrefix, defaultMimeType, panel);
    }

    public FileUploadSection(String mimeLabel, String mimePrefix, String defaultMimeType, String parameterPrefix, Container panel) {
        this(new GlobalizedMessage(mimeLabel), mimePrefix, defaultMimeType, parameterPrefix, panel);
    }

    public FileUploadSection(GlobalizedMessage mimeLabel, String mimePrefix, String defaultMimeType, String parameterPrefix, Container panel) {
        super(panel);
        this.m_mimePrefix = mimePrefix;
        this.m_defaultMimeType = defaultMimeType;
        this.m_parameterPrefix = parameterPrefix != null ? parameterPrefix : "";
        this.add((Component)new Label(mimeLabel, false));
        this.m_mimeWidget = new SingleSelect(this.getMimeTypeWidgetName());
        FileUploadSection.addMimeOptions((OptionGroup)this.m_mimeWidget, mimePrefix);
        this.m_mimeWidget.addOption(new Option(GUESS_MIME, (Component)new Label(GlobalizationUtil.globalize("cms.ui.authoring.file_upload.auto_detect"))));
        this.m_mimeWidget.setDefaultValue((Object)GUESS_MIME);
        this.add((Component)this.m_mimeWidget);
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.upload_new_content")));
        this.m_fileWidget = new FileUpload(this.getFileUploadWidgetName());
        this.add((Component)this.m_fileWidget);
    }

    public FileUploadSection(GlobalizedMessage mimeLabel, String mimePrefix, String defaultMimeType, String parameterPrefix) {
        this(mimeLabel, mimePrefix, defaultMimeType, parameterPrefix, (Container)new ColumnPanel(2, true));
        ColumnPanel panel = (ColumnPanel)this.getPanel();
        panel.setBorder(false);
        panel.setPadColor("#FFFFFF");
    }

    public FileUploadSection(String mimeLabel, String mimePrefix, String defaultMimeType, String parameterPrefix) {
        this(new GlobalizedMessage(mimeLabel), mimePrefix, defaultMimeType, parameterPrefix);
    }

    public FileUploadSection(String mimeLabel, String mimePrefix, String defaultMimeType) {
        this(new GlobalizedMessage(mimeLabel), mimePrefix, defaultMimeType, "");
    }

    public FileUploadSection(GlobalizedMessage mimeLabel, String mimePrefix, String defaultMimeType) {
        this(mimeLabel, mimePrefix, defaultMimeType, "");
    }

    public MimeType getMimeType(FormSectionEvent e) {
        FormData data = e.getFormData();
        String fileName = (String)data.get((Object)this.getFileUploadWidgetName());
        String mimeTypeName = (String)data.get((Object)this.getMimeTypeWidgetName());
        MimeType mimeType = null;
        if (fileName != null) {
            mimeType = GUESS_MIME.equals(mimeTypeName) ? MimeType.guessMimeTypeFromFile((String)fileName) : MimeType.loadMimeType((String)mimeTypeName);
        }
        if (mimeType == null) {
            mimeType = MimeType.loadMimeType((String)this.m_defaultMimeType);
        }
        return mimeType;
    }

    public File getFile(FormSectionEvent e) {
        FormData data = e.getFormData();
        String fileName = this.getFileName(e);
        if (fileName != null && fileName.length() > 0) {
            return ((MultipartHttpServletRequest)e.getPageState().getRequest()).getFile(this.getFileUploadWidgetName());
        }
        return null;
    }

    public String getFileName(FormSectionEvent e) {
        FormData data = e.getFormData();
        return (String)data.get((Object)this.getFileUploadWidgetName());
    }

    public void setMimeType(FormSectionEvent e, String mimeType) {
        FormData data = e.getFormData();
        data.put((Object)this.getMimeTypeWidgetName(), (Object)mimeType);
    }

    public SingleSelect getMimeTypeWidget() {
        return this.m_mimeWidget;
    }

    public FileUpload getFileUploadWidget() {
        return this.m_fileWidget;
    }

    public String getParameterPrefix() {
        return this.m_parameterPrefix;
    }

    public String getFileUploadWidgetName() {
        return this.m_parameterPrefix + FILE_UPLOAD;
    }

    public String getMimeTypeWidgetName() {
        return this.m_parameterPrefix + MIME_TYPE;
    }

    public static void addMimeOptions(OptionGroup w, String mimePrefix) {
        MimeTypeCollection types = mimePrefix == null || mimePrefix.equals("") ? MimeType.getAllMimeTypes() : MimeType.searchMimeTypes((String)(mimePrefix + "/"));
        while (types.next()) {
            MimeType type = types.getMimeType();
            w.addOption(new Option(type.getMimeType(), type.getLabel()));
        }
    }
}

