/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentItemXMLRenderer;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentSectionCollection;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.dispatcher.SimpleXMLGenerator;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.xml.Element;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class FolderContent
extends SimpleComponent {
    private static Logger log = Logger.getLogger(FolderContent.class);
    private static final String TAG_FOLDERCONTENT = "cms:folderContent";
    private static final String TAG_FOLDERCONTENT_SECTION = "section";
    private static final String TAG_FOLDERCONTENT_NAME = "name";
    private static final String TAG_FOLDERCONTENT_RANDOM = "random";
    private static final String TAG_ITEM = "cms:item";
    private static final String CONTENTITEM_CLASS_NAME = ContentItem.class.getName();
    protected String contentSection = null;
    protected String folderName = null;
    protected String randomOne = null;
    protected boolean liveOnly = true;
    protected Folder folder;

    public String getContentSection() {
        return this.contentSection;
    }

    public void setContentSection(String name) {
        this.contentSection = name;
    }

    public String getFolderName() {
        return this.folderName;
    }

    public void setFolderName(String name) {
        this.folderName = name;
    }

    public String getRandomOne() {
        return this.randomOne;
    }

    public void setRandomOne(String random) {
        this.randomOne = random;
    }

    public boolean getLiveOnly() {
        return this.liveOnly;
    }

    public void setLiveOnly(boolean liveOnly) {
        this.liveOnly = liveOnly;
    }

    public Folder getFolder() {
        return this.folder;
    }

    public void setFolder(Folder f) {
        this.folder = f;
        this.setFolderName(f != null ? f.getName() : null);
    }

    public void generateXML(PageState state, Element p) {
        Element parent = p.newChildElement(TAG_FOLDERCONTENT, "http://www.arsdigita.com/cms/1.0");
        parent.addAttribute(TAG_FOLDERCONTENT_SECTION, this.getContentSection());
        parent.addAttribute(TAG_FOLDERCONTENT_NAME, this.getFolderName());
        parent.addAttribute(TAG_FOLDERCONTENT_RANDOM, this.getRandomOne());
        ContentSectionCollection sections = ContentSection.getAllSections();
        ContentSection section = null;
        while (sections.next()) {
            if (!sections.getContentSection().getName().equals(this.getContentSection())) continue;
            section = sections.getContentSection();
            break;
        }
        if (section == null) {
            log.warn((Object)("FolderContent couldn't find the section '" + this.getContentSection() + "'."));
            return;
        }
        if (this.folder == null) {
            Folder root = section.getRootFolder();
            Folder.ItemCollection folders = root.getItems(true);
            folders.addFolderFilter(true);
            while (folders.next()) {
                log.debug((Object)("FolderContent looking at folder '" + folders.getContentItem().getName() + "'."));
                if (!folders.isFolder() || !folders.getContentItem().getName().equals(this.getFolderName())) continue;
                this.folder = (Folder)folders.getContentItem();
                break;
            }
        }
        if (this.folder == null) {
            log.warn((Object)("FolderContent couldn't find the folder '" + this.getFolderName() + "'."));
            return;
        }
        ArrayList<ContentItem> liveItems = new ArrayList<ContentItem>();
        Folder.ItemCollection items = this.folder.getPrimaryInstances();
        while (items.next()) {
            log.debug((Object)("FolderContent looking at item '" + items.getDisplayName() + "'."));
            if (items.isFolder()) continue;
            log.debug((Object)"FolderContent: this is an item, not a Folder.");
            if (this.liveOnly && !items.isLive()) continue;
            log.debug((Object)"FolderContent accepts item.");
            liveItems.add(items.getContentItem());
        }
        if ("true".equals(this.getRandomOne())) {
            if (liveItems.size() > 0) {
                int index = (int)(Math.random() * (double)liveItems.size());
                log.debug((Object)("FolderContent rendering one random item, index: " + index));
                FolderContent.renderItem((ContentItem)liveItems.get(index), parent);
            }
        } else {
            log.debug((Object)"FolderContent rendering all items.");
            for (int i = 0; i < liveItems.size(); ++i) {
                FolderContent.renderItem((ContentItem)liveItems.get(i), parent);
            }
        }
    }

    public static void renderItem(ContentItem item, Element parent) {
        log.debug((Object)("Rendering item '" + item.getName() + "'."));
        Element itemElement = parent.newChildElement(TAG_ITEM, "http://www.arsdigita.com/cms/1.0");
        ContentItemXMLRenderer renderer = new ContentItemXMLRenderer(itemElement);
        renderer.setWrapAttributes(true);
        renderer.setWrapRoot(false);
        renderer.setWrapObjects(false);
        renderer.walk((DomainObject)item, SimpleXMLGenerator.ADAPTER_CONTEXT);
    }
}

