/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.ToggleLink;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.form.Widget;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.TrimmedStringParameter;
import com.arsdigita.bebop.parameters.URLTokenValidationListener;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.ui.CMSContainer;
import com.arsdigita.cms.ui.CMSForm;
import com.arsdigita.cms.ui.ContentSectionPage;
import com.arsdigita.cms.ui.UniqueItemNameValidationListener;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.xml.Element;

public class FolderProperties
extends CMSContainer {
    private FolderInfo m_folderInfo = new FolderInfo();
    private EditFolder m_editFolder;
    private ToggleLink m_editLink;

    public FolderProperties() {
        this.add((Component)this.m_folderInfo);
        this.m_editFolder = new EditFolder();
        this.m_editFolder.addSubmissionListener(new FormSubmissionListener(){

            public void submitted(FormSectionEvent event) throws FormProcessException {
                PageState state = event.getPageState();
                if (FolderProperties.this.m_editFolder.isCancelled(state)) {
                    FolderProperties.this.setDisplayMode(state);
                }
            }
        });
        this.m_editFolder.addProcessListener(new FormProcessListener(){

            public void process(FormSectionEvent event) throws FormProcessException {
                PageState state = event.getPageState();
                FolderProperties.this.setDisplayMode(state);
            }
        });
        this.add((Component)this.m_editFolder);
        this.m_editLink = this.m_folderInfo.getEditLink();
        this.m_editLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PageState state = event.getPageState();
                if (FolderProperties.this.m_editLink.isSelected(state)) {
                    FolderProperties.this.setEditMode(state);
                }
            }
        });
    }

    public void register(Page p) {
        super.register(p);
        this.setDefaultVisibility(p);
    }

    protected void setDefaultVisibility(Page p) {
        p.setVisibleDefault((Component)this.m_folderInfo, true);
        p.setVisibleDefault((Component)this.m_editFolder, false);
    }

    protected void setDisplayMode(PageState state) {
        this.m_editLink.setSelected(state, false);
        this.m_editFolder.setVisible(state, false);
        this.m_folderInfo.setVisible(state, true);
    }

    protected void setEditMode(PageState state) {
        this.m_editFolder.setVisible(state, true);
        this.m_folderInfo.setVisible(state, false);
    }

    private static GlobalizedMessage globalize(String key) {
        return ContentSectionPage.globalize(key);
    }

    public class EditFolder
    extends CMSForm {
        private static final String NAME = "name";
        private static final String LABEL = "label";
        private static final String SUBMIT = "submit";
        private static final String CANCEL = "cancel";
        private static final String ERROR_MSG = "Invalid name. A folder with that name already exists.";
        private TextField m_name;
        private TextField m_label;
        private Submit m_submit;
        private Submit m_cancel;

        public EditFolder() {
            super("Edit Folder");
            this.add((Component)new Label(FolderProperties.globalize("cms.ui.name_prompt")));
            this.m_name = new TextField((ParameterModel)new TrimmedStringParameter(NAME));
            this.m_name.addValidationListener((ParameterListener)new NotNullValidationListener());
            this.m_name.addValidationListener((ParameterListener)new URLTokenValidationListener());
            this.add((Component)this.m_name);
            this.add((Component)new Label(FolderProperties.globalize("cms.ui.label_prompt")));
            this.m_label = new TextField((ParameterModel)new TrimmedStringParameter(LABEL));
            this.m_label.addValidationListener((ParameterListener)new NotNullValidationListener());
            this.add((Component)this.m_label);
            SimpleContainer c = new SimpleContainer();
            this.m_submit = new Submit(SUBMIT, FolderProperties.globalize("cms.ui.save"));
            c.add((Component)this.m_submit);
            this.m_cancel = new Submit(CANCEL, FolderProperties.globalize("cms.ui.cancel"));
            c.add((Component)this.m_cancel);
            this.add((Component)c, 66);
            this.addInitListener(new FormInitListener(){

                public void init(FormSectionEvent event) throws FormProcessException {
                    PageState state = event.getPageState();
                    EditFolder.this.initializeFolder(state);
                }
            });
            this.addSubmissionListener(new FormSubmissionListener(){

                public void submitted(FormSectionEvent event) throws FormProcessException {
                    PageState state = event.getPageState();
                    if (EditFolder.this.isCancelled(state)) {
                        throw new FormProcessException((String)GlobalizationUtil.globalize("cms.ui.cancel_hit").localize());
                    }
                }
            });
            this.addProcessListener(new FormProcessListener(){

                public void process(FormSectionEvent event) throws FormProcessException {
                    PageState state = event.getPageState();
                    EditFolder.this.updateFolder(state);
                }
            });
            UniqueItemNameValidationListener un = new UniqueItemNameValidationListener((Widget)this.m_name, ERROR_MSG);
            this.addValidationListener(un);
        }

        @Override
        public boolean isCancelled(PageState state) {
            return this.m_cancel.isSelected(state);
        }

        protected void initializeFolder(PageState state) {
            Folder f = this.getFolder(state);
            this.m_name.setValue(state, (Object)f.getName());
            this.m_label.setValue(state, (Object)f.getLabel());
        }

        protected void updateFolder(PageState state) {
            String name = (String)this.m_name.getValue(state);
            String label = (String)this.m_label.getValue(state);
            Folder f = this.getFolder(state);
            f.setName(name);
            f.setLabel(label);
            f.save();
        }

        protected Folder getFolder(PageState state) {
            ContentSection section = CMS.getContext().getContentSection();
            return section.getRootFolder();
        }
    }

    public class FolderInfo
    extends CMSContainer {
        private ToggleLink m_editLink = new ToggleLink("Edit");

        public FolderInfo() {
            this.m_editLink.setClassAttr("actionLink");
            this.m_editLink.setIdAttr("edit_link");
            this.add((Component)this.m_editLink);
        }

        public ToggleLink getEditLink() {
            return this.m_editLink;
        }

        public void generateXML(PageState state, Element parent) {
            if (this.isVisible(state)) {
                Element element = new Element("cms:folderInfo", "http://www.arsdigita.com/cms/1.0");
                Folder folder = this.getFolder(state);
                element.addAttribute("name", folder.getName());
                element.addAttribute("label", folder.getLabel());
                this.m_editLink.generateXML(state, element);
                this.exportAttributes(element);
                parent.addContent(element);
            }
        }

        protected Folder getFolder(PageState state) {
            ContentSection section = CMS.getContext().getContentSection();
            Folder folder = section.getRootFolder();
            return folder;
        }
    }
}

