/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.cms.Workspace;
import com.arsdigita.cms.ui.ContentSectionPage;
import com.arsdigita.ui.UI;
import com.arsdigita.web.URL;
import com.arsdigita.xml.Element;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

class GlobalNavigation
extends SimpleComponent {
    private static final Logger s_log = Logger.getLogger(GlobalNavigation.class);
    private final String m_centerPath = Workspace.getURL();
    private final String m_wspcPath = UI.getWorkspaceURL();
    private final String m_signOutPath = UI.getLogoutPageURL();
    private final String m_helpPath;

    GlobalNavigation() {
        this.m_helpPath = "/nowhere";
    }

    public void generateXML(PageState state, Element parent) {
        if (this.isVisible(state)) {
            HttpServletRequest sreq = state.getRequest();
            Element nav = parent.newChildElement("cms:globalNavigation", "http://www.arsdigita.com/cms/1.0");
            String centerTitle = GlobalNavigation.lz("cms.ui.content_center");
            String wspcTitle = GlobalNavigation.lz("cms.ui.my_workspace");
            String signOutTitle = GlobalNavigation.lz("cms.ui.sign_out");
            String helpTitle = GlobalNavigation.lz("cms.ui.help");
            GlobalNavigation.link(sreq, nav, "cms:contentCenter", this.m_centerPath, centerTitle);
            GlobalNavigation.link(sreq, nav, "cms:workspace", this.m_wspcPath, wspcTitle);
            GlobalNavigation.link(sreq, nav, "cms:signOut", this.m_signOutPath, signOutTitle);
            GlobalNavigation.link(sreq, nav, "cms:help", this.m_helpPath, helpTitle);
        }
    }

    private static Element link(HttpServletRequest sreq, Element parent, String name, String path, String title) {
        Element link = parent.newChildElement(name, "http://www.arsdigita.com/cms/1.0");
        link.addAttribute("href", URL.there((HttpServletRequest)sreq, (String)path).toString());
        link.addAttribute("title", title);
        return link;
    }

    private static String lz(String key) {
        return (String)ContentSectionPage.globalize(key).localize();
    }
}

