/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Image;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.TableActionAdapter;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.table.DefaultTableCellRenderer;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ImageAsset;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.Service;
import com.arsdigita.cms.ui.ImageBrowserModel;
import com.arsdigita.cms.ui.ImageBrowserModelBuilder;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.persistence.OID;
import com.arsdigita.util.LockableImpl;
import com.arsdigita.web.URL;
import java.awt.Dimension;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class ImageBrowser
extends Table {
    private ImageBrowserModelBuilder m_builder;
    private static final String[] HEADERS = new String[]{"Thumbnail", "Name", "Size", "Type", "Action", ""};
    private static final int THUMB = 0;
    private static final int NAME = 1;
    private static final int SIZE = 2;
    private static final int TYPE = 3;
    private static final int LINK = 4;
    private static final int DELETE = 5;
    private int m_numColumns = -1;
    private int m_mode;
    private Dimension m_thumbSize;
    private static final Logger s_log = Logger.getLogger(ImageBrowser.class);

    public ImageBrowser(ImageBrowserModelBuilder b) {
        this(b, 2);
    }

    public ImageBrowser(ImageBrowserModelBuilder b, int mode) {
        super((TableModelBuilder)new BuilderAdapter(b), (Object[])HEADERS);
        this.m_mode = mode;
        this.setThumbnailSize(CMS.getConfig().getImageBrowserThumbnailMaxWidth(), CMS.getConfig().getImageBrowserThumbnailMaxHeight());
        this.m_builder = b;
        this.getHeader().setDefaultRenderer((TableCellRenderer)new DefaultTableCellRenderer(false));
        this.addColumn(new ThumbnailCellRenderer());
        this.addColumn((TableCellRenderer)new DefaultTableCellRenderer(false));
        this.addColumn((TableCellRenderer)new DefaultTableCellRenderer(false));
        this.addColumn((TableCellRenderer)new DefaultTableCellRenderer(false));
        this.addColumn((TableCellRenderer)new SelectCellRenderer());
        this.addColumn((TableCellRenderer)new DeleteCellRenderer());
        this.setCellPadding("4");
        this.setBorder("1");
        this.setClassAttr("imageBrowser");
    }

    private void addColumn(TableCellRenderer renderer) {
        this.getColumn(++this.m_numColumns).setCellRenderer(renderer);
    }

    public int getNumColumns() {
        return this.m_numColumns;
    }

    public Dimension getThumbnailSize() {
        return this.m_thumbSize;
    }

    public final void setThumbnailSize(int width, int height) {
        this.m_thumbSize = new Dimension(width, height);
    }

    public ImageBrowserModelBuilder getImageBrowserModelBuilder() {
        return this.m_builder;
    }

    public ImageBrowserModel getImageBrowserModel(PageState state) {
        return ((ImageModelAdapter)this.getTableModel(state)).getModel();
    }

    private static class ImageModelAdapter
    implements TableModel {
        private ImageBrowserModel m_model;

        public ImageModelAdapter(ImageBrowserModel m) {
            this.m_model = m;
        }

        public int getColumnCount() {
            return ((ImageBrowser)((Object)this.m_model)).getNumColumns();
        }

        public boolean nextRow() {
            return this.m_model.nextRow();
        }

        public Object getElementAt(int columnIndex) {
            ImageAsset a = this.m_model.getImageAsset();
            switch (columnIndex) {
                case 0: {
                    return a;
                }
                case 1: {
                    return a.getName();
                }
                case 2: {
                    StringBuilder buf = new StringBuilder();
                    BigDecimal v = a.getWidth();
                    if (v == null) {
                        buf.append("???");
                    } else {
                        buf.append(v.toString());
                    }
                    buf.append(" x ");
                    v = a.getHeight();
                    if (v == null) {
                        buf.append("???");
                    } else {
                        buf.append(v.toString());
                    }
                    return buf.toString();
                }
                case 3: {
                    MimeType m = a.getMimeType();
                    if (m == null) {
                        return "???";
                    }
                    return m.getMimeType();
                }
                case 4: {
                    return "select";
                }
                case 5: {
                    return "delete";
                }
            }
            return null;
        }

        public Object getKeyAt(int columnIndex) {
            return this.m_model.getImageAsset().getID();
        }

        public ImageBrowserModel getModel() {
            return this.m_model;
        }
    }

    private static class BuilderAdapter
    extends LockableImpl
    implements TableModelBuilder {
        private ImageBrowserModelBuilder m_builder;

        public BuilderAdapter(ImageBrowserModelBuilder b) {
            this.m_builder = b;
        }

        public TableModel makeModel(Table t, PageState s) {
            return new ImageModelAdapter(this.m_builder.makeModel((ImageBrowser)t, s));
        }

        public void lock() {
            this.m_builder.lock();
            super.lock();
        }
    }

    private class DeleteCellRenderer
    extends DefaultTableCellRenderer {
        public DeleteCellRenderer() {
            super(true);
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            if (ImageBrowser.this.m_mode == 3) {
                boolean canDelete = false;
                SecurityManager sm = CMS.getSecurityManager(state);
                if (sm.canAccess(state.getRequest(), "delete_images")) {
                    try {
                        ImageAsset asset = (ImageAsset)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.cms.ImageAsset", (Object)((BigDecimal)key)));
                    }
                    catch (DataObjectNotFoundException e) {
                        // empty catch block
                    }
                }
                if (canDelete) {
                    return super.getComponent(table, state, value, isSelected, key, row, column);
                }
            }
            return new Label("");
        }
    }

    private class SelectCellRenderer
    extends DefaultTableCellRenderer {
        public SelectCellRenderer() {
            super(true);
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            if (ImageBrowser.this.m_mode == 1 || ImageBrowser.this.m_mode == 2) {
                return super.getComponent(table, state, value, isSelected, key, row, column);
            }
            return new Label("");
        }
    }

    private class ThumbnailCellRenderer
    implements TableCellRenderer {
        private ThumbnailCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            ImageAsset a = (ImageAsset)value;
            String url = Service.getImageURL(a);
            String resizeParam = "&maxWidth=" + new Double(ImageBrowser.this.m_thumbSize.getWidth()).intValue() + "&maxHeight=" + new Double(ImageBrowser.this.m_thumbSize.getHeight()).intValue();
            Image img = new Image(URL.getDispatcherPath() + url + resizeParam, a.getName());
            img.setBorder("0");
            return new Link((Component)img, url);
        }
    }

    public static abstract class LinkActionListener
    extends TableActionAdapter {
        public void cellSelected(TableActionEvent e) {
            int c = e.getColumn();
            if (c == 4) {
                this.linkClicked(e.getPageState(), new BigDecimal((String)e.getRowKey()));
            } else if (c == 5) {
                this.deleteClicked(e.getPageState(), new BigDecimal((String)e.getRowKey()));
            }
        }

        public abstract void linkClicked(PageState var1, BigDecimal var2);

        public abstract void deleteClicked(PageState var1, BigDecimal var2);
    }
}

