/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.PaginationModelBuilder;
import com.arsdigita.bebop.Paginator;
import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ui.DefaultImageBrowserModelBuilder;
import com.arsdigita.cms.ui.ImageBrowser;
import com.arsdigita.cms.util.GlobalizationUtil;

public class ImageChooser
extends BoxPanel {
    private ImageKeywordForm m_form;
    private ImageBrowser m_browser;
    private Paginator m_paginator;
    private StringParameter m_keyword = new StringParameter("kw");
    private SingleSelectionModel m_sel = new ParameterSingleSelectionModel((ParameterModel)this.m_keyword);
    public static final String KEYWORD = "kw";
    public static int LIST_SIZE = 20;

    public ImageChooser(String context, int mode) {
        super(2);
        this.m_form = new ImageKeywordForm(this.m_sel);
        DefaultImageBrowserModelBuilder modelBuilder = new DefaultImageBrowserModelBuilder(this.m_sel, context);
        this.m_browser = new ImageBrowser(modelBuilder, mode);
        modelBuilder.setImageBrowser(this.m_browser);
        this.m_paginator = new Paginator((PaginationModelBuilder)modelBuilder, LIST_SIZE);
        super.add((Component)this.m_form);
        super.add((Component)this.m_paginator);
        super.add((Component)this.m_browser);
    }

    public ImageChooser(String context) {
        this(context, 2);
    }

    public ImageChooser(int mode) {
        this("draft", mode);
    }

    public ImageChooser() {
        this("draft", 2);
    }

    public void register(Page p) {
        p.addComponent((Component)this);
        p.addComponentStateParam((Component)this, (ParameterModel)this.m_keyword);
    }

    public void addImageActionListener(TableActionListener l) {
        this.m_browser.addTableActionListener(l);
    }

    public void addFormSubmissionListener(FormSubmissionListener l) {
        this.m_form.addSubmissionListener(l);
    }

    public Submit getFormCancelButton() {
        return this.m_form.getSaveCancelSection().getCancelButton();
    }

    public SingleSelectionModel getKeywordModel() {
        return this.m_sel;
    }

    public void setKeyword(PageState state, String word) {
        this.m_sel.setSelectedKey(state, (Object)word);
    }

    public void clearSelection(PageState state) {
        this.m_browser.clearSelection(state);
    }

    public String getKeyword(PageState state) {
        return (String)this.m_sel.getSelectedKey(state);
    }

    public ImageKeywordForm getForm() {
        return this.m_form;
    }

    public ImageBrowser getImageBrowser() {
        return this.m_browser;
    }

    public void clearKeyword(PageState s) {
        this.m_sel.clearSelection(s);
    }

    public static class ImageKeywordForm
    extends Form
    implements FormProcessListener,
    FormInitListener {
        private SingleSelectionModel m_sel;
        private SaveCancelSection m_saveCancel;
        public static String WORD = "word";

        public ImageKeywordForm(SingleSelectionModel sel) {
            super("ImageKeywordForm", (Container)new BoxPanel(1));
            this.m_sel = sel;
            this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.enter_a_keyword")));
            TextField keyword = new TextField(WORD);
            this.add((Component)keyword);
            this.m_saveCancel = new SaveCancelSection();
            this.m_saveCancel.getSaveButton().setButtonLabel(GlobalizationUtil.globalize("cms.ui.search"));
            this.m_saveCancel.getCancelButton().setButtonLabel(GlobalizationUtil.globalize("cms.ui.clear"));
            this.add((Component)this.m_saveCancel);
            this.addProcessListener(this);
            this.addInitListener(this);
            this.setClassAttr("imageKeywordForm");
        }

        public void init(FormSectionEvent event) throws FormProcessException {
            PageState state = event.getPageState();
            FormData data = event.getFormData();
            data.put((Object)WORD, this.m_sel.getSelectedKey(state));
        }

        public SaveCancelSection getSaveCancelSection() {
            return this.m_saveCancel;
        }

        public SingleSelectionModel getKeywordModel() {
            return this.m_sel;
        }

        public void process(FormSectionEvent event) {
            FormData data = event.getFormData();
            PageState state = event.getPageState();
            if (this.m_saveCancel.getCancelButton().isSelected(state)) {
                this.m_sel.clearSelection(event.getPageState());
                data.put((Object)WORD, null);
            } else {
                this.m_sel.setSelectedKey(state, (Object)((String)data.get((Object)WORD)));
            }
        }
    }
}

