/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.MapComponentSelectionModel;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.cms.ReusableImageAsset;
import com.arsdigita.cms.ui.ImageComponent;
import com.arsdigita.cms.ui.ImageComponentSelectListener;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class ImageComponentAbstractListener
implements FormInitListener,
FormProcessListener,
FormSubmissionListener {
    private static final Logger s_log = Logger.getLogger(ImageComponentSelectListener.class);
    MapComponentSelectionModel m_imageComponent;

    public ImageComponentAbstractListener(MapComponentSelectionModel imageComponent) {
        this.m_imageComponent = imageComponent;
    }

    public void init(FormSectionEvent event) throws FormProcessException {
        PageState ps = event.getPageState();
        if (!this.m_imageComponent.isSelected(ps)) {
            this.setImageComponent(ps, "library");
        }
    }

    public void submitted(FormSectionEvent event) throws FormProcessException {
        PageState ps = event.getPageState();
        ImageComponent component = this.getImageComponent(ps);
        if (component.getSaveCancelSection().getCancelButton().isSelected(ps)) {
            this.cancelled(ps);
        }
    }

    public void process(FormSectionEvent event) throws FormProcessException {
        PageState ps = event.getPageState();
        ImageComponent component = this.getImageComponent(ps);
        if (!component.getSaveCancelSection().getSaveButton().isSelected(ps)) {
            return;
        }
        ReusableImageAsset image = component.getImage(event);
        this.processImage(event, ps, component, image);
    }

    protected void cancelled(PageState ps) {
    }

    protected abstract void processImage(FormSectionEvent var1, PageState var2, ImageComponent var3, ReusableImageAsset var4);

    protected ImageComponent getImageComponent(PageState ps) {
        if (!this.m_imageComponent.isSelected(ps)) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"No component selected");
                s_log.debug((Object)("Selected: " + this.m_imageComponent.getComponent(ps)));
            }
            this.m_imageComponent.setSelectedKey(ps, (Object)"upload");
        }
        return (ImageComponent)this.m_imageComponent.getComponent(ps);
    }

    protected void setImageComponent(PageState ps, String activeKey) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Selected component: " + activeKey));
        }
        Map componentsMap = this.m_imageComponent.getComponentsMap();
        for (Object key : componentsMap.keySet()) {
            Component component = (Component)componentsMap.get(key);
            boolean isVisible = activeKey.equals(key);
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Key: " + key + "; Visibility: " + isVisible));
            }
            ps.setVisible(component, isVisible);
        }
    }
}

