/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Resettable;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.ReusableImageAsset;
import com.arsdigita.cms.ui.ImageBrowser;
import com.arsdigita.cms.ui.ImageChooser;
import com.arsdigita.cms.ui.ImageComponent;
import com.arsdigita.cms.ui.ImageSelectPage;
import com.arsdigita.cms.ui.ImagesPane;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import java.math.BigDecimal;

public class ImageLibraryComponent
extends SimpleContainer
implements ImageComponent,
Resettable {
    private final ImageChooser m_chooser;
    private final ItemSelectionModel m_imageModel;
    private final BigDecimalParameter m_imageID;
    private final Form m_form;
    private final TextField m_caption;
    private final TextField m_description;
    private final TextField m_title;
    private final TextField m_useContext;
    private final SaveCancelSection m_saveCancel;
    private int m_mode;

    public ImageLibraryComponent() {
        this(2, null);
    }

    public ImageLibraryComponent(int mode) {
        this(mode, null);
    }

    public ImageLibraryComponent(int mode, final ImageSelectPage parent) {
        this.m_mode = mode;
        this.m_imageID = new BigDecimalParameter("imageID");
        this.m_imageModel = new ItemSelectionModel(this.m_imageID);
        this.m_chooser = new ImageChooser("draft", this.m_mode);
        this.m_chooser.addImageActionListener((TableActionListener)new ImageBrowser.LinkActionListener(){

            @Override
            public void deleteClicked(PageState state, BigDecimal imageID) {
                ImagesPane.S_LOG.debug((Object)"Clicked delete");
                ReusableImageAsset image = new ReusableImageAsset(imageID);
                image.delete();
            }

            @Override
            public void linkClicked(PageState state, BigDecimal imageID) {
                ImagesPane.S_LOG.debug((Object)"Clicked select");
                try {
                    ReusableImageAsset image = new ReusableImageAsset(imageID);
                    if (ImageLibraryComponent.this.m_mode == 1) {
                        parent.getResultComponent().setResult(image);
                    }
                    ImageLibraryComponent.this.m_imageModel.setSelectedObject(state, (DomainObject)image);
                }
                catch (DataObjectNotFoundException ex) {
                    ImagesPane.S_LOG.error((Object)("Selected non-existant image: " + imageID), (Throwable)ex);
                }
            }
        });
        this.add((Component)this.m_chooser);
        this.m_form = new Form("imageLibraryComponent", (Container)new ColumnPanel(2));
        this.add((Component)this.m_form);
        this.m_caption = new TextField("caption");
        this.m_description = new TextField("description");
        this.m_title = new TextField("title");
        this.m_useContext = new TextField("useContext");
        if (this.m_mode == 2) {
            this.m_form.add((Component)new Label("Caption"));
            this.m_caption.addValidationListener((ParameterListener)new NotNullValidationListener());
            this.m_caption.setSize(40);
            this.m_form.add((Component)this.m_caption);
            this.m_description.addValidationListener((ParameterListener)new NotNullValidationListener());
            this.m_description.setSize(40);
            this.m_title.addValidationListener((ParameterListener)new NotNullValidationListener());
            this.m_title.setSize(40);
            this.m_form.add((Component)new Label("Use Context"));
            this.m_useContext.setSize(40);
            this.m_form.add((Component)this.m_useContext);
        }
        this.m_saveCancel = new SaveCancelSection();
        this.m_saveCancel.getSaveButton().setOnClick("selectImage(this)");
        this.m_saveCancel.getCancelButton().setOnClick("selectImage(this)");
        if (this.m_mode == 1 || this.m_mode == 2) {
            this.m_form.add((Component)this.m_saveCancel);
        }
    }

    @Override
    public ReusableImageAsset getImage(FormSectionEvent event) {
        PageState state = event.getPageState();
        return (ReusableImageAsset)this.m_imageModel.getSelectedItem(state);
    }

    public void register(Page page) {
        super.register(page);
        page.addComponentStateParam((Component)this, (ParameterModel)this.m_imageID);
    }

    @Override
    public String getCaption(FormSectionEvent event) {
        PageState state = event.getPageState();
        return (String)this.m_caption.getValue(state);
    }

    @Override
    public String getDescription(FormSectionEvent event) {
        PageState state = event.getPageState();
        return (String)this.m_description.getValue(state);
    }

    @Override
    public String getTitle(FormSectionEvent event) {
        PageState state = event.getPageState();
        return (String)this.m_title.getValue(state);
    }

    @Override
    public String getUseContext(FormSectionEvent event) {
        PageState state = event.getPageState();
        return (String)this.m_useContext.getValue(state);
    }

    @Override
    public Form getForm() {
        return this.m_form;
    }

    @Override
    public SaveCancelSection getSaveCancelSection() {
        return this.m_saveCancel;
    }

    public void addUploadLink(ActionListener actionListener) {
        if (this.m_mode != 0) {
            ActionLink upload = new ActionLink("Upload new image");
            upload.addActionListener(actionListener);
            this.add((Component)upload, 64);
        }
    }

    public void reset(PageState state) {
        this.m_imageModel.clearSelection(state);
        this.m_chooser.clearSelection(state);
        this.m_chooser.clearKeyword(state);
    }
}

