/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.MapComponentSelectionModel;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.TabbedPane;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.CMSConfig;
import com.arsdigita.cms.dispatcher.CMSPage;
import com.arsdigita.cms.ui.ImageComponentSelectListener;
import com.arsdigita.cms.ui.ImageLibraryComponent;
import com.arsdigita.cms.ui.ImageSelectResultComponent;
import com.arsdigita.cms.ui.ImageUploadComponent;
import com.arsdigita.cms.ui.ImagesPane;
import com.arsdigita.cms.util.GlobalizationUtil;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ImageSelectPage
extends CMSPage {
    private static final Logger S_LOG = Logger.getLogger(ImagesPane.class);
    private static final String XSL_CLASS = "CMS Admin";
    private TabbedPane m_tabbedPane;
    private ImageLibraryComponent m_imageLibrary;
    private ImageUploadComponent m_imageUpload;
    private ImageSelectResultComponent m_result;
    private BigDecimalParameter m_sectionId;
    private final StringParameter m_imageComponentKey;
    private final MapComponentSelectionModel m_imageComponent;
    private final ImageComponentSelectListener m_selectListener;
    private static final CMSConfig s_conf = CMSConfig.getInstance();
    public static final String CONTENT_SECTION = "section_id";
    public static final String RESULT = "result";

    public ImageSelectPage() {
        super(GlobalizationUtil.globalize("cms.ui.image_select.page_title").localize().toString(), (Container)new SimpleContainer());
        this.setClassAttr("cms-admin");
        this.m_sectionId = new BigDecimalParameter(CONTENT_SECTION);
        this.addGlobalStateParam((ParameterModel)this.m_sectionId);
        this.m_imageComponentKey = new StringParameter("imageComponent");
        ParameterSingleSelectionModel componentModel = new ParameterSingleSelectionModel((ParameterModel)this.m_imageComponentKey);
        this.m_imageComponent = new MapComponentSelectionModel((SingleSelectionModel)componentModel, new HashMap());
        this.m_selectListener = new ImageComponentSelectListener(this.m_imageComponent, this.getResultComponent());
        this.m_tabbedPane = this.createTabbedPane();
        this.m_tabbedPane.setIdAttr("page-body");
        this.add((Component)this.m_tabbedPane);
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PageState ps = event.getPageState();
                if (ImageSelectPage.this.m_tabbedPane.getCurrentPane(ps).equals(ImageSelectPage.this.m_imageLibrary)) {
                    ImageSelectPage.this.m_imageComponent.setSelectedKey(ps, (Object)"library");
                }
                if (ImageSelectPage.this.m_tabbedPane.getCurrentPane(ps).equals(ImageSelectPage.this.m_imageUpload)) {
                    ImageSelectPage.this.m_imageComponent.setSelectedKey(ps, (Object)"upload");
                }
            }
        });
        this.add((Component)this.m_result);
        this.addGlobalStateParam((ParameterModel)this.m_imageComponentKey);
    }

    protected ImageLibraryComponent getImageLibraryPane() {
        if (this.m_imageLibrary == null) {
            this.m_imageLibrary = new ImageLibraryComponent(1, this);
            this.m_imageLibrary.getForm().addInitListener((FormInitListener)this.m_selectListener);
            this.m_imageLibrary.getForm().addProcessListener((FormProcessListener)this.m_selectListener);
            this.m_imageComponent.getComponentsMap().put("library", this.m_imageLibrary);
        }
        return this.m_imageLibrary;
    }

    protected ImageUploadComponent getImageUploadPane() {
        if (this.m_imageUpload == null) {
            this.m_imageUpload = new ImageUploadComponent(1);
            this.m_imageUpload.getForm().addInitListener((FormInitListener)this.m_selectListener);
            this.m_imageUpload.getForm().addProcessListener((FormProcessListener)this.m_selectListener);
            this.m_imageComponent.getComponentsMap().put("upload", this.m_imageUpload);
        }
        return this.m_imageUpload;
    }

    protected ImageSelectResultComponent getResultComponent() {
        if (this.m_result == null) {
            this.m_result = new ImageSelectResultComponent();
        }
        return this.m_result;
    }

    protected TabbedPane createTabbedPane() {
        TabbedPane pane = new TabbedPane();
        pane.setClassAttr(XSL_CLASS);
        this.addToPane(pane, "library", (Component)this.getImageLibraryPane());
        this.addToPane(pane, "upload", (Component)this.getImageUploadPane());
        pane.setDefaultPane((Component)this.m_imageLibrary);
        return pane;
    }

    protected void addToPane(TabbedPane pane, String tabName, Component comp) {
        if (comp != null) {
            pane.addTab(GlobalizationUtil.globalize("cms.ui.image_" + tabName).localize().toString(), comp);
        }
    }
}

