/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.StringLengthValidationListener;
import com.arsdigita.cms.ReusableImageAsset;
import com.arsdigita.cms.ui.FileUploadSection;
import com.arsdigita.cms.ui.ImageComponent;
import com.arsdigita.cms.ui.ImagesPane;
import java.io.File;
import java.io.IOException;

public class ImageUploadComponent
extends Form
implements ImageComponent {
    private final FileUploadSection m_imageFile;
    private final TextField m_caption;
    private final TextField m_title;
    private final TextArea m_description;
    private final TextField m_useContext;
    private final SaveCancelSection m_saveCancel;
    private int m_mode;

    public ImageUploadComponent() {
        this(2);
    }

    public ImageUploadComponent(int mode) {
        super("imageUploadComponent", (Container)new ColumnPanel(2));
        this.m_mode = mode;
        this.setEncType("multipart/form-data");
        this.m_imageFile = new FileUploadSection("Image Type", "image", "image/jpeg");
        this.m_imageFile.getFileUploadWidget().addValidationListener((ParameterListener)new NotNullValidationListener());
        this.add((Component)this.m_imageFile, 64);
        this.m_caption = new TextField("caption");
        this.m_title = new TextField("title");
        this.m_description = new TextArea("description");
        this.m_useContext = new TextField("useContext");
        if (this.m_mode == 2) {
            this.add((Component)new Label("Caption"));
            this.m_caption.addValidationListener((ParameterListener)new NotNullValidationListener());
            this.m_caption.addValidationListener((ParameterListener)new StringLengthValidationListener(40));
            this.m_caption.setSize(40);
            this.add((Component)this.m_caption);
            this.add((Component)new Label("Use Context"));
            this.m_useContext.setSize(40);
            this.add((Component)this.m_useContext);
        }
        this.m_saveCancel = new SaveCancelSection();
        this.add((Component)this.m_saveCancel);
    }

    @Override
    public SaveCancelSection getSaveCancelSection() {
        return this.m_saveCancel;
    }

    @Override
    public ReusableImageAsset getImage(FormSectionEvent event) throws FormProcessException {
        PageState ps = event.getPageState();
        String filename = this.m_imageFile.getFileName(event);
        File imageFile = this.m_imageFile.getFile(event);
        try {
            ReusableImageAsset image = new ReusableImageAsset();
            image.loadFromFile(filename, imageFile, "image/jpeg");
            return image;
        }
        catch (IOException ex) {
            ImagesPane.S_LOG.error((Object)"Error loading image from file", (Throwable)ex);
            throw new FormProcessException(ex.getMessage());
        }
    }

    @Override
    public String getCaption(FormSectionEvent event) {
        PageState ps = event.getPageState();
        return (String)this.m_caption.getValue(ps);
    }

    @Override
    public String getDescription(FormSectionEvent event) {
        PageState ps = event.getPageState();
        return (String)this.m_description.getValue(ps);
    }

    @Override
    public String getTitle(FormSectionEvent event) {
        PageState ps = event.getPageState();
        return (String)this.m_title.getValue(ps);
    }

    @Override
    public String getUseContext(FormSectionEvent event) {
        PageState ps = event.getPageState();
        return (String)this.m_useContext.getValue(ps);
    }

    @Override
    public Form getForm() {
        return this;
    }
}

