/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormModel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.ListPanel;
import com.arsdigita.bebop.MapComponentSelectionModel;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.Resettable;
import com.arsdigita.bebop.SegmentedPanel;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ui.ImageComponentAdminListener;
import com.arsdigita.cms.ui.ImageLibraryComponent;
import com.arsdigita.cms.ui.ImageUploadComponent;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.toolbox.ui.ActionGroup;
import com.arsdigita.toolbox.ui.ComponentMap;
import com.arsdigita.toolbox.ui.LayoutPanel;
import com.arsdigita.toolbox.ui.Section;
import com.arsdigita.util.Assert;
import com.arsdigita.util.LockableImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class ImagesPane
extends LayoutPanel
implements Resettable {
    public static final Logger S_LOG = Logger.getLogger(ImagesPane.class);
    private final StringParameter m_imageComponentKey;
    private final MapComponentSelectionModel m_imageComponent;
    private final ImageComponentAdminListener m_adminListener;
    private ListPanel m_listPanel;
    private final SegmentedPanel m_body;
    private HashMap<String, SegmentedPanel.Segment> m_bodySegments = new HashMap();
    private final ResettableParameterSingleSelectionModel m_model = new ResettableParameterSingleSelectionModel((ParameterModel)new StringParameter("sel"));
    private final List m_links;
    private final LinksSection m_modes;

    public ImagesPane() {
        this.m_model.setDefaultSelection("library");
        this.m_model.addChangeListener(new ImageAdminSelectionListener());
        this.m_links = new List((ListModelBuilder)new ImageAdminListModelBuilder());
        this.m_links.setSelectionModel((SingleSelectionModel)this.m_model);
        SimpleContainer left = new SimpleContainer();
        this.setLeft((Component)left);
        this.m_modes = new LinksSection();
        left.add((Component)this.m_modes);
        this.m_body = new SegmentedPanel();
        this.setBody((Component)this.m_body);
        this.m_imageComponentKey = new StringParameter("imageComponent");
        ParameterSingleSelectionModel componentModel = new ParameterSingleSelectionModel((ParameterModel)this.m_imageComponentKey);
        this.m_imageComponent = new MapComponentSelectionModel((SingleSelectionModel)componentModel, new HashMap());
        Map selectors = this.m_imageComponent.getComponentsMap();
        this.m_adminListener = new ImageComponentAdminListener(this.m_imageComponent, (ComponentMap)this);
        ImageLibraryComponent library = new ImageLibraryComponent(3);
        library.getForm().addInitListener((FormInitListener)this.m_adminListener);
        library.getForm().addProcessListener((FormProcessListener)this.m_adminListener);
        selectors.put("library", library);
        this.m_bodySegments.put("library", this.m_body.addSegment((Component)new Label(GlobalizationUtil.globalize("cms.ui.image_library")), (Component)library));
        ImageUploadComponent upload = new ImageUploadComponent(3);
        upload.getForm().addInitListener((FormInitListener)this.m_adminListener);
        upload.getForm().addSubmissionListener((FormSubmissionListener)this.m_adminListener);
        upload.getForm().addProcessListener((FormProcessListener)this.m_adminListener);
        selectors.put("upload", upload);
        this.m_bodySegments.put("upload", this.m_body.addSegment((Component)new Label(GlobalizationUtil.globalize("cms.ui.image_upload")), (Component)upload));
    }

    public final void register(Page page) {
        super.register(page);
        for (String key : this.m_bodySegments.keySet()) {
            page.setVisibleDefault((Component)this.m_bodySegments.get(key), this.m_model.getDefaultSelection().equals(key));
        }
        page.addComponentStateParam((Component)this, (ParameterModel)this.m_imageComponentKey);
    }

    public final void reset(PageState state) {
        super.reset(state);
        this.m_model.reset(state);
        this.setActiveImageComponent(state, this.m_model.getDefaultSelection());
    }

    public final void setActiveImageComponent(PageState state, String activeComp) {
        Iterator<String> keys = this.m_bodySegments.keySet().iterator();
        this.m_imageComponent.setSelectedKey(state, (Object)activeComp);
        while (keys.hasNext()) {
            String key = keys.next();
            boolean visibility = key.equals(activeComp);
            state.setVisible((Component)this.m_bodySegments.get(key), visibility);
            for (int index = 0; index < this.m_bodySegments.get(key).size(); ++index) {
                Component component = this.m_bodySegments.get(key).get(index);
                if (component instanceof Resettable) {
                    ((Resettable)component).reset(state);
                }
                component.setVisible(state, visibility);
            }
        }
    }

    private class LinksSection
    extends Section {
        LinksSection() {
            this.setHeading(GlobalizationUtil.globalize("cms.ui.images_links"));
            ActionGroup group = new ActionGroup();
            this.setBody((Component)group);
            group.setSubject((Component)ImagesPane.this.m_links);
        }
    }

    private class ImageAdminSelectionListener
    implements ChangeListener {
        private ImageAdminSelectionListener() {
        }

        public final void stateChanged(ChangeEvent e) {
            S_LOG.debug((Object)"Selection state changed; I may change the body's visible pane");
            PageState state = e.getPageState();
            if (ImagesPane.this.m_model.isSelected(state)) {
                S_LOG.debug((Object)"The selection model is selected; displaying the item pane");
                ImagesPane.this.setActiveImageComponent(state, state.getControlEventValue());
            }
        }
    }

    private class ImageAdminListModelBuilder
    extends LockableImpl
    implements ListModelBuilder {
        private ImageAdminListModelBuilder() {
        }

        public ListModel makeModel(List list, PageState state) {
            ArrayList<String> keys = new ArrayList<String>(2);
            keys.add("library");
            keys.add("upload");
            return new ImageAdminListModel(keys);
        }
    }

    private class ImageAdminListModel
    implements ListModel {
        private ArrayList<String> m_keys;
        private int m_index = -1;

        public ImageAdminListModel(ArrayList keys) {
            this.m_keys = keys;
        }

        public boolean next() {
            return this.m_index++ < this.m_keys.size() - 1;
        }

        public Object getElement() {
            return GlobalizationUtil.globalize("cms.ui.image_" + this.m_keys.get(this.m_index)).localize();
        }

        public String getKey() {
            return this.m_keys.get(this.m_index);
        }
    }

    private class ResettableParameterSingleSelectionModel
    extends ParameterSingleSelectionModel
    implements Resettable {
        private String defaultKey;

        public ResettableParameterSingleSelectionModel(ParameterModel m) {
            super(m);
        }

        public void setDefaultSelection(String selKey) {
            this.defaultKey = selKey;
        }

        public String getDefaultSelection() {
            return this.defaultKey;
        }

        public void reset(PageState state) {
            if (Assert.isEnabled()) {
                FormModel model = state.getPage().getStateModel();
                Assert.isTrue((boolean)model.containsFormParam(this.getStateParameter()));
            }
            state.setValue(this.getStateParameter(), (Object)this.defaultKey);
        }
    }
}

