/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Resettable;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.Tree;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.TreeExpansionEvent;
import com.arsdigita.bebop.event.TreeExpansionListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.tree.TreeModelBuilder;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentSectionCollection;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.ui.CMSContainer;
import com.arsdigita.cms.ui.ItemSearchFolderBrowser;
import com.arsdigita.cms.ui.authoring.NewItemForm;
import com.arsdigita.cms.ui.folder.FolderRequestLocal;
import com.arsdigita.cms.ui.folder.FolderSelectionModel;
import com.arsdigita.cms.ui.folder.FolderTreeModelBuilder;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.persistence.OID;
import com.arsdigita.toolbox.ui.OIDParameter;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class ItemSearchBrowsePane
extends CMSContainer
implements Resettable,
TreeExpansionListener,
ChangeListener,
FormProcessListener,
FormSubmissionListener {
    private static final String CONTENT_TYPE_ID = "ct";
    private static final Logger s_log = Logger.getLogger(ItemSearchBrowsePane.class);
    private FolderSelectionModel m_folderSel;
    private FolderRequestLocal m_folder;
    private Tree m_tree;
    private ItemSearchFolderBrowser m_browser;
    private SingleSelect m_section;
    private SingleSelectionModel m_typeSel;

    public ItemSearchBrowsePane() {
        this.setClassAttr("sidebarNavPanel");
        this.setAttribute("navbar-title", GlobalizationUtil.globalize("cms.ui.folder_browser").localize().toString());
        Label l = new Label(GlobalizationUtil.globalize("cms.ui.folder_browser"));
        l.setClassAttr("heading");
        this.add((Component)l);
        boolean linksOnlyInSameSubsite = ContentSection.getConfig().getLinksOnlyInSameSubsite();
        s_log.debug((Object)("linksOnlyInSameSubsite value is " + linksOnlyInSameSubsite));
        this.m_tree = new Tree((TreeModelBuilder)new FolderTreeModelBuilder(){

            @Override
            protected Folder getRoot(PageState ps) {
                Folder root = ItemSearchBrowsePane.this.getRootFolder(ps);
                if (null == root) {
                    return super.getRoot(ps);
                }
                return root;
            }
        });
        this.m_folderSel = this.createFolderSelectionModel();
        this.m_folderSel.addChangeListener(this);
        this.m_folder = new FolderRequestLocal((SingleSelectionModel)this.m_folderSel);
        if (!linksOnlyInSameSubsite) {
            Form sectionForm = this.getSectionForm();
            this.add((Component)sectionForm);
        }
        this.m_tree.setSelectionModel((SingleSelectionModel)this.m_folderSel);
        this.m_tree.setClassAttr("navbar");
        this.m_tree.addTreeExpansionListener((TreeExpansionListener)this);
        this.add((Component)this.m_tree);
        CMSContainer container = new CMSContainer();
        container.setClassAttr("main");
        this.m_browser = new ItemSearchFolderBrowser(this.m_folderSel);
        container.add((Component)this.m_browser);
        container.add((Component)this.m_browser.getPaginator());
        this.add((Component)container);
    }

    public boolean isVisible(PageState s) {
        if (this.m_tree.isCollapsed(this.getRootFolder(s).getID().toString(), s)) {
            this.m_tree.expand(this.getRootFolder(s).getID().toString(), s);
        }
        return super.isVisible(s);
    }

    private Form getSectionForm() {
        Form sectionForm = new Form("isfbSectionForm", (Container)new BoxPanel(1));
        sectionForm.setClassAttr("navbar");
        this.m_section = new SingleSelect((ParameterModel)new OIDParameter("isfbSection"));
        ContentSectionCollection sections = ContentSection.getAllSections();
        while (sections.next()) {
            ContentSection section = sections.getContentSection();
            this.m_section.addOption(new Option(section.getOID().toString(), section.getDisplayName()));
        }
        sectionForm.addInitListener(new FormInitListener(){

            public void init(FormSectionEvent ev) {
                PageState ps = ev.getPageState();
                if (null == ItemSearchBrowsePane.this.m_section.getValue(ps)) {
                    ContentSection section = CMS.getContext().getContentSection();
                    ItemSearchBrowsePane.this.m_section.setValue(ps, (Object)section.getOID());
                }
            }
        });
        sectionForm.add((Component)this.m_section);
        sectionForm.add((Component)new Submit("Change Section"));
        return sectionForm;
    }

    private Folder getRootFolder(PageState ps) {
        s_log.debug((Object)"Getting the root folder.");
        if (this.m_section != null) {
            OID sectionOID = (OID)this.m_section.getValue(ps);
            if (s_log.isDebugEnabled()) {
                if (null != sectionOID) {
                    s_log.debug((Object)("Using section " + sectionOID.toString()));
                } else {
                    s_log.debug((Object)"Using default section");
                }
            }
            if (null == sectionOID) {
                return null;
            }
            ContentSection section = (ContentSection)DomainObjectFactory.newInstance((OID)sectionOID);
            return section.getRootFolder();
        }
        return null;
    }

    public void register(Page p) {
        super.register(p);
        p.addComponentStateParam((Component)this, this.m_folderSel.getStateParameter());
        if (this.m_section != null) {
            p.addComponentStateParam((Component)this, this.m_section.getParameterModel());
        }
        p.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                if (state.isVisibleOnPage((Component)ItemSearchBrowsePane.this)) {
                    ItemSearchBrowsePane.this.showHideSegments(state);
                }
            }
        });
    }

    private void showHideSegments(PageState state) {
        SecurityManager sm = Utilities.getSecurityManager(state);
        Folder folder = this.m_folder.getFolder(state);
        Assert.exists((Object)folder);
    }

    public void reset(PageState s) {
    }

    public ItemSearchFolderBrowser getFolderBrowser() {
        return this.m_browser;
    }

    public final FolderSelectionModel getFolderSelectionModel() {
        return this.m_folderSel;
    }

    protected void setSelectedFolder(PageState s, String key) {
        this.m_browser.getFolderSelectionModel().setSelectedKey(s, key);
        this.m_folderSel.setSelectedKey(s, key);
        Folder current = (Folder)this.m_folderSel.getSelectedObject(s);
        Folder parent = (Folder)current.getParent();
        if (parent != null) {
            BigDecimal id = parent.getID();
            this.m_tree.expand(id.toString(), s);
        }
    }

    public void treeCollapsed(TreeExpansionEvent e) {
        PageState s = e.getPageState();
        this.m_folderSel.setSelectedKey(s, e.getNodeKey());
    }

    public void treeExpanded(TreeExpansionEvent e) {
    }

    public void stateChanged(ChangeEvent e) {
        PageState s = e.getPageState();
        Folder current = (Folder)this.m_folderSel.getSelectedObject(s);
        Folder parent = (Folder)current.getParent();
        this.m_browser.getPaginator().reset(s);
        if (parent != null) {
            BigDecimal id = parent.getID();
            this.m_tree.expand(id.toString(), s);
        }
    }

    public void process(FormSectionEvent e) {
        PageState s = e.getPageState();
        Object source = e.getSource();
        this.browseMode(s);
    }

    public void submitted(FormSectionEvent e) {
        PageState s = e.getPageState();
        Object source = e.getSource();
    }

    private void browseMode(PageState s) {
        this.m_typeSel.clearSelection(s);
    }

    private void newItemMode(PageState s) {
    }

    private FolderSelectionModel createFolderSelectionModel() {
        return new FolderSelectionModel("folder"){

            @Override
            protected BigDecimal getRootFolderID(PageState ps) {
                Folder root = ItemSearchBrowsePane.this.getRootFolder(ps);
                if (null == root) {
                    return super.getRootFolderID(ps);
                }
                return root.getID();
            }
        };
    }

    private static class SectionNewItemForm
    extends NewItemForm {
        public SectionNewItemForm(String name) {
            super(name);
        }

        @Override
        public ContentSection getContentSection(PageState s) {
            return CMS.getContext().getContentSection();
        }
    }
}

