/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.SegmentedPanel;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ui.CMSContainer;
import com.arsdigita.cms.ui.ContentItemPage;
import com.arsdigita.cms.ui.ItemSearchPage;
import com.arsdigita.cms.ui.authoring.CreationSelector;
import com.arsdigita.cms.ui.authoring.NewItemForm;
import com.arsdigita.cms.ui.folder.FlatFolderPicker;
import com.arsdigita.cms.ui.folder.FolderSelectionModel;
import com.arsdigita.cms.ui.item.ContentItemRequestLocal;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.persistence.OID;
import java.math.BigDecimal;

class ItemSearchCreateItemPane
extends CMSContainer
implements FormInitListener,
FormProcessListener,
FormSubmissionListener {
    public static final String WIDGET_PARAM = "widget";
    public static final String SEARCHWIDGET_PARAM = "searchWidget";
    public static final String PUBLISHWIDGET_PARAM = "publishWidget";
    private static final String CONTENT_TYPE_ID = "ct";
    private static final String FOLDER_ID = "folder_id";
    private static final String FLAT_FOLDER = "flatFolder";
    private final NewItemForm m_newItem;
    private final SingleSelectionModel m_typeSel;
    private final FlatFolderPicker m_folderPicker;
    private final SingleSelectionModel m_model;
    private final FolderSelectionModel m_folderSel;
    private String defaultFolder;
    private boolean editAfterCreate = true;
    private final CreationSelector m_creator;
    private final ContentItemRequestLocal m_contentItem = new ContentItemRequestLocal(){};
    private final Link m_fallBackLink;
    private final SegmentedPanel m_segPanel = new SegmentedPanel("itemSearchCreate");
    private final SegmentedPanel.Segment m_creationSeg = new SegmentedPanel.Segment();
    private final SegmentedPanel.Segment m_newItemSeg = new SegmentedPanel.Segment();
    private final SegmentedPanel.Segment m_linkSeg = new SegmentedPanel.Segment();

    public ItemSearchCreateItemPane(ItemSearchPage parent) {
        this.m_newItem = new SectionNewItemForm("newItem");
        this.m_model = new ParameterSingleSelectionModel((ParameterModel)new BigDecimalParameter(FOLDER_ID));
        this.m_folderSel = new FolderSelectionModel(this.m_model);
        this.setIdAttr("folder-new-item");
        this.m_typeSel = new ParameterSingleSelectionModel((ParameterModel)new BigDecimalParameter(CONTENT_TYPE_ID));
        this.m_creator = new CreationSelector(this.m_typeSel, this.m_folderSel){

            @Override
            public void editItem(PageState state, ContentItem item) {
                ItemSearchCreateItemPane.this.m_creationSeg.setVisible(state, false);
                ItemSearchCreateItemPane.this.m_linkSeg.setVisible(state, true);
                ItemSearchCreateItemPane.this.m_contentItem.set(state, item);
            }
        };
        this.m_creationSeg.add((Component)this.m_creator);
        this.m_creationSeg.add((Component)new Label("<br/>", false));
        BoxPanel folderRow = new BoxPanel(1);
        folderRow.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.item_search.create.folder_select")));
        this.m_folderPicker = new FlatFolderPicker(FLAT_FOLDER);
        folderRow.add((Component)this.m_folderPicker);
        this.m_newItem.add((Component)folderRow);
        this.m_newItemSeg.add((Component)this.m_newItem);
        this.m_newItem.addInitListener(this);
        this.m_newItem.addProcessListener(this);
        this.m_newItem.addSubmissionListener(this);
        this.m_segPanel.add((Component)this.m_newItemSeg);
        this.m_segPanel.add((Component)this.m_creationSeg);
        this.add((Component)this.m_segPanel);
        this.m_fallBackLink = new Link((String)GlobalizationUtil.globalize("cms.ui.search.create.fallback").localize(), new PrintListener(){

            public void prepare(PrintEvent event) {
                String scriptAction;
                Link target = (Link)event.getTarget();
                PageState state = event.getPageState();
                ContentItem item = ItemSearchCreateItemPane.this.m_contentItem.getContentItem(state);
                String title = item instanceof ContentPage ? ((ContentPage)item).getTitle() : item.getName();
                String widget = (String)state.getValue((ParameterModel)new StringParameter(ItemSearchCreateItemPane.WIDGET_PARAM));
                String searchWidget = (String)state.getValue((ParameterModel)new StringParameter(ItemSearchCreateItemPane.SEARCHWIDGET_PARAM));
                String publishWidget = (String)state.getValue((ParameterModel)new StringParameter(ItemSearchCreateItemPane.PUBLISHWIDGET_PARAM));
                if (ItemSearchCreateItemPane.this.editAfterCreate) {
                    ((Label)target.getChild()).setLabel((String)GlobalizationUtil.globalize("cms.ui.search.create.select_edit").localize());
                    ContentSection section = item.getContentSection();
                    String nodeURL = section.getPath() + "/";
                    String linkTarget = ContentItemPage.getItemURL(nodeURL, item.getID(), ContentItemPage.AUTHORING_TAB, true);
                    target.setTarget(linkTarget);
                    scriptAction = "";
                } else {
                    ((Label)target.getChild()).setLabel((String)GlobalizationUtil.globalize("cms.ui.search.create.select_close").localize());
                    scriptAction = "self.close();\nreturn false;";
                }
                target.setOnClick(String.format("window.opener.document.%s.value=\"%s\";window.opener.document.%s.value=\"%s\";window.opener.document.%s.value=\"%s\";%s", widget, item.getID().toString(), searchWidget, title, publishWidget, Boolean.TRUE.toString(), scriptAction));
            }
        });
        BoxPanel linkPanel = new BoxPanel(2);
        Label jsLabel = new Label("", false);
        jsLabel.addPrintListener(new PrintListener(){

            public void prepare(PrintEvent event) {
                String scriptAction;
                Label target = (Label)event.getTarget();
                PageState state = event.getPageState();
                ContentItem item = ItemSearchCreateItemPane.this.m_contentItem.getContentItem(state);
                String title = item instanceof ContentPage ? ((ContentPage)item).getTitle() : item.getName();
                String widget = (String)state.getValue((ParameterModel)new StringParameter(ItemSearchCreateItemPane.WIDGET_PARAM));
                String searchWidget = (String)state.getValue((ParameterModel)new StringParameter(ItemSearchCreateItemPane.SEARCHWIDGET_PARAM));
                String publishWidget = (String)state.getValue((ParameterModel)new StringParameter(ItemSearchCreateItemPane.PUBLISHWIDGET_PARAM));
                if (ItemSearchCreateItemPane.this.editAfterCreate) {
                    ContentSection section = item.getContentSection();
                    String nodeURL = section.getPath() + "/";
                    String linkTarget = ContentItemPage.getItemURL(nodeURL, item.getID(), ContentItemPage.AUTHORING_TAB, true);
                    scriptAction = String.format("window.location.href = \"/ccm/%s\";", linkTarget);
                } else {
                    scriptAction = "self.close();";
                }
                target.setLabel(String.format("<script type=\"text/javascript\"><!--\nwindow.opener.document.%s.value=\"%s\";\nwindow.opener.document.%s.value=\"%s\";\nwindow.opener.document.%s.value=\"%s\";\n%s\n-->\n</script>", widget, item.getID().toString(), searchWidget, title, publishWidget, Boolean.TRUE.toString(), scriptAction));
            }
        });
        linkPanel.add((Component)jsLabel);
        linkPanel.add((Component)this.m_fallBackLink);
        this.m_linkSeg.add((Component)linkPanel);
        this.m_segPanel.add((Component)this.m_linkSeg);
    }

    public void register(Page page) {
        super.register(page);
        page.setVisibleDefault((Component)this.m_newItemSeg, true);
        page.setVisibleDefault((Component)this.m_creationSeg, false);
        page.setVisibleDefault((Component)this.m_linkSeg, false);
        page.addComponentStateParam((Component)this, this.m_typeSel.getStateParameter());
        page.addComponentStateParam((Component)this, this.m_folderSel.getStateParameter());
    }

    public void init(FormSectionEvent fse) throws FormProcessException {
        PageState state = fse.getPageState();
        FormData data = fse.getFormData();
        if ((data.get((Object)FLAT_FOLDER) == null || "".equals(data.get((Object)FLAT_FOLDER))) && this.defaultFolder != null) {
            data.put((Object)FLAT_FOLDER, (Object)this.defaultFolder.toString());
        }
    }

    public void submitted(FormSectionEvent fse) throws FormProcessException {
        PageState state = fse.getPageState();
        BigDecimal typeID = this.m_newItem.getTypeID(state);
        this.m_typeSel.setSelectedKey(state, (Object)typeID);
        String folderOidStr = (String)this.m_folderPicker.getValue(state);
        if (folderOidStr == null || folderOidStr.isEmpty()) {
            fse.getFormData().addError(FLAT_FOLDER, GlobalizationUtil.globalize("cms.ui.item_search.create.folder_missing"));
            throw new FormProcessException((String)GlobalizationUtil.globalize("cms.ui.item_search.create.folder_missing").localize());
        }
        OID folderOID = OID.valueOf((String)folderOidStr);
        this.m_folderSel.setSelectedKey(state, folderOID.get("id"));
        this.m_newItemSeg.setVisible(state, false);
        this.m_creationSeg.setVisible(state, true);
    }

    public void process(FormSectionEvent fse) throws FormProcessException {
    }

    protected String getDefaultFolder() {
        return this.defaultFolder;
    }

    protected void setDefaultFolder(String defaultFolder) {
        this.defaultFolder = defaultFolder;
    }

    protected boolean getEditAfterCreate() {
        return this.editAfterCreate;
    }

    protected void setEditAfterCreate(boolean editAfterCreate) {
        this.editAfterCreate = editAfterCreate;
    }

    private static class SectionNewItemForm
    extends NewItemForm {
        public SectionNewItemForm(String name) {
            super(name);
        }

        @Override
        public ContentSection getContentSection(PageState s) {
            return CMS.getContext().getContentSection();
        }
    }
}

