/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.PaginationModelBuilder;
import com.arsdigita.bebop.Paginator;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterData;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableColumnModel;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.CMSConfig;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.LockableImpl;
import java.math.BigDecimal;

public class ItemSearchFlatBrowsePane
extends Form
implements FormInitListener,
FormProcessListener {
    private static final String QUERY_PARAM = "queryStr";
    public static final String WIDGET_PARAM = "widget";
    public static final String SEARCHWIDGET_PARAM = "searchWidget";
    public static final String FILTER_SUBMIT = "filterSubmit";
    private final Table resultsTable;
    private final Paginator paginator;
    private final StringParameter queryParam;
    private final Submit submit;
    private static final CMSConfig CMS_CONFIG = CMSConfig.getInstance();

    public ItemSearchFlatBrowsePane(String name) {
        super(name);
        this.setIdAttr("itemSearchFlatBrowse");
        BoxPanel mainPanel = new BoxPanel(2);
        this.queryParam = new StringParameter(QUERY_PARAM);
        BoxPanel boxPanel = new BoxPanel(1);
        boxPanel.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.item_search.flat.filter")));
        TextField filter = new TextField((ParameterModel)new StringParameter(QUERY_PARAM));
        boxPanel.add((Component)filter);
        this.submit = new Submit(FILTER_SUBMIT, GlobalizationUtil.globalize("cms.ui.item_search.flat.filter.submit"));
        boxPanel.add((Component)this.submit);
        mainPanel.add((Component)boxPanel);
        this.resultsTable = new ResultsTable();
        this.paginator = new Paginator((PaginationModelBuilder)this.resultsTable.getModelBuilder(), CMS_CONFIG.getItemSearchFlatBrowsePanePageSize().intValue());
        mainPanel.add((Component)this.paginator);
        mainPanel.add((Component)this.resultsTable);
        this.add((Component)mainPanel);
        this.addInitListener(this);
        this.addProcessListener(this);
    }

    public void register(Page page) {
        super.register(page);
        page.addComponentStateParam((Component)this, (ParameterModel)this.queryParam);
    }

    public void init(FormSectionEvent fse) throws FormProcessException {
        PageState state = fse.getPageState();
        FormData data = fse.getFormData();
        String query = (String)data.get((Object)QUERY_PARAM);
        if (query == null || query.isEmpty()) {
            data.setParameter(QUERY_PARAM, new ParameterData((ParameterModel)this.queryParam, state.getValue((ParameterModel)new StringParameter("query"))));
            state.setValue((ParameterModel)this.queryParam, data.getParameter(QUERY_PARAM).getValue());
        }
    }

    public void process(FormSectionEvent fse) throws FormProcessException {
        FormData data = fse.getFormData();
        PageState state = fse.getPageState();
        state.setValue((ParameterModel)this.queryParam, data.get((Object)QUERY_PARAM));
        state.setValue((ParameterModel)new StringParameter("query"), data.get((Object)QUERY_PARAM));
    }

    protected Submit getSubmit() {
        return this.submit;
    }

    private class TitleCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        private TitleCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            if (value == null) {
                return new Label("???");
            }
            Link link = new Link(value.toString(), "");
            String widget = (String)state.getValue((ParameterModel)new StringParameter(ItemSearchFlatBrowsePane.WIDGET_PARAM));
            String searchWidget = (String)state.getValue((ParameterModel)new StringParameter(ItemSearchFlatBrowsePane.SEARCHWIDGET_PARAM));
            ContentPage page = new ContentPage((BigDecimal)key);
            link.setOnClick(String.format("window.opener.document.%s.value=\"%s\";window.opener.document.%s.value=\"%s\";self.close();return false;", widget, key.toString(), searchWidget, page.getTitle()));
            return link;
        }
    }

    private class ResultsTableModel
    implements TableModel {
        private final Table table;
        private final DataCollection collection;
        private ContentItem currentItem;

        public ResultsTableModel(Table table, PageState state, DataCollection collection) {
            this.table = table;
            this.collection = collection;
        }

        public int getColumnCount() {
            return this.table.getColumnModel().size();
        }

        public boolean nextRow() {
            boolean ret;
            if (this.collection != null && this.collection.next()) {
                this.currentItem = (ContentItem)DomainObjectFactory.newInstance((DataObject)this.collection.getDataObject());
                ret = true;
            } else {
                ret = false;
            }
            return ret;
        }

        public Object getElementAt(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (this.currentItem instanceof ContentPage) {
                        return ((ContentPage)this.currentItem).getTitle();
                    }
                    return this.currentItem.getName();
                }
                case 1: {
                    return this.getItemPath(this.currentItem);
                }
                case 2: {
                    return this.currentItem.getContentType().getLabel();
                }
            }
            return null;
        }

        private String getItemPath(ContentItem item) {
            StringBuilder path = new StringBuilder(item.getName());
            ContentItem current = item;
            while (current.getParent() != null) {
                if (current.getParent() instanceof ContentBundle) {
                    current = (ContentBundle)current.getParent();
                    continue;
                }
                if (!(current.getParent() instanceof Folder) || (current = (Folder)current.getParent()).getName().equals("/")) continue;
                path.insert(0, '/');
                path.insert(0, current.getName());
            }
            path.insert(0, ":/");
            path.insert(0, item.getContentSection().getName());
            return path.toString();
        }

        public Object getKeyAt(int columnIndex) {
            return this.currentItem.getID();
        }
    }

    private class ResultsTableModelBuilder
    extends LockableImpl
    implements TableModelBuilder,
    PaginationModelBuilder {
        private RequestLocal collection = new RequestLocal();

        private ResultsTableModelBuilder() {
        }

        public TableModel makeModel(Table table, PageState state) {
            if (this.collection.get(state) == null) {
                this.query(state);
            }
            ((DataCollection)this.collection.get(state)).setRange(Integer.valueOf(ItemSearchFlatBrowsePane.this.paginator.getFirst(state)), Integer.valueOf(ItemSearchFlatBrowsePane.this.paginator.getLast(state) + 1));
            return new ResultsTableModel(table, state, (DataCollection)this.collection.get(state));
        }

        public int getTotalSize(Paginator paginator, PageState state) {
            if (this.collection.get(state) == null) {
                this.query(state);
            }
            return (int)((DataCollection)this.collection.get(state)).size();
        }

        public boolean isVisible(PageState state) {
            return true;
        }

        private void query(PageState state) {
            Session session = SessionManager.getSession();
            BigDecimal typeId = (BigDecimal)state.getValue((ParameterModel)new BigDecimalParameter("single_type"));
            if (typeId == null) {
                this.collection.set(state, (Object)session.retrieve("com.arsdigita.cms.ContentPage"));
            } else {
                ContentType type = new ContentType(typeId);
                this.collection.set(state, (Object)session.retrieve(type.getClassName()));
            }
            ((DataCollection)this.collection.get(state)).addFilter("version = 'draft'");
            ((DataCollection)this.collection.get(state)).addFilter("section is not null");
            String query = (String)state.getValue((ParameterModel)ItemSearchFlatBrowsePane.this.queryParam);
            if (query != null && !query.isEmpty()) {
                ((DataCollection)this.collection.get(state)).addFilter(String.format("((lower(%s) like lower('%%%s%%')) or (lower(%s) like lower('%%%s%%')))", "name", query, "title", query));
            }
            ((DataCollection)this.collection.get(state)).addOrder("title asc, name asc");
        }
    }

    private class ResultsTable
    extends Table {
        private static final String TABLE_COL_TITLE = "title";
        private static final String TABLE_COL_PLACE = "place";
        private static final String TABLE_COL_TYPE = "type";

        public ResultsTable() {
            this.setEmptyView((Component)new Label(GlobalizationUtil.globalize("cms.ui.item_search.flat.no_items")));
            this.setClassAttr("dataTable");
            TableColumnModel columnModel = this.getColumnModel();
            columnModel.add(new TableColumn(0, GlobalizationUtil.globalize("cms.ui.item_search.flat.title").localize(), (Object)TABLE_COL_TITLE));
            columnModel.add(new TableColumn(1, GlobalizationUtil.globalize("cms.ui.item_search.flat.place").localize(), (Object)TABLE_COL_PLACE));
            columnModel.add(new TableColumn(2, GlobalizationUtil.globalize("cms.ui.item_search.flat.type").localize(), (Object)TABLE_COL_TYPE));
            this.setModelBuilder(new ResultsTableModelBuilder());
            columnModel.get(0).setCellRenderer((TableCellRenderer)new TitleCellRenderer());
        }
    }
}

