/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.TabbedPane;
import com.arsdigita.bebop.event.RequestEvent;
import com.arsdigita.bebop.event.RequestListener;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.BooleanParameter;
import com.arsdigita.bebop.parameters.IntegerParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.CMSConfig;
import com.arsdigita.cms.CMSExcursion;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.dispatcher.CMSPage;
import com.arsdigita.cms.ui.ItemSearchBrowsePane;
import com.arsdigita.cms.ui.ItemSearchCreateItemPane;
import com.arsdigita.cms.ui.ItemSearchFlatBrowsePane;
import com.arsdigita.cms.ui.ItemSearchPopup;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.templating.PresentationManager;
import com.arsdigita.templating.Templating;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.Application;
import com.arsdigita.web.Web;
import com.arsdigita.xml.Document;
import java.io.IOException;
import java.math.BigDecimal;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ItemSearchPage
extends CMSPage {
    private static final String XSL_CLASS = "CMS Admin";
    private TabbedPane m_tabbedPane;
    private ItemSearchFlatBrowsePane m_flatBrowse;
    private ItemSearchBrowsePane m_browse;
    private ItemSearchPopup m_search;
    private ItemSearchCreateItemPane m_create;
    private BigDecimalParameter m_sectionId;
    private int m_lastTab;
    private static final CMSConfig s_conf = CMSConfig.getInstance();
    private static final boolean LIMIT_TO_CONTENT_SECTION = false;
    public static final String CONTENT_SECTION = "section_id";

    public ItemSearchPage() {
        super(GlobalizationUtil.globalize("cms.ui.item_search.page_title").localize().toString(), (Container)new SimpleContainer());
        this.setClassAttr("cms-admin");
        this.addGlobalStateParam((ParameterModel)new BigDecimalParameter("single_type"));
        this.addGlobalStateParam((ParameterModel)new StringParameter("widget"));
        this.addGlobalStateParam((ParameterModel)new StringParameter("searchWidget"));
        this.addGlobalStateParam((ParameterModel)new StringParameter("publishWidget"));
        this.addGlobalStateParam((ParameterModel)new StringParameter("defaultCreationFolder"));
        this.addGlobalStateParam((ParameterModel)new IntegerParameter("lastTab"));
        this.addGlobalStateParam((ParameterModel)new BooleanParameter("disableCreatePane"));
        this.addGlobalStateParam((ParameterModel)new BooleanParameter("editAfterCreate"));
        this.m_sectionId = new BigDecimalParameter(CONTENT_SECTION);
        this.addGlobalStateParam((ParameterModel)this.m_sectionId);
        this.m_flatBrowse = this.getFlatBrowsePane();
        this.m_browse = this.getBrowsePane();
        this.m_search = this.getSearchPane();
        this.m_create = this.getCreatePane();
        this.m_tabbedPane = this.createTabbedPane();
        this.m_tabbedPane.setIdAttr("page-body");
        this.add((Component)this.m_tabbedPane);
        this.addRequestListener(new RequestListener(){

            public void pageRequested(RequestEvent event) {
                PageState state = event.getPageState();
                String query = (String)state.getValue((ParameterModel)new StringParameter("query"));
                Boolean disableCreatePane = (Boolean)state.getValue((ParameterModel)new BooleanParameter("disableCreatePane"));
                BigDecimal typeParam = (BigDecimal)state.getValue((ParameterModel)new BigDecimalParameter("single_type"));
                if (typeParam == null || disableCreatePane.booleanValue()) {
                    ItemSearchPage.this.m_tabbedPane.setTabVisible(state, (Component)ItemSearchPage.this.m_create, false);
                    ItemSearchPage.this.m_create.setVisible(state, false);
                } else {
                    ItemSearchPage.this.m_tabbedPane.setTabVisible(state, (Component)ItemSearchPage.this.m_create, true);
                    ItemSearchPage.this.m_create.setVisible(state, true);
                }
                if (state.getValue((ParameterModel)new IntegerParameter("lastTab")) == null) {
                    if (query == null || query.isEmpty()) {
                        ItemSearchPage.this.m_tabbedPane.setSelectedIndex(state, 1);
                    } else {
                        ItemSearchPage.this.m_tabbedPane.setSelectedIndex(state, 0);
                    }
                }
                state.setValue((ParameterModel)new IntegerParameter("lastTab"), (Object)ItemSearchPage.this.m_tabbedPane.getSelectedIndex(state));
                if (state.getValue((ParameterModel)new StringParameter("defaultCreationFolder")) != null) {
                    ItemSearchPage.this.m_create.setDefaultFolder((String)state.getValue((ParameterModel)new StringParameter("defaultCreationFolder")));
                }
                if (state.getValue((ParameterModel)new BooleanParameter("editAfterCreate")) != null) {
                    ItemSearchPage.this.m_create.setEditAfterCreate((Boolean)state.getValue((ParameterModel)new BooleanParameter("editAfterCreate")));
                }
            }
        });
    }

    protected ItemSearchBrowsePane getBrowsePane() {
        if (this.m_browse == null) {
            this.m_browse = new ItemSearchBrowsePane();
        }
        return this.m_browse;
    }

    protected ItemSearchFlatBrowsePane getFlatBrowsePane() {
        if (this.m_flatBrowse == null) {
            this.m_flatBrowse = new ItemSearchFlatBrowsePane("flatBrowse");
        }
        return this.m_flatBrowse;
    }

    protected ItemSearchPopup getSearchPane() {
        if (this.m_search == null) {
            this.m_search = new ItemSearchPopup("draft", false);
        }
        return this.m_search;
    }

    protected ItemSearchCreateItemPane getCreatePane() {
        if (this.m_create == null) {
            this.m_create = new ItemSearchCreateItemPane(this);
        }
        return this.m_create;
    }

    protected TabbedPane createTabbedPane() {
        TabbedPane pane = new TabbedPane();
        pane.setClassAttr(XSL_CLASS);
        this.addToPane(pane, "flatBrowse", (Component)this.getFlatBrowsePane());
        this.addToPane(pane, "browse", (Component)this.getBrowsePane());
        this.addToPane(pane, "search", (Component)this.getSearchPane());
        this.addToPane(pane, "create", (Component)this.getCreatePane());
        if ("browse".equals(s_conf.getItemSearchDefaultTab())) {
            pane.setDefaultPane((Component)this.m_browse);
        }
        if ("search".equals(s_conf.getItemSearchDefaultTab())) {
            pane.setDefaultPane((Component)this.m_search);
        }
        pane.setDefaultPane((Component)this.m_browse);
        return pane;
    }

    protected void addToPane(TabbedPane pane, String tabName, Component comp) {
        if (comp != null) {
            pane.addTab(GlobalizationUtil.globalize("cms.ui.item_search." + tabName).localize().toString(), comp);
        }
    }

    @Override
    public void dispatch(final HttpServletRequest request, final HttpServletResponse response, RequestContext actx) throws IOException, ServletException {
        new CMSExcursion(){

            @Override
            public void excurse() throws IOException, ServletException {
                ContentSection section = null;
                Application app = Web.getContext().getApplication();
                if (app instanceof ContentSection) {
                    section = (ContentSection)app;
                } else {
                    try {
                        section = new ContentSection((BigDecimal)ItemSearchPage.this.m_sectionId.transformValue(request));
                    }
                    catch (DataObjectNotFoundException ex) {
                        throw new UncheckedWrapperException((Throwable)ex);
                    }
                }
                this.setContentSection(section);
                Document doc = ItemSearchPage.this.buildDocument(request, response);
                PresentationManager pm = Templating.getPresentationManager();
                pm.servePage(doc, request, response);
            }
        }.run();
    }

    protected void setTabActive(PageState state, Component component, boolean value) {
        this.m_tabbedPane.setTabVisible(state, component, value);
    }

    protected void setTabActive(PageState state, int index, boolean value) {
        this.m_tabbedPane.setTabVisible(state, index, value);
    }

    protected void setDefaultCreationFolder(Folder folder) {
        this.m_create.setDefaultFolder(folder.getOID().toString());
    }

    protected void setEditAfterCreate(boolean editAfterCreate) {
        this.m_create.setEditAfterCreate(editAfterCreate);
    }
}

