/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentType;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.globalization.Globalization;
import com.arsdigita.persistence.OID;
import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;

public class ItemSearchParameter
extends StringParameter {
    private ContentType m_contentType;

    public ItemSearchParameter(String name) {
        this(name, null);
    }

    public ItemSearchParameter(String name, ContentType contentType) {
        super(name);
        this.m_contentType = contentType;
    }

    public Object transformValue(HttpServletRequest request) throws IllegalArgumentException {
        String itemStr = Globalization.decodeParameter((HttpServletRequest)request, (String)this.getName());
        return this.unmarshal(itemStr);
    }

    public Object unmarshal(String encoded) throws IllegalArgumentException {
        ContentItem contentItem;
        if (encoded == null || encoded.length() < 1) {
            return null;
        }
        String idStr = encoded.indexOf(32) < 0 ? encoded : encoded.substring(0, encoded.indexOf(32));
        if (idStr == null || idStr.length() < 1) {
            return null;
        }
        BigDecimal itemID = new BigDecimal(idStr);
        if (itemID == null) {
            return null;
        }
        try {
            contentItem = (ContentItem)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.cms.ContentItem", (Object)itemID));
        }
        catch (DataObjectNotFoundException e) {
            throw new IllegalArgumentException(encoded + " is not a valid contentItem." + e.getMessage());
        }
        if (this.m_contentType != null && !contentItem.isContentType(this.m_contentType)) {
            return null;
        }
        return contentItem;
    }

    public String marshal(Object value) {
        if (value == null) {
            return null;
        }
        ContentPage theItem = (ContentPage)value;
        return theItem.getID().toString() + " (" + theItem.getTitle() + ")";
    }

    public Class getValueClass() {
        return ContentPage.class;
    }
}

