/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ui.ItemSearch;
import com.arsdigita.cms.ui.ItemSearchSection;
import com.arsdigita.persistence.OID;
import com.arsdigita.search.Document;
import com.arsdigita.search.Search;
import com.arsdigita.search.ui.QueryGenerator;
import com.arsdigita.search.ui.ResultsPane;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class ItemSearchPopup
extends ItemSearch {
    private static final Logger s_log = Logger.getLogger(ItemSearchPopup.class);
    public static final String WIDGET_PARAM = "widget";
    public static final String URL_PARAM = "useURL";
    public static final String QUERY = "query";

    public ItemSearchPopup(String context, boolean limitToContentSection) {
        super(context, limitToContentSection);
    }

    public void register(Page p) {
        super.register(p);
        p.addGlobalStateParam((ParameterModel)new StringParameter(WIDGET_PARAM));
        p.addGlobalStateParam((ParameterModel)new StringParameter(URL_PARAM));
        p.addGlobalStateParam((ParameterModel)new StringParameter(QUERY));
    }

    @Override
    protected ItemSearchSection createSearchSection(String context, boolean limitToContentSection) {
        return new ItemSearchSectionPopup(context, limitToContentSection);
    }

    public static String getItemURL(HttpServletRequest request, OID oid) {
        return "/redirect/?oid=" + oid.toString();
    }

    private static class PopupResultsPane
    extends ResultsPane {
        public PopupResultsPane(QueryGenerator generator) {
            super(generator);
            this.setRelativeURLs(true);
        }

        protected Element generateDocumentXML(PageState state, Document doc) {
            Element element = super.generateDocumentXML(state, doc);
            element.addAttribute("class", "jsButton");
            String widget = (String)state.getValue((ParameterModel)new StringParameter(ItemSearchPopup.WIDGET_PARAM));
            String searchWidget = (String)state.getValue((ParameterModel)new StringParameter("searchWidget"));
            boolean useURL = "true".equals(state.getValue((ParameterModel)new StringParameter(ItemSearchPopup.URL_PARAM)));
            String fillString = useURL ? ItemSearchPopup.getItemURL(state.getRequest(), doc.getOID()) : doc.getOID().get("id").toString() + " (" + doc.getTitle() + ")";
            String title = doc.getTitle();
            Element jsLabel = Search.newElement((String)"jsAction");
            jsLabel.addAttribute("name", "fillItem" + doc.getOID().get("id") + "()");
            jsLabel.setText(this.generateJSLabel((BigDecimal)doc.getOID().get("id"), widget, searchWidget, fillString, title));
            element.addContent(jsLabel);
            return element;
        }

        private String generateJSLabel(BigDecimal id, String widget, String searchWidget, String fill, String title) {
            return " <script language=javascript>  <!-- \n function fillItem" + id + "() { \n" + " window.opener.document." + widget + ".value=\"" + fill + "\";\n" + " window.opener.document." + searchWidget + ".value=\"" + title + "\";\n" + " self.close(); \n" + " return false; \n" + " } \n" + " --> \n" + " </script> ";
        }
    }

    private static class ItemSearchSectionPopup
    extends ItemSearchSection {
        public ItemSearchSectionPopup(String context, boolean limitToContentSection) {
            super(context, limitToContentSection);
        }

        @Override
        protected Component createResultsPane(QueryGenerator generator) {
            return new PopupResultsPane(generator);
        }
    }
}

