/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Resettable;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ui.search.ItemQueryComponent;
import com.arsdigita.search.QuerySpecification;
import com.arsdigita.search.ui.QueryGenerator;
import com.arsdigita.search.ui.ResultsPane;
import org.apache.log4j.Logger;

public class ItemSearchSection
extends FormSection
implements Resettable,
QueryGenerator {
    private static final Logger s_log = Logger.getLogger(ItemSearchSection.class);
    public static final String SINGLE_TYPE_PARAM = "single_type";
    private ItemQueryComponent m_query;
    private Component m_results;

    public ItemSearchSection(String context, boolean limitToContentSection) {
        this(null, context, limitToContentSection);
    }

    public ItemSearchSection(String name, String context, boolean limitToContentSection) {
        this(name, context, limitToContentSection, null);
    }

    public ItemSearchSection(String name, String context, boolean limitToContentSection, ContentType type) {
        super((Container)new SimpleContainer());
        String thisName = name == null ? "itemSearch" : name;
        this.m_query = type == null ? this.createQueryGenerator(context, limitToContentSection) : this.createQueryGenerator(context, limitToContentSection, type);
        this.m_results = this.createResultsPane((QueryGenerator)this.m_query);
        this.addQueryGenerator((Container)this);
        this.addResultsPane((Container)this);
        this.addFormListener();
        this.setClassAttr("itemSearch");
    }

    public boolean hasQuery(PageState state) {
        return this.m_query.hasQuery(state);
    }

    public QuerySpecification getQuerySpecification(PageState state) {
        return this.m_query.getQuerySpecification(state);
    }

    public void reset(PageState state) {
        this.m_results.setVisible(state, false);
    }

    protected ItemQueryComponent createQueryGenerator(String context, boolean limitToContentSection) {
        return new ItemQueryComponent(context, limitToContentSection);
    }

    protected ItemQueryComponent createQueryGenerator(String context, boolean limitToContentSection, ContentType type) {
        return new ItemQueryComponent(context, limitToContentSection, type);
    }

    protected Component createResultsPane(QueryGenerator generator) {
        ResultsPane pane = new ResultsPane(generator);
        pane.setRelativeURLs(true);
        return pane;
    }

    protected void addResultsPane(Container container) {
        container.add(this.m_results);
    }

    protected void addQueryGenerator(Container container) {
        container.add((Component)this.m_query);
    }

    protected void processQuery(PageState state) {
        this.m_results.setVisible(state, this.m_query.hasQuery(state));
    }

    protected void addFormListener() {
        this.addProcessListener(new SearchFormProcessListener());
    }

    public void register(Page p) {
        super.register(p);
        p.setVisibleDefault(this.m_results, false);
        p.addGlobalStateParam((ParameterModel)new BigDecimalParameter(SINGLE_TYPE_PARAM));
    }

    private class SearchFormProcessListener
    implements FormProcessListener {
        private SearchFormProcessListener() {
        }

        public void process(FormSectionEvent e) throws FormProcessException {
            PageState s = e.getPageState();
            ItemSearchSection.this.processQuery(s);
        }
    }
}

