/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ui.ItemSearchSection;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.persistence.OID;
import com.arsdigita.search.Document;
import com.arsdigita.search.ui.QueryGenerator;
import com.arsdigita.search.ui.ResultsPane;
import com.arsdigita.toolbox.ui.OIDParameter;
import com.arsdigita.xml.Element;
import org.apache.log4j.Logger;

public class ItemSearchSectionInline
extends ItemSearchSection {
    private static final Logger s_log = Logger.getLogger(ItemSearchSectionInline.class);
    private Submit m_selectItem;
    private String m_name;
    private OIDParameter m_item;

    public ItemSearchSectionInline(String name, String context, boolean limitToContentSection) {
        super(name, context, limitToContentSection);
        this.m_name = name;
        this.m_item = new OIDParameter(name + "_itemOID");
    }

    public ItemSearchSectionInline(String name, String context, boolean limitToContentSection, ContentType type) {
        super(name, context, limitToContentSection, type);
        this.m_name = name;
        this.m_item = new OIDParameter(name + "_itemOID");
    }

    @Override
    public void register(Page p) {
        super.register(p);
        p.addGlobalStateParam((ParameterModel)this.m_item);
    }

    @Override
    protected Component createResultsPane(QueryGenerator generator) {
        return new InlineResultsPane(generator);
    }

    @Override
    protected void addResultsPane(Container container) {
        super.addResultsPane(container);
        this.m_selectItem = new ItemSelectSubmit(this.m_name + "_itemSelect", "Select Item");
        container.add((Component)this.m_selectItem);
    }

    @Override
    protected void addFormListener() {
    }

    @Override
    public void processQuery(PageState state) {
        super.processQuery(state);
        this.m_selectItem.setVisible(state, this.hasQuery(state));
    }

    public boolean isItemSelected(PageState state) {
        return this.m_selectItem.isSelected(state);
    }

    public ContentItem getSelectedItem(PageState state) {
        OID oid = (OID)state.getValue((ParameterModel)this.m_item);
        if (oid == null) {
            return null;
        }
        return (ContentItem)DomainObjectFactory.newInstance((OID)oid);
    }

    private class InlineResultsPane
    extends ResultsPane {
        public InlineResultsPane(QueryGenerator query) {
            super(query);
            this.setRelativeURLs(true);
        }

        protected Element generateDocumentXML(PageState state, Document doc) {
            Element element = super.generateDocumentXML(state, doc);
            element.addAttribute("field", ItemSearchSectionInline.this.m_item.getName());
            element.addAttribute("class", "radioButton");
            return element;
        }
    }

    private class ItemSelectSubmit
    extends Submit {
        public ItemSelectSubmit(String name, String label) {
            super(name, label);
        }

        public ItemSelectSubmit(String name, GlobalizedMessage label) {
            super(name, label);
        }

        public boolean isVisible(PageState ps) {
            return ItemSearchSectionInline.this.hasQuery(ps) && super.isVisible(ps);
        }
    }
}

