/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Hidden;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.util.BebopConstants;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ContentTypeLifecycleDefinition;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.Workspace;
import com.arsdigita.cms.WorkspaceServlet;
import com.arsdigita.cms.lifecycle.LifecycleDefinition;
import com.arsdigita.cms.ui.ItemSearchPage;
import com.arsdigita.cms.ui.ItemSearchParameter;
import com.arsdigita.cms.ui.ItemSearchSectionInline;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.web.ParameterMap;
import com.arsdigita.web.URL;
import com.arsdigita.workflow.simple.Workflow;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class ItemSearchWidget
extends FormSection
implements BebopConstants,
FormSubmissionListener,
FormInitListener {
    private static final Logger s_log = Logger.getLogger(ItemSearchWidget.class);
    private TextField m_selected;
    private TextField m_item;
    private Hidden m_publish;
    private Submit m_search;
    private Submit m_clear;
    private Label m_jsLabel;
    private Label m_topHR;
    private Label m_bottomHR;
    private ContentType m_contentType;
    private ItemSearchSectionInline m_searchComponent;
    private String m_name;
    private String m_searchName;
    private String m_clearName;
    private Folder m_defaultCreationFolder;
    private ParameterModel m_model;
    private ParameterModel m_searchModel;
    private boolean disableCreatePane = false;
    private boolean editAfterCreate = true;
    private String searchLabelText = (String)GlobalizationUtil.globalize("cms.ui.item_search.search").localize();
    private String selectedLabelText = (String)GlobalizationUtil.globalize("cms.ui.item_search.selected").localize();
    public static final String BEBOP_ITEM_SEARCH = "bebop:itemSearch";
    public static final String SEARCH = "search";
    public static final boolean LIMIT_TO_CONTENT_SECTION = false;
    public static final String PUBLISH = "publish";

    public ItemSearchWidget(ParameterModel model) {
        this(model, null);
    }

    public ItemSearchWidget(ParameterModel model, ContentType contentType) {
        super((Container)new BoxPanel(2));
        if (!(model instanceof ItemSearchParameter)) {
            throw new IllegalArgumentException("The ItemSearch widget " + model.getName() + " must be backed by a ItemSearchParameter parameter model");
        }
        this.m_name = model.getName();
        this.m_searchName = this.m_name + "_search";
        this.m_clearName = this.m_name + "_clear";
        this.m_model = model;
        final String typeURLFrag = contentType != null ? contentType.getID().toString() : null;
        this.m_searchModel = new StringParameter(SEARCH);
        this.m_contentType = contentType;
        this.m_selected = new ItemFragment(model, this);
        Label selectedItemLabel = new Label(this.selectedLabelText);
        selectedItemLabel.addPrintListener(new PrintListener(){

            public void prepare(PrintEvent event) {
                Label target = (Label)event.getTarget();
                target.setLabel(ItemSearchWidget.this.selectedLabelText);
            }
        });
        Label searchLabel = new Label(this.searchLabelText);
        searchLabel.addPrintListener(new PrintListener(){

            public void prepare(PrintEvent event) {
                Label target = (Label)event.getTarget();
                target.setLabel(ItemSearchWidget.this.searchLabelText);
            }
        });
        this.m_publish = new Hidden(PUBLISH);
        this.add((Component)this.m_publish);
        this.m_item = new TextField(this.m_searchModel);
        this.m_search = new SearchFragment(this.m_searchName, this);
        this.m_clear = new ClearFragment(this.m_clearName, this);
        this.m_jsLabel = new LabelFragment("", false, this);
        this.m_jsLabel.addPrintListener(new PrintListener(){

            public void prepare(PrintEvent event) {
                PageState state = event.getPageState();
                Label t = (Label)event.getTarget();
                String formName = ((LabelFragment)t).parent.getSearchButton().getForm().getName();
                ParameterMap params = new ParameterMap();
                params.setParameter("section_id", (Object)CMS.getContext().getContentSection().getID());
                params.setParameter("widget", formName + ".elements['" + ItemSearchWidget.this.m_selected.getName() + "']");
                params.setParameter("searchWidget", formName + ".elements['" + ItemSearchWidget.this.m_item.getName() + "']");
                if (typeURLFrag != null) {
                    params.setParameter("single_type", typeURLFrag);
                }
                params.setParameter("publishWidget", formName + ".elements['" + ItemSearchWidget.this.m_publish.getName() + "']");
                params.setParameter("disableCreatePane", Boolean.toString(ItemSearchWidget.this.disableCreatePane));
                params.setParameter("editAfterCreate", Boolean.toString(ItemSearchWidget.this.editAfterCreate));
                if (ItemSearchWidget.this.m_defaultCreationFolder != null) {
                    params.setParameter("defaultCreationFolder", ItemSearchWidget.this.m_defaultCreationFolder.getOID().toString());
                }
                String searchURL = WorkspaceServlet.getURLStubForClass(ItemSearchPage.class.getName());
                s_log.debug((Object)("Search URL stub is: " + searchURL));
                searchURL = Workspace.getURL() + searchURL;
                URL url = URL.there((HttpServletRequest)state.getRequest(), (String)searchURL, (ParameterMap)params);
                t.setLabel(" <script language=javascript>  <!-- \n function " + ItemSearchWidget.this.m_selected.getName().replace('.', '_') + "Popup(theForm) { \n" + "var width = screen.width * 0.5;\n" + "var height = screen.height * 0.5;\n" + "if ((width < 800) && (screen.width >= 800)) {\n" + "width = 800;\n" + "}\n" + "if ((height < 600) && (screen.height >= 600)) {\n" + "height = 600;\n" + "}\n" + " aWindow = window.open(\"" + url + "&query=\" + document.getElementById('" + ItemSearchWidget.this.m_item.getName() + "').value , " + "\"search\", \"toolbar=no,width=\" + width + \",height=\" + height + \",status=no,scrollbars=yes,resize=yes\");\n" + "document." + formName + "." + ItemSearchWidget.this.m_publish.getName() + ".value = \"false\";\n " + "return false;\n" + " } \n" + " --> \n" + " </script> ");
            }
        });
        this.m_topHR = new HRLabel();
        this.add((Component)this.m_topHR);
        FormSection searchSection = new FormSection((Container)new BoxPanel(2));
        BoxPanel searchRow = new BoxPanel(1);
        searchRow.add((Component)searchLabel);
        searchRow.add((Component)this.m_item);
        searchRow.add((Component)this.m_search);
        searchRow.add((Component)this.m_clear);
        BoxPanel itemRow = new BoxPanel(1);
        itemRow.add((Component)selectedItemLabel);
        itemRow.add((Component)this.m_selected);
        searchSection.add((Component)searchRow);
        searchSection.add((Component)itemRow);
        searchSection.add((Component)this.m_jsLabel);
        this.add((Component)searchSection);
        this.m_searchComponent = this.m_contentType == null ? new ItemSearchFragment(this.m_name, "draft", this, false) : new ItemSearchFragment(this.m_name, "draft", this, false, this.m_contentType);
        this.add((Component)this.m_searchComponent);
        this.addSubmissionListener(this);
        this.addInitListener(this);
        this.m_bottomHR = new HRLabel();
        this.add((Component)this.m_bottomHR);
    }

    public void register(Page p) {
        super.register(p);
        p.setVisibleDefault((Component)this.m_topHR, false);
        p.setVisibleDefault((Component)this.m_searchComponent, false);
        p.setVisibleDefault((Component)this.m_bottomHR, false);
    }

    public ItemSearchWidget(String name) {
        this((ParameterModel)new ItemSearchParameter(name));
    }

    public ItemSearchWidget(String name, String objectType) throws DataObjectNotFoundException {
        this(name, objectType == null || objectType.length() == 0 ? null : ContentType.findByAssociatedObjectType(objectType));
    }

    public ItemSearchWidget(String name, ContentType contentType) {
        this((ParameterModel)new ItemSearchParameter(name, contentType), contentType);
    }

    public Submit getSearchButton() {
        return this.m_search;
    }

    public Submit getClearButton() {
        return this.m_clear;
    }

    public TextField getItemField() {
        return this.m_item;
    }

    public void init(FormSectionEvent e) throws FormProcessException {
        PageState s = e.getPageState();
        try {
            this.m_searchComponent.setVisible(s, false);
            this.m_topHR.setVisible(s, false);
            this.m_bottomHR.setVisible(s, false);
            this.m_search.setVisible(s, true);
            e.getFormData().put((Object)PUBLISH, (Object)Boolean.FALSE.toString());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void submitted(FormSectionEvent event) throws FormProcessException {
        PageState state = event.getPageState();
        FormData data = event.getFormData();
        s_log.debug((Object)"Doing submission");
        if (this.m_searchComponent.isItemSelected(state)) {
            s_log.debug((Object)"Item selected");
            ContentItem item = this.m_searchComponent.getSelectedItem(state);
            if (item != null) {
                this.m_item.setValue(state, (Object)item);
            }
            try {
                this.m_searchComponent.setVisible(state, false);
                this.m_topHR.setVisible(state, false);
                this.m_bottomHR.setVisible(state, false);
                this.m_search.setVisible(state, true);
            }
            catch (IllegalStateException ex) {
                // empty catch block
            }
            throw new FormProcessException("item search FormSection submit");
        }
        if (this.m_searchComponent.hasQuery(state)) {
            s_log.debug((Object)"Has query");
            try {
                this.m_searchComponent.setVisible(state, true);
                this.m_searchComponent.processQuery(state);
                this.m_topHR.setVisible(state, true);
                this.m_bottomHR.setVisible(state, true);
                this.m_search.setVisible(state, false);
            }
            catch (IllegalStateException ex) {
                // empty catch block
            }
            if (this.m_contentType != null) {
                state.setValue((ParameterModel)new BigDecimalParameter("single_type"), (Object)this.m_contentType.getID());
            } else {
                state.setValue((ParameterModel)new BigDecimalParameter("single_type"), null);
            }
            throw new FormProcessException("item search FormSection submit");
        }
        if (this.m_search.isSelected(state)) {
            s_log.debug((Object)"Search selected");
            try {
                this.m_searchComponent.setVisible(state, true);
                this.m_searchComponent.processQuery(state);
                this.m_topHR.setVisible(state, true);
                this.m_bottomHR.setVisible(state, true);
                this.m_search.setVisible(state, false);
            }
            catch (IllegalStateException ex) {
                // empty catch block
            }
            if (this.m_contentType != null) {
                state.setValue((ParameterModel)new BigDecimalParameter("single_type"), (Object)this.m_contentType.getID());
            } else {
                state.setValue((ParameterModel)new BigDecimalParameter("single_type"), null);
            }
            throw new FormProcessException("item search FormSection submit");
        }
        if (this.m_clear.isSelected(state)) {
            s_log.debug((Object)"Clear selected");
            this.m_item.setValue(state, null);
            try {
                this.m_searchComponent.setVisible(state, false);
                this.m_topHR.setVisible(state, false);
                this.m_bottomHR.setVisible(state, false);
                this.m_search.setVisible(state, true);
            }
            catch (IllegalStateException ex) {
                // empty catch block
            }
            throw new FormProcessException("item search FormSection submit");
        }
        s_log.debug((Object)"Something else");
        try {
            this.m_searchComponent.setVisible(state, false);
            this.m_topHR.setVisible(state, false);
            this.m_bottomHR.setVisible(state, false);
            this.m_search.setVisible(state, true);
        }
        catch (IllegalStateException ex) {
            // empty catch block
        }
    }

    public String getSearchLabelText() {
        return this.searchLabelText;
    }

    public void setSearchLabelText(String searchLabelText) {
        this.searchLabelText = searchLabelText;
    }

    public String getSelectedLabelText() {
        return this.selectedLabelText;
    }

    public void setSelectedLabelText(String selectedLabelText) {
        this.selectedLabelText = selectedLabelText;
    }

    public void setDefaultCreationFolder(Folder folder) {
        this.m_defaultCreationFolder = folder;
    }

    public void publishCreatedItem(FormData data, ContentItem item) {
        String publishStr = data.getString((Object)PUBLISH);
        Boolean publish = Boolean.valueOf(publishStr);
        if (publish.booleanValue()) {
            LifecycleDefinition lifecycleDef = ContentTypeLifecycleDefinition.getLifecycleDefinition(item.getContentSection(), item.getContentType());
            if (lifecycleDef == null) {
                s_log.warn((Object)String.format("Cannot publish item %s because it has no default lifecycle", item.getOID().toString()));
            } else {
                item.publish(lifecycleDef, new Date());
                item.getLifecycle().start();
                Workflow workflow = Workflow.getObjectWorkflow((ACSObject)item);
                if (workflow != null) {
                    workflow.delete();
                }
            }
        }
    }

    public boolean getDisableCreatePane() {
        return this.disableCreatePane;
    }

    public void setDisableCreatePane(boolean disableCreatePane) {
        this.disableCreatePane = disableCreatePane;
    }

    public void setEditAfterCreate(boolean editAfterCreate) {
        this.editAfterCreate = editAfterCreate;
    }

    private class HRLabel
    extends Label {
        public HRLabel() {
            super("<hr/>", false);
        }

        public boolean isVisible(PageState ps) {
            return (ItemSearchWidget.this.m_search.isSelected(ps) || ItemSearchWidget.this.m_searchComponent.hasQuery(ps)) && super.isVisible(ps);
        }
    }

    private class ItemSearchFragment
    extends ItemSearchSectionInline {
        private ItemSearchWidget parent;

        public ItemSearchFragment(String name, String context, ItemSearchWidget parent, boolean limitToContentSection) {
            super(name, context, limitToContentSection);
            this.parent = parent;
        }

        public ItemSearchFragment(String name, String context, ItemSearchWidget parent, boolean limitToContentSection, ContentType type) {
            super(name, context, limitToContentSection, type);
            this.parent = parent;
        }

        public boolean isVisible(PageState ps) {
            return (ItemSearchWidget.this.m_search.isSelected(ps) || this.hasQuery(ps)) && super.isVisible(ps);
        }
    }

    private class LabelFragment
    extends Label {
        private ItemSearchWidget parent;

        public LabelFragment(String name, boolean escaping, ItemSearchWidget parent) {
            super(name, escaping);
            this.parent = parent;
        }
    }

    private class ClearFragment
    extends Submit {
        private ItemSearchWidget parent;

        public ClearFragment(String name, ItemSearchWidget parent) {
            super(name, "Clear");
            this.parent = parent;
            this.setAttribute("onClick", "this.form." + parent.m_selected.getName() + ".value = \"\";" + "this.form." + parent.m_item.getName() + ".value = \"\";" + "return false;");
            this.setAttribute("value", "Clear");
        }
    }

    private class SearchFragment
    extends Submit {
        private ItemSearchWidget parent;

        public SearchFragment(String name, ItemSearchWidget parent) {
            super(name, "Search");
            this.parent = parent;
            this.setAttribute("onClick", "return " + parent.m_selected.getName().replace('.', '_') + "Popup(this.form)");
            this.setAttribute("value", "Search");
        }

        public boolean isVisible(PageState ps) {
            return !this.parent.m_search.isSelected(ps) && !this.parent.m_searchComponent.hasQuery(ps) && super.isVisible(ps);
        }
    }

    private class ItemFragment
    extends TextField {
        private ItemSearchWidget parent;

        public ItemFragment(ParameterModel parameter, ItemSearchWidget parent) {
            super(parameter);
            this.parent = parent;
            this.setReadOnly();
            this.setSize(35);
        }
    }
}

