/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.Folder;
import com.arsdigita.xml.Element;
import java.util.Stack;

public class LevelOneFolderHierarchyNav
extends SimpleComponent {
    private boolean validPreConditions(PageState state) {
        return this.isVisible(state) && CMS.getContext().hasContentItem();
    }

    public void generateXML(PageState state, Element parent) {
        if (!this.validPreConditions(state)) {
            return;
        }
        Element parentElement = parent.newChildElement("cms:folderNavLinks", "http://www.arsdigita.com/cms/1.0");
        String contentSectionURL = CMS.getContext().getContentSection().getURL();
        Tree root = this.getTree(contentSectionURL);
        this.makeChildElement(parentElement, root);
    }

    private void makeChildElement(Element parentElement, Tree child) {
        Element childElement = parentElement.newChildElement("cms:folderNavLink", "http://www.arsdigita.com/cms/1.0");
        childElement.addAttribute("title", child.label);
        childElement.addAttribute("url", child.url);
        if (!child.isRoot) {
            if (child.isSelected) {
                childElement.addAttribute("selected", "1");
            } else if (child.isOpen) {
                childElement.addAttribute("open", "1");
            }
        }
        if (child.children != null) {
            while (!child.children.empty()) {
                this.makeChildElement(child.isRoot ? parentElement : childElement, (Tree)child.children.pop());
            }
        }
    }

    private Tree getTree(String contentSectionURL) {
        Tree tree = null;
        Tree prevTree = null;
        boolean wasSelected = false;
        for (Folder currFolder = this.getCurrentFolder(); currFolder != null; currFolder = (Folder)currFolder.getParent()) {
            tree = new Tree();
            tree.id = currFolder.getID().intValue();
            tree.label = currFolder.getLabel();
            StringBuffer path = new StringBuffer(contentSectionURL);
            String currFolderPath = currFolder.getPath();
            if (currFolderPath != null && currFolderPath.length() > 0) {
                path.append(currFolderPath).append('/');
            }
            tree.url = path.toString();
            tree.isOpen = true;
            if (!wasSelected) {
                wasSelected = true;
                tree.isSelected = true;
            }
            Stack folders = this.getChildFolders(currFolder);
            Stack<Tree> children = new Stack<Tree>();
            while (!folders.empty()) {
                Folder folder = (Folder)folders.pop();
                Tree child = new Tree();
                child.id = folder.getID().intValue();
                if (prevTree != null && prevTree.id == child.id) {
                    child = prevTree;
                    prevTree = null;
                } else {
                    child.label = folder.getLabel();
                    child.url = new StringBuffer(contentSectionURL).append(folder.getPath()).append('/').toString();
                }
                children.push(child);
            }
            tree.children = children;
            prevTree = tree;
        }
        if (tree != null) {
            tree.isRoot = true;
            tree.label = "Home";
        }
        return tree;
    }

    private Folder getCurrentFolder() {
        Folder folder;
        ContentItem curItem = CMS.getContext().getContentItem();
        try {
            folder = (Folder)curItem;
        }
        catch (ClassCastException ccex) {
            folder = (Folder)((ContentBundle)curItem.getParent()).getParent();
        }
        return folder;
    }

    private Stack getChildFolders(Folder folder) {
        Stack<Folder> folders = new Stack<Folder>();
        Folder.ItemCollection coll = folder.getItems();
        coll.addFolderFilter(true);
        while (coll.next()) {
            folders.push((Folder)coll.getContentItem());
        }
        coll.close();
        return folders;
    }

    class Tree {
        int id;
        String label;
        String url;
        Stack children;
        boolean isOpen = false;
        boolean isSelected = false;
        boolean isRoot = false;

        Tree() {
        }
    }
}

