/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ui.BaseAdminPane;
import com.arsdigita.cms.ui.report.ContentSectionSummaryTable;
import com.arsdigita.cms.ui.report.Report;
import com.arsdigita.cms.ui.report.ReportListModel;
import com.arsdigita.toolbox.ui.ActionGroup;
import com.arsdigita.toolbox.ui.Section;
import com.arsdigita.util.LockableImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class ReportPane
extends BaseAdminPane {
    private final SingleSelectionModel m_selectionModel;
    private final List<Report> m_availableReports = this.getReports();

    public ReportPane() {
        this.m_selectionModel = new ParameterSingleSelectionModel((ParameterModel)new StringParameter("sel"));
        this.m_selectionModel.addChangeListener((ChangeListener)new SelectionListener());
        this.setSelectionModel(this.m_selectionModel);
        com.arsdigita.bebop.List m_reports = new com.arsdigita.bebop.List((ListModelBuilder)new ReportListModelBuilder(this.m_availableReports));
        m_reports.setSelectionModel(this.m_selectionModel);
        ReportsListSection reportsListSection = new ReportsListSection(m_reports);
        this.setLeft((Component)reportsListSection);
        for (Report report : this.m_availableReports) {
            this.getBody().add(report.getComponent());
        }
        this.setIntroPane((Component)new Label(ReportPane.gz("cms.ui.reports.intro")));
    }

    private List<Report> getReports() {
        ArrayList<Report> reports = new ArrayList<Report>();
        reports.add(new Report("cms.ui.reports.css.reportName", (Component)new ContentSectionSummaryTable()));
        Collections.sort(reports, new Comparator<Report>(){

            @Override
            public int compare(Report r1, Report r2) {
                return r1.getName().compareTo(r2.getName());
            }
        });
        return reports;
    }

    private Report getReportByKey(String key) {
        for (Report report : this.m_availableReports) {
            if (!report.getKey().equals(key)) continue;
            return report;
        }
        return null;
    }

    private static class ReportListModelBuilder
    extends LockableImpl
    implements ListModelBuilder {
        private List<Report> reports;

        private ReportListModelBuilder(List<Report> reports) {
            this.reports = reports;
        }

        public final ListModel makeModel(com.arsdigita.bebop.List list, PageState state) {
            return new ReportListModel(this.reports);
        }
    }

    private class SelectionListener
    implements ChangeListener {
        private SelectionListener() {
        }

        public final void stateChanged(ChangeEvent e) {
            Report selectedReport;
            PageState state = e.getPageState();
            ReportPane.this.getBody().reset(state);
            if (ReportPane.this.m_selectionModel.isSelected(state) && (selectedReport = ReportPane.this.getReportByKey(ReportPane.this.m_selectionModel.getSelectedKey(state).toString())) != null) {
                ReportPane.this.getBody().push(state, selectedReport.getComponent());
            }
        }
    }

    private class ReportsListSection
    extends Section {
        ReportsListSection(com.arsdigita.bebop.List reports) {
            this.setHeading(BaseAdminPane.gz("cms.ui.reports.header"));
            ActionGroup group = new ActionGroup();
            this.setBody((Component)group);
            group.setSubject((Component)reports);
        }
    }
}

