/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.dispatcher.CMSPage;
import com.arsdigita.cms.dispatcher.ItemResolver;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.util.UncheckedWrapperException;
import java.io.IOException;
import java.math.BigDecimal;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class SearchResultRedirector
extends CMSPage {
    public static final String ITEM_ID = "item_id";
    public static final String CONTEXT = "context";
    private static final Logger s_log = Logger.getLogger(SearchResultRedirector.class);

    @Override
    public void dispatch(HttpServletRequest req, HttpServletResponse resp, RequestContext actx) {
        PageState state;
        BigDecimal id;
        try {
            id = new BigDecimal(this.getParam(ITEM_ID, req));
        }
        catch (NumberFormatException e) {
            s_log.error((Object)"Invalid CMS Item id", (Throwable)e);
            String itemID = this.getParam(ITEM_ID, req);
            throw new RuntimeException((String)GlobalizationUtil.globalize("cms.ui.invalid_item_id", new Object[]{itemID}).localize() + e.getMessage());
        }
        String context = this.getParam(CONTEXT, req);
        ContentItem item = new ContentItem(id);
        ContentSection section = item.getContentSection();
        ItemResolver resolver = section.getItemResolver();
        try {
            state = new PageState((Page)this, req, resp);
        }
        catch (ServletException ex) {
            throw new UncheckedWrapperException("Servlet Error: " + ex.getMessage(), (Throwable)ex);
        }
        String url = resolver.generateItemURL(state, item, section, context);
        try {
            DispatcherHelper.sendRedirect((HttpServletRequest)req, (HttpServletResponse)resp, (String)url);
        }
        catch (IOException e) {
            UncheckedWrapperException.throwLoggedException(this.getClass(), (String)("Could not redirect: " + e.getMessage()), (Throwable)e);
        }
    }

    private String getParam(String paramName, HttpServletRequest req) {
        String[] params = req.getParameterValues(paramName);
        if (params.length != 1) {
            s_log.error((Object)("Not one " + paramName));
            throw new RuntimeException("Not one " + paramName);
        }
        return params[0];
    }
}

