/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.DimensionalNavbar;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Resettable;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.ToggleLink;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.CheckboxGroup;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.SectionLocaleCollection;
import com.arsdigita.cms.Workspace;
import com.arsdigita.cms.dispatcher.CMSPage;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.ui.CMSContainer;
import com.arsdigita.cms.ui.CMSForm;
import com.arsdigita.cms.ui.ContentSectionNavbar;
import com.arsdigita.cms.ui.FolderProperties;
import com.arsdigita.cms.ui.LocalesListModelBuilder;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.globalization.Locale;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import java.util.TooManyListenersException;

public class SectionConfigurationPage
extends CMSPage
implements Resettable {
    private SectionInfo m_sectionInfo;
    private EditSection m_editSection;
    private AddLocale m_addLocale;
    private FolderProperties m_properties;
    private ToggleLink m_editLink;
    private ToggleLink m_addLink;
    private ToggleLink m_propertiesLink;

    public SectionConfigurationPage() {
        super("Content Section Configuration", (Container)new CMSContainer());
        this.setIdAttr("section_configuration");
        this.addNavbar();
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.content_section_configuration"), false));
        this.m_sectionInfo = new SectionInfo();
        this.add((Component)this.m_sectionInfo);
        this.m_editSection = new EditSection();
        this.m_editSection.addSubmissionListener(new FormSubmissionListener(){

            public void submitted(FormSectionEvent event) throws FormProcessException {
                PageState state = event.getPageState();
                if (SectionConfigurationPage.this.m_editSection.isCancelled(state)) {
                    SectionConfigurationPage.this.setDisplayMode(state);
                }
            }
        });
        this.m_editSection.addProcessListener(new FormProcessListener(){

            public void process(FormSectionEvent event) throws FormProcessException {
                PageState state = event.getPageState();
                SectionConfigurationPage.this.setDisplayMode(state);
            }
        });
        this.add((Component)this.m_editSection);
        this.m_editLink = this.m_sectionInfo.getEditLink();
        this.m_editLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PageState state = event.getPageState();
                if (SectionConfigurationPage.this.m_editLink.isSelected(state)) {
                    SectionConfigurationPage.this.setEditMode(state);
                }
            }
        });
        this.m_addLocale = new AddLocale();
        this.m_addLocale.addSubmissionListener(new FormSubmissionListener(){

            public void submitted(FormSectionEvent event) throws FormProcessException {
                PageState state = event.getPageState();
                if (SectionConfigurationPage.this.m_addLocale.isCancelled(state)) {
                    SectionConfigurationPage.this.setDisplayMode(state);
                }
            }
        });
        this.m_addLocale.addProcessListener(new FormProcessListener(){

            public void process(FormSectionEvent event) throws FormProcessException {
                PageState state = event.getPageState();
                SectionConfigurationPage.this.setDisplayMode(state);
            }
        });
        this.add((Component)this.m_addLocale);
        this.m_addLink = this.m_sectionInfo.getAddLink();
        this.m_addLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PageState state = event.getPageState();
                if (SectionConfigurationPage.this.m_addLink.isSelected(state)) {
                    SectionConfigurationPage.this.setAddMode(state);
                }
            }
        });
        this.m_properties = new FolderProperties();
        this.add((Component)this.m_properties);
        this.m_propertiesLink = new ToggleLink("Properties");
        this.m_propertiesLink.setClassAttr("actionLink");
        this.m_propertiesLink.setIdAttr("properties_link");
        this.m_propertiesLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                PageState state = event.getPageState();
                if (SectionConfigurationPage.this.m_propertiesLink.isSelected(state)) {
                    SectionConfigurationPage.this.setPropertiesMode(state);
                }
            }
        });
        this.add((Component)this.m_propertiesLink);
        this.setDefaultVisibility();
    }

    protected void addNavbar() {
        ColumnPanel cp = new ColumnPanel(2);
        cp.setClassAttr("CMS Admin");
        ContentSectionNavbar csn = new ContentSectionNavbar();
        cp.add((Component)csn, 9);
        DimensionalNavbar dn = new DimensionalNavbar();
        dn.setDelimiter(" - ");
        dn.add((Component)new Link((Component)new Label(GlobalizationUtil.globalize("cms.ui.my_workspace")), Workspace.getURL()));
        dn.add((Component)new Link((Component)new Label(GlobalizationUtil.globalize("cms.ui.sign_out")), Utilities.getLogoutURL()));
        dn.setClassAttr("top-right");
        cp.add((Component)dn, 12);
        this.add((Component)cp);
    }

    protected void setDefaultVisibility() {
        this.setVisibleDefault((Component)this.m_sectionInfo, true);
        this.setVisibleDefault((Component)this.m_editSection, false);
        this.setVisibleDefault((Component)this.m_addLocale, false);
        this.setVisibleDefault((Component)this.m_propertiesLink, true);
        this.setVisibleDefault((Component)this.m_properties, false);
    }

    protected void setEditMode(PageState state) {
        this.m_addLink.setSelected(state, false);
        this.m_sectionInfo.setVisible(state, false);
        this.m_editSection.setVisible(state, true);
        this.m_addLocale.setVisible(state, false);
        this.m_properties.setVisible(state, false);
        this.m_propertiesLink.setVisible(state, false);
    }

    protected void setAddMode(PageState state) {
        this.m_editLink.setSelected(state, false);
        this.m_sectionInfo.setVisible(state, false);
        this.m_editSection.setVisible(state, false);
        this.m_addLocale.setVisible(state, true);
        this.m_properties.setVisible(state, false);
        this.m_propertiesLink.setVisible(state, false);
    }

    protected void setDisplayMode(PageState state) {
        this.m_editLink.setSelected(state, false);
        this.m_addLink.setSelected(state, false);
        this.m_propertiesLink.setSelected(state, false);
        this.m_sectionInfo.setVisible(state, true);
        this.m_editSection.setVisible(state, false);
        this.m_addLocale.setVisible(state, false);
        this.m_properties.setVisible(state, false);
        this.m_propertiesLink.setVisible(state, true);
    }

    protected void setPropertiesMode(PageState state) {
        this.m_editLink.setSelected(state, false);
        this.m_addLink.setSelected(state, false);
        this.m_sectionInfo.setVisible(state, false);
        this.m_editSection.setVisible(state, false);
        this.m_addLocale.setVisible(state, false);
        this.m_properties.setVisible(state, true);
        this.m_propertiesLink.setVisible(state, false);
    }

    public void reset(PageState state) {
        this.setDisplayMode(state);
    }

    public class AddLocale
    extends CMSForm {
        private static final String LOCALES = "locales";
        private CheckboxGroup m_locales;
        private Submit m_submit;
        private Submit m_cancel;

        public AddLocale() {
            super("Add Locales to a Content Section");
            this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.locales")));
            this.m_locales = new CheckboxGroup(LOCALES);
            try {
                this.m_locales.addPrintListener(new PrintListener(){

                    public void prepare(PrintEvent event) {
                        PageState state = event.getPageState();
                        CheckboxGroup target = (CheckboxGroup)event.getTarget();
                        AddLocale.this.addLocales(state, (OptionGroup)target);
                    }
                });
            }
            catch (TooManyListenersException e) {
                throw new UncheckedWrapperException("Too many listeners", (Throwable)e);
            }
            this.add((Component)this.m_locales);
            SimpleContainer c = new SimpleContainer();
            this.m_submit = new Submit("submit", "Save");
            c.add((Component)this.m_submit);
            this.m_cancel = new Submit("cancel", "Cancel");
            c.add((Component)this.m_cancel);
            this.add((Component)c, 66);
            this.addInitListener(new FormInitListener(){

                public void init(FormSectionEvent event) throws FormProcessException {
                    PageState state = event.getPageState();
                    AddLocale.this.initializeLocales(state);
                }
            });
            this.addSubmissionListener(new FormSubmissionListener(){

                public void submitted(FormSectionEvent event) throws FormProcessException {
                    PageState state = event.getPageState();
                    if (AddLocale.this.isCancelled(state)) {
                        throw new FormProcessException((String)GlobalizationUtil.globalize("cms.ui.cancel_hit").localize());
                    }
                }
            });
            this.addProcessListener(new FormProcessListener(){

                public void process(FormSectionEvent event) throws FormProcessException {
                    PageState state = event.getPageState();
                    AddLocale.this.updateLocales(state);
                }
            });
        }

        protected void addLocales(PageState state, OptionGroup target) {
            ContentSection section = this.getContentSection(state);
            DataCollection dc = SessionManager.getSession().retrieve("com.arsdigita.globalization.Locale");
            SectionLocaleCollection slc = new SectionLocaleCollection(dc);
            while (slc.next()) {
                Locale l = slc.getLocale();
                target.addOption(new Option(l.getID().toString(), l.toJavaLocale().getDisplayName()));
            }
        }

        protected void initializeLocales(PageState state) throws FormProcessException {
        }

        protected void updateLocales(PageState state) throws FormProcessException {
            ContentSection section = this.getContentSection(state);
            String[] locales = (String[])this.m_locales.getValue(state);
            if (locales != null) {
                for (int i = 0; i < locales.length; ++i) {
                    Locale l = this.getLocale(new BigDecimal(locales[i]));
                    section.addLocale(l);
                }
            }
            section.save();
        }

        @Override
        public boolean isCancelled(PageState state) {
            return this.m_cancel.isSelected(state);
        }

        protected ContentSection getContentSection(PageState state) {
            ContentSection section = CMS.getContext().getContentSection();
            return section;
        }

        protected Locale getLocale(BigDecimal id) throws FormProcessException {
            Locale locale;
            OID oid = new OID("com.arsdigita.globalization.Locale", (Object)id);
            try {
                locale = new Locale(oid);
            }
            catch (DataObjectNotFoundException e) {
                throw new FormProcessException((Throwable)e);
            }
            return locale;
        }
    }

    public class EditSection
    extends CMSForm {
        private static final String NAME = "name";
        private static final String DEFAULT_LOCALE = "locale";
        private TextField m_name;
        private SingleSelect m_locale;
        private Submit m_submit;
        private Submit m_cancel;

        public EditSection() {
            super("Edit Content Section");
            this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.name")));
            this.m_name = new TextField(NAME);
            this.m_name.addValidationListener((ParameterListener)new NotNullValidationListener());
            this.add((Component)this.m_name);
            this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.default_locale")));
            this.m_locale = new SingleSelect((ParameterModel)new BigDecimalParameter(DEFAULT_LOCALE));
            this.m_locale.addOption(new Option(null, "-- select --"));
            try {
                this.m_locale.addPrintListener(new PrintListener(){

                    public void prepare(PrintEvent event) {
                        PageState state = event.getPageState();
                        SingleSelect target = (SingleSelect)event.getTarget();
                        EditSection.this.addLocales(state, (OptionGroup)target);
                    }
                });
            }
            catch (TooManyListenersException e) {
                throw new UncheckedWrapperException("Too many listeners", (Throwable)e);
            }
            this.add((Component)this.m_locale);
            SimpleContainer c = new SimpleContainer();
            this.m_submit = new Submit("submit", "Save");
            c.add((Component)this.m_submit);
            this.m_cancel = new Submit("cancel", "Cancel");
            c.add((Component)this.m_cancel);
            this.add((Component)c, 66);
            this.addInitListener(new FormInitListener(){

                public void init(FormSectionEvent event) throws FormProcessException {
                    PageState state = event.getPageState();
                    EditSection.this.initializeContentSection(state);
                }
            });
            this.addSubmissionListener(new FormSubmissionListener(){

                public void submitted(FormSectionEvent event) throws FormProcessException {
                    PageState state = event.getPageState();
                    if (EditSection.this.isCancelled(state)) {
                        throw new FormProcessException((String)GlobalizationUtil.globalize("cms.ui.cancel_hit").localize());
                    }
                }
            });
            this.addProcessListener(new FormProcessListener(){

                public void process(FormSectionEvent event) throws FormProcessException {
                    PageState state = event.getPageState();
                    EditSection.this.updateContentSection(state);
                }
            });
        }

        protected void addLocales(PageState state, OptionGroup target) {
            ContentSection section = this.getContentSection(state);
            SectionLocaleCollection slc = section.getLocales();
            while (slc.next()) {
                Locale l = slc.getLocale();
                String label = l.toJavaLocale().getDisplayName();
                target.addOption(new Option(l.getID().toString(), label));
            }
        }

        protected void initializeContentSection(PageState state) throws FormProcessException {
            ContentSection section = this.getContentSection(state);
            this.m_name.setValue(state, (Object)section.getName());
            Locale locale = section.getDefaultLocale();
            if (locale != null) {
                this.m_locale.setValue(state, (Object)locale.getID());
            } else {
                this.m_locale.setValue(state, null);
            }
        }

        protected void updateContentSection(PageState state) throws FormProcessException {
            ContentSection section = this.getContentSection(state);
            String name = (String)this.m_name.getValue(state);
            BigDecimal localeId = (BigDecimal)this.m_locale.getValue(state);
            Locale locale = null;
            if (localeId != null) {
                locale = this.getLocale(localeId);
            }
            section.setName(name);
            section.setDefaultLocale(locale);
            section.save();
        }

        @Override
        public boolean isCancelled(PageState state) {
            return this.m_cancel.isSelected(state);
        }

        protected ContentSection getContentSection(PageState state) {
            ContentSection section = CMS.getContext().getContentSection();
            return section;
        }

        protected Locale getLocale(BigDecimal id) throws FormProcessException {
            Locale locale;
            OID oid = new OID("com.arsdigita.globalization.Locale", (Object)id);
            try {
                locale = new Locale(oid);
            }
            catch (DataObjectNotFoundException e) {
                throw new FormProcessException((Throwable)e);
            }
            return locale;
        }
    }

    public class SectionInfo
    extends CMSContainer {
        private ToggleLink m_editLink = new ToggleLink("Edit");
        private List m_list;
        private ToggleLink m_addLink;

        public SectionInfo() {
            this.m_editLink.setClassAttr("actionLink");
            this.m_editLink.setIdAttr("edit_link");
            this.add((Component)this.m_editLink);
            this.m_list = new List((ListModelBuilder)new LocalesListModelBuilder());
            this.m_list.setIdAttr("locales_list");
            this.add((Component)this.m_list);
            this.m_addLink = new ToggleLink("Add locales");
            this.m_addLink.setClassAttr("actionLink");
            this.m_addLink.setIdAttr("add_locales_link");
            this.add((Component)this.m_addLink);
        }

        public ToggleLink getEditLink() {
            return this.m_editLink;
        }

        public ToggleLink getAddLink() {
            return this.m_addLink;
        }

        public void generateXML(PageState state, Element parent) {
            if (this.isVisible(state)) {
                Element element = new Element("cms:sectionInfo", "http://www.arsdigita.com/cms/1.0");
                ContentSection section = this.getContentSection(state);
                element.addAttribute("url", section.getURL());
                element.addAttribute("name", section.getName());
                Locale locale = section.getDefaultLocale();
                if (locale != null) {
                    element.addAttribute("locale", locale.toJavaLocale().toString());
                }
                this.m_editLink.generateXML(state, element);
                this.m_addLink.generateXML(state, element);
                this.exportAttributes(element);
                parent.addContent(element);
            }
        }

        protected ContentSection getContentSection(PageState state) {
            return CMS.getContext().getContentSection();
        }
    }
}

