/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;
import java.io.IOException;
import org.apache.log4j.Logger;

public abstract class SortableList
extends List {
    private static final Logger s_log = Logger.getLogger(SortableList.class);
    private static final String SELECT_EVENT = "s";
    protected static final String PREV_EVENT = "prev";
    protected static final String NEXT_EVENT = "next";
    private boolean m_sortItems;

    public SortableList(ParameterSingleSelectionModel model) {
        this(model, false);
    }

    public SortableList(ParameterSingleSelectionModel model, boolean suppressSort) {
        super((SingleSelectionModel)model);
        this.m_sortItems = !suppressSort;
    }

    public void generateXML(PageState state, Element parent) {
        boolean hasNext;
        if (!this.isVisible(state)) {
            return;
        }
        ListModel m = this.getModel(state);
        if (!m.next()) {
            super.generateXML(state, parent);
            return;
        }
        Element list = parent.newChildElement("cms:sortableList", "http://www.arsdigita.com/cms/1.0");
        this.exportAttributes(list);
        Object selKey = this.getSelectedKey(state);
        int i = 0;
        do {
            boolean selected;
            Element item = list.newChildElement("bebop:cell", "http://www.arsdigita.com/bebop/1.0");
            if (this.m_sortItems) {
                item.addAttribute("configure", "true");
            }
            String key = m.getKey();
            Assert.exists((Object)key);
            boolean bl = selected = selKey != null && key.equals(selKey.toString());
            if (selected) {
                item.addAttribute("selected", "selected");
            }
            this.generateLabelXML(state, item, new Label(m.getElement().toString()), key);
            hasNext = m.next();
            try {
                if (i > 0) {
                    state.setControlEvent((Component)this, PREV_EVENT, key);
                    item.addAttribute("prevURL", state.stateAsURL());
                }
                if (hasNext) {
                    state.setControlEvent((Component)this, NEXT_EVENT, key);
                    item.addAttribute("nextURL", state.stateAsURL());
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException("Caught IOException: " + ex.getMessage());
            }
            ++i;
        } while (hasNext);
        state.clearControlEvent();
    }

    protected void generateLabelXML(PageState state, Element parent, Label label, String key) {
        state.setControlEvent((Component)this, SELECT_EVENT, key);
        ControlLink c = new ControlLink((Component)label);
        c.generateXML(state, parent);
    }
}

