/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.Widget;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.UserHomeFolderMap;
import com.arsdigita.cms.ui.UserAddForm;
import com.arsdigita.cms.ui.UserSearchForm;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.ui.admin.Admin;
import com.arsdigita.web.Application;
import com.arsdigita.web.Web;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class UserAdminPane
extends SimpleContainer {
    private static final Logger s_log = Logger.getLogger(UserAdminPane.class);
    private final UserSearchForm m_userFolderResetForm = new UserSearchForm("userFolderResetForm", new Label("Reset a user's home folder to none"));
    private final UserFolderResetProcessForm m_userFolderResetProcessForm;
    private final Label m_submitLabel;
    private final Label m_deniedLabel;
    private final Link m_link;

    public UserAdminPane() {
        this.add((Component)this.m_userFolderResetForm);
        this.m_userFolderResetProcessForm = new UserFolderResetProcessForm();
        this.add((Component)this.m_userFolderResetProcessForm);
        this.m_submitLabel = new Label("No default folder set for users");
        this.add((Component)this.m_submitLabel);
        this.m_deniedLabel = new Label("You do not have permission to view this pane.");
        this.add((Component)this.m_deniedLabel);
        Application adminApp = Admin.getInstance();
        this.m_link = new Link("Administer users site-wide", adminApp == null ? "not_found" : adminApp.getPrimaryURL());
        this.add((Component)this.m_link);
    }

    private static boolean hasSiteWideAdmin(User user) {
        Application adminApp = Admin.getInstance();
        if (adminApp == null) {
            return false;
        }
        PermissionDescriptor admin = new PermissionDescriptor(PrivilegeDescriptor.ADMIN, (ACSObject)adminApp, (Party)user);
        return PermissionService.checkPermission((PermissionDescriptor)admin);
    }

    public final void generateXML(PageState state, Element parent) {
        User user;
        if (!this.isVisible(state)) {
            return;
        }
        SecurityManager sm = CMS.getContext().getSecurityManager();
        if (!sm.canAccess((Party)(user = Web.getContext().getUser()), "staff_admin")) {
            this.m_deniedLabel.generateXML(state, parent);
            return;
        }
        FormData one = this.m_userFolderResetForm.getFormData(state);
        FormData two = this.m_userFolderResetProcessForm.getForm().getFormData(state);
        if (one != null && one.isSubmission()) {
            this.m_userFolderResetForm.generateXML(state, parent);
            this.m_userFolderResetProcessForm.generateXML(state, parent);
        } else if (two != null && two.isSubmission()) {
            this.m_userFolderResetForm.generateXML(state, parent);
            this.m_submitLabel.generateXML(state, parent);
        } else {
            this.m_userFolderResetForm.generateXML(state, parent);
        }
        if (UserAdminPane.hasSiteWideAdmin(user)) {
            this.m_link.generateXML(state, parent);
        }
    }

    private static GlobalizedMessage gz(String key) {
        return GlobalizationUtil.globalize(key);
    }

    private static String lz(String key) {
        return (String)UserAdminPane.gz(key).localize();
    }

    private class UserFolderResetProcessForm
    extends UserAddForm {
        public UserFolderResetProcessForm() {
            super((Widget)UserAdminPane.this.m_userFolderResetForm.getSearchWidget(), "UserFolderResetProcess", "Select the users you wish to reset.", "Set no default folder for users");
        }

        @Override
        protected final DataQuery makeQuery(PageState state) {
            Session session = SessionManager.getSession();
            DataQuery query = session.retrieveQuery("com.arsdigita.cms.workflow.searchToAddMembers");
            String search = (String)this.getSearchWidget().getValue(state);
            this.makeFilter(query, search);
            query.addOrder("lastName, firstName, email");
            OID oid = CMS.getContext().getContentSection().getOID();
            PermissionService.objectFilterQuery((DataQuery)query, (String)"userId", (PrivilegeDescriptor)PrivilegeDescriptor.READ, (OID)oid);
            return query;
        }

        private void makeFilter(DataQuery query, String search) {
            query.clearFilter();
            Filter filter = query.addFilter("upper(firstName || lastName || email) like '%' || upper(:search) || '%'");
            filter.set("search", (Object)search);
        }

        @Override
        public final void process(FormSectionEvent e) throws FormProcessException {
            FormData data = e.getFormData();
            PageState state = e.getPageState();
            String[] users = (String[])data.get((Object)"users");
            if (users == null) {
                throw new FormProcessException(UserAdminPane.lz("cms.ui.workflow.no_users_were_selected"));
            }
            ContentSection section = CMS.getContext().getContentSection();
            for (int i = 0; i < users.length; ++i) {
                User user = User.retrieve((BigDecimal)new BigDecimal(users[i]));
                UserHomeFolderMap map = UserHomeFolderMap.findUserHomeFolderMap(user, section);
                if (map == null) continue;
                map.delete();
            }
        }
    }
}

