/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.authoring;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.parameters.DateParameter;
import com.arsdigita.bebop.parameters.ParameterData;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.ui.authoring.BasicItemForm;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.util.Assert;
import java.util.Date;
import javax.servlet.ServletException;

public abstract class BasicPageForm
extends BasicItemForm {
    private FormSection m_widgetSection;
    public static final String LAUNCH_DATE = "launchDate";

    public BasicPageForm(String formName, ItemSelectionModel itemModel) {
        super(formName, itemModel);
    }

    public BasicPageForm(String formName, ColumnPanel columnPanel, ItemSelectionModel itemModel) {
        super(formName, columnPanel, itemModel);
    }

    @Override
    protected void addWidgets() {
        super.addWidgets();
        if (!ContentSection.getConfig().getHideLaunchDate()) {
            this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.authoring.page_launch_date")));
            DateParameter launchDateParam = new DateParameter(LAUNCH_DATE);
            com.arsdigita.bebop.form.Date launchDate = new com.arsdigita.bebop.form.Date((ParameterModel)launchDateParam);
            if (ContentSection.getConfig().getRequireLaunchDate()) {
                launchDate.addValidationListener((ParameterListener)new LaunchDateValidationListener());
                launchDateParam.setDefaultValue((Object)new Date());
            }
            this.add((Component)launchDate);
        }
    }

    public ContentPage initBasicWidgets(FormSectionEvent e) {
        Assert.exists((Object)((Object)this.getItemSelectionModel()));
        FormData data = e.getFormData();
        PageState state = e.getPageState();
        ContentPage item = (ContentPage)this.getItemSelectionModel().getSelectedObject(state);
        if (item != null) {
            data.put((Object)"id", (Object)item.getID().toString());
            data.put((Object)"name", (Object)item.getName());
            data.put((Object)"title", (Object)item.getTitle());
            if (!ContentSection.getConfig().getHideLaunchDate()) {
                data.put((Object)LAUNCH_DATE, (Object)item.getLaunchDate());
                if (ContentSection.getConfig().getRequireLaunchDate() && item.getLaunchDate() == null) {
                    data.put((Object)LAUNCH_DATE, (Object)new Date());
                }
            }
        }
        return item;
    }

    @Override
    public void validate(FormSectionEvent fse) throws FormProcessException {
        super.validate(fse);
        ContentItem item = this.getItemSelectionModel().getSelectedItem(fse.getPageState());
        ACSObject parent = item.getParent();
        if (parent instanceof ContentBundle) {
            parent = ((ContentBundle)parent).getParent();
        }
        if (parent instanceof Folder) {
            Folder folder = (Folder)parent;
            Assert.exists((Object)folder);
            FormData data = fse.getFormData();
            String name = data.getString((Object)"name");
            if (!item.getName().equals(name)) {
                this.validateNameUniqueness(folder, fse);
            }
        }
    }

    public ContentPage processBasicWidgets(FormSectionEvent e) {
        Assert.exists((Object)((Object)this.getItemSelectionModel()));
        FormData data = e.getFormData();
        PageState state = e.getPageState();
        ContentPage item = (ContentPage)this.getItemSelectionModel().getSelectedObject(state);
        if (item != null) {
            item.setName((String)data.get((Object)"name"));
            item.setTitle((String)data.get((Object)"title"));
            if (!ContentSection.getConfig().getHideLaunchDate()) {
                item.setLaunchDate((Date)data.get((Object)LAUNCH_DATE));
            }
        }
        return item;
    }

    public ContentPage createContentPage(PageState state) throws FormProcessException {
        ItemSelectionModel m = this.getItemSelectionModel();
        Assert.exists((Object)((Object)m));
        ContentPage item = null;
        try {
            item = (ContentPage)m.createItem();
        }
        catch (ServletException ex) {
            throw new FormProcessException((String)GlobalizationUtil.globalize("cms.ui.authoring.couldnt_create_contentpage").localize(), (Throwable)ex);
        }
        m.setSelectedObject(state, (DomainObject)item);
        return item;
    }

    public class LaunchDateValidationListener
    implements ParameterListener {
        public void validate(ParameterEvent e) {
            ParameterData data = e.getParameterData();
            Object value = data.getValue();
            if (value == null) {
                data.addError("launch date is required");
                return;
            }
        }
    }
}

