/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.authoring;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.form.Widget;
import com.arsdigita.bebop.parameters.ArrayParameter;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.CategoryCollection;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.persistence.OID;
import com.arsdigita.xml.Element;
import com.arsdigita.xml.XML;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CategoryWidget
extends Widget {
    private BigDecimalParameter m_root;
    private StringParameter m_mode;

    public CategoryWidget(String name, BigDecimalParameter root, StringParameter mode) {
        super((ParameterModel)new ArrayParameter((ParameterModel)new BigDecimalParameter(name)));
        this.m_root = root;
        this.m_mode = mode;
    }

    protected String getType() {
        return "category";
    }

    public boolean isCompound() {
        return false;
    }

    protected void generateWidget(PageState state, Element parent) {
        Element widget = parent.newChildElement("cms:categoryWidget", "http://www.arsdigita.com/cms/1.0");
        this.exportAttributes(widget);
        widget.addAttribute("mode", (String)state.getValue((ParameterModel)this.m_mode));
        widget.addAttribute("name", this.getName());
        HashSet<BigDecimal> ids = new HashSet<BigDecimal>();
        BigDecimal[] values = (BigDecimal[])this.getValue(state);
        if (values != null) {
            ids.addAll(Arrays.asList(values));
        }
        Category root = (Category)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.categorization.Category", (Object)((BigDecimal)state.getValue((ParameterModel)this.m_root))));
        CategoryCollection cats = root.getDescendants();
        cats.addEqualsFilter("parents.link.relationType", (Object)"child");
        cats.addPath("parents.link.sortKey");
        cats.addPath("parents.id");
        HashMap<BigDecimal, ArrayList<CategorySortKeyPair>> children = new HashMap<BigDecimal, ArrayList<CategorySortKeyPair>>();
        while (cats.next()) {
            Category cat = cats.getCategory();
            BigDecimal parentID = (BigDecimal)cats.get("parents.id");
            ArrayList<CategorySortKeyPair> childList = (ArrayList<CategorySortKeyPair>)children.get(parentID);
            if (childList == null) {
                childList = new ArrayList<CategorySortKeyPair>();
                children.put(parentID, childList);
            }
            childList.add(new CategorySortKeyPair(cat, (BigDecimal)cats.get("parents.link.sortKey")));
        }
        this.generateCategory(widget, null, root, null, ids, children);
    }

    public void generateCategory(Element parent, String path, Category cat, BigDecimal sortKey, Set selected, Map children) {
        Element el = new Element("cms:category", "http://www.arsdigita.com/cms/1.0");
        el.addAttribute("id", XML.format((Object)cat.getID()));
        el.addAttribute("name", cat.getName());
        el.addAttribute("description", cat.getDescription());
        el.addAttribute("isSelected", selected.contains(cat.getID()) ? "1" : "0");
        el.addAttribute("isAbstract", cat.isAbstract() ? "1" : "0");
        el.addAttribute("isEnabled", cat.isEnabled() ? "1" : "0");
        if (sortKey != null) {
            el.addAttribute("sortKey", sortKey.toString());
        }
        el.addAttribute("order", ContentSection.getConfig().getCategoryTreeOrder());
        String fullname = path == null ? "/" : path + " > " + cat.getName();
        el.addAttribute("fullname", fullname);
        StringBuilder nodeID = new StringBuilder(parent.getAttribute("node-id"));
        if (nodeID.length() > 0) {
            nodeID.append("-");
        }
        nodeID.append(cat.getID());
        el.addAttribute("node-id", nodeID.toString());
        parent.addContent(el);
        List c = (List)children.get(cat.getID());
        if (c != null) {
            for (CategorySortKeyPair pair : c) {
                Category child = pair.getCategory();
                BigDecimal childSortKey = pair.getSortKey();
                this.generateCategory(el, fullname, child, childSortKey, selected, children);
            }
        }
    }

    private class CategorySortKeyPair {
        private Category m_category;
        private BigDecimal m_sortKey;

        public CategorySortKeyPair(Category category, BigDecimal sortKey) {
            this.m_category = category;
            this.m_sortKey = sortKey;
        }

        public Category getCategory() {
            return this.m_category;
        }

        public BigDecimal getSortKey() {
            return this.m_sortKey;
        }
    }
}

