/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.authoring;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.MetaForm;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.form.FormErrorDisplay;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.cms.AuthoringKit;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.ui.ContentItemPage;
import com.arsdigita.cms.ui.folder.FolderSelectionModel;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.web.RedirectSignal;
import com.arsdigita.web.URL;
import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class CreationSelector
extends MetaForm {
    private static Logger s_log = Logger.getLogger(CreationSelector.class);
    private final FolderSelectionModel m_folderSel;
    private final SingleSelectionModel m_typeSel;
    private static Class[] s_args = new Class[]{ItemSelectionModel.class, CreationSelector.class};
    private Object[] m_vals;
    private ItemSelectionModel m_itemSel;
    private BigDecimalParameter m_itemId;
    private ItemSelectionModel m_bundleSel;
    private BigDecimalParameter m_bundleId;
    public static final String ITEM_ID = "iid";
    public static final String BUNDLE_ID = "bid";

    public CreationSelector(SingleSelectionModel typeModel, FolderSelectionModel folderModel) {
        super("pageCreate");
        this.m_typeSel = typeModel;
        this.m_folderSel = folderModel;
        this.m_itemId = new BigDecimalParameter(ITEM_ID);
        this.m_bundleId = new BigDecimalParameter(BUNDLE_ID);
        this.m_bundleSel = new ItemSelectionModel(ContentBundle.class.getName(), "com.arsdigita.cms.ContentBundle", this.m_bundleId);
    }

    public Form buildForm(PageState state) {
        BigDecimal typeID = (BigDecimal)this.m_typeSel.getSelectedKey(state);
        Component c = null;
        Form returnForm = new Form("pageCreate");
        FormErrorDisplay fed = new FormErrorDisplay((Form)this);
        fed.setStateParamsAreRegistered(false);
        returnForm.add((Component)fed, 65);
        if (typeID != null) {
            try {
                ContentType type = new ContentType(typeID);
                AuthoringKit kit = type.getAuthoringKit();
                if (kit != null && (c = this.instantiateKitComponent(kit, type)) != null) {
                    returnForm.add(c);
                    returnForm.setMethod("post");
                    returnForm.setEncType("multipart/form-data");
                }
            }
            catch (DataObjectNotFoundException e) {
                // empty catch block
            }
        }
        return returnForm;
    }

    public void register(Page p) {
        super.register(p);
        p.addComponentStateParam((Component)this, (ParameterModel)this.m_itemId);
        p.addComponentStateParam((Component)this, (ParameterModel)this.m_bundleId);
    }

    protected Component instantiateKitComponent(AuthoringKit kit, ContentType type) {
        String creatorName = kit.getCreateComponent();
        if (creatorName == null) {
            return null;
        }
        try {
            Class<?> createClass = Class.forName(creatorName);
            ItemSelectionModel itemModel = new ItemSelectionModel(type, this.m_itemId);
            Object[] vals = new Object[]{itemModel, this};
            Constructor<?> constr = createClass.getConstructor(s_args);
            Component c = (Component)constr.newInstance(vals);
            return c;
        }
        catch (Exception e) {
            s_log.error((Object)"Instantiation failure", (Throwable)e);
            throw new UncheckedWrapperException("Failed to instantiate creation component " + kit.getCreateComponent() + ": " + e.getMessage(), (Throwable)e);
        }
    }

    public final Folder getFolder(PageState s) {
        return (Folder)this.m_folderSel.getSelectedObject(s);
    }

    public final ContentSection getContentSection(PageState s) {
        ContentSection section = this.getFolder(s).getContentSection();
        return section;
    }

    public void editItem(PageState s, ContentItem item) {
        ContentSection sec = this.getContentSection(s);
        String nodeURL = URL.getDispatcherPath() + sec.getPath() + "/";
        String target = ContentItemPage.getItemURL(nodeURL, item.getID(), ContentItemPage.AUTHORING_TAB, true);
        throw new RedirectSignal(target, true);
    }

    public void redirectBack(PageState state) {
        this.m_typeSel.clearSelection(state);
    }
}

