/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.authoring;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.TextAsset;
import com.arsdigita.cms.contenttypes.GenericArticle;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.TextAssetBody;
import com.arsdigita.cms.ui.workflow.WorkflowLockedComponentAccess;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.util.Assert;

public class GenericArticleBody
extends TextAssetBody {
    protected AuthoringKitWizard m_parent;
    protected ItemSelectionModel m_itemModel;

    public GenericArticleBody(ItemSelectionModel itemModel, AuthoringKitWizard parent) {
        super(new ItemAssetModel(itemModel));
        this.m_itemModel = itemModel;
        this.m_parent = parent;
        parent.getList().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                GenericArticleBody.this.reset(state);
            }
        });
        Component f = this.getComponent("file");
        if (f != null) {
            this.setComponentAccess("file", new WorkflowLockedComponentAccess(f, itemModel));
        }
        Component t = this.getComponent("text");
        this.setComponentAccess("text", new WorkflowLockedComponentAccess(t, itemModel));
    }

    @Override
    protected void setMimeTypeOptions(SingleSelect mimeSelect) {
        mimeSelect.addOption(new Option("text/html", "HTML Text"));
        mimeSelect.setOptionSelected("text/html");
    }

    @Override
    protected TextAsset createTextAsset(PageState s) {
        GenericArticle item = this.getGenericArticle(s);
        TextAsset t = new TextAsset();
        t.setName(item.getName() + "_text_" + item.getID());
        return t;
    }

    @Override
    protected void updateTextAsset(PageState s, TextAsset a) {
        GenericArticle t = this.getGenericArticle(s);
        Assert.exists((Object)t);
        t.setTextAsset(a);
        a.save();
        t.save();
    }

    protected GenericArticle getGenericArticle(PageState s) {
        return (GenericArticle)this.m_itemModel.getSelectedObject(s);
    }

    private static class ItemAssetModel
    extends ItemSelectionModel {
        private RequestLocal m_asset = new RequestLocal(){

            protected Object initialValue(PageState s) {
                GenericArticle t = (GenericArticle)((ItemSelectionModel)ItemAssetModel.this.getSingleSelectionModel()).getSelectedObject(s);
                Assert.exists((Object)t);
                return t.getTextAsset();
            }
        };

        public ItemAssetModel(ItemSelectionModel m) {
            super((SingleSelectionModel)m);
        }

        public Object getSelectedKey(PageState s) {
            TextAsset a = (TextAsset)this.getSelectedObject(s);
            return a == null ? null : a.getID();
        }

        public DomainObject getSelectedObject(PageState s) {
            return (DomainObject)this.m_asset.get(s);
        }

        public void setSelectedObject(PageState s, DomainObject o) {
            this.m_asset.set(s, (Object)o);
        }

        public void setSelectedKey(PageState s, Object key) {
            throw new UnsupportedOperationException((String)GlobalizationUtil.globalize("cms.ui.authoring.not_implemented").localize());
        }

        public boolean isSelected(PageState s) {
            return this.getSelectedObject(s) != null;
        }
    }
}

