/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.authoring;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Resettable;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.ItemCategoryExtension;
import com.arsdigita.cms.ui.authoring.ItemCategorySummary;
import com.arsdigita.util.Assert;
import com.arsdigita.util.Classes;
import com.arsdigita.web.RedirectSignal;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class ItemCategoryStep
extends SimpleContainer
implements Resettable {
    private static final Logger s_log = Logger.getLogger(ItemCategoryStep.class);
    private ItemCategorySummary m_summary;
    private SimpleComponent m_add;
    private SimpleComponent[] m_extensionSummaries;
    private SimpleComponent[] m_extensionForms;
    private int m_extensionsCount;
    private BigDecimalParameter m_root = new BigDecimalParameter("root");
    private StringParameter m_mode = new StringParameter("mode");

    public ItemCategoryStep(ItemSelectionModel itemModel, AuthoringKitWizard parent) {
        super("cms:categoryStep", "http://www.arsdigita.com/cms/1.0");
        this.m_summary = new ItemCategorySummary();
        this.m_summary.registerAction("add", new AddActionListener("plain"));
        this.m_summary.registerAction("addJS", new AddActionListener("javascript"));
        Class addForm = ContentSection.getConfig().getCategoryAuthoringAddForm();
        this.m_add = (SimpleComponent)Classes.newInstance((Class)addForm, (Class[])new Class[]{BigDecimalParameter.class, StringParameter.class}, (Object[])new Object[]{this.m_root, this.m_mode});
        this.m_add.addCompletionListener((ActionListener)new ResetListener());
        Class extensionClass = ContentSection.getConfig().getCategoryAuthoringExtension();
        ItemCategoryExtension extension = (ItemCategoryExtension)Classes.newInstance((Class)extensionClass);
        this.m_extensionSummaries = extension.getSummary();
        this.m_extensionForms = extension.getForm();
        int nSummaries = this.m_extensionSummaries.length;
        int nForms = this.m_extensionForms.length;
        Assert.isTrue((nSummaries == nForms ? 1 : 0) != 0, (String)"invalid CategoryStep extension");
        this.m_extensionsCount = nForms;
        for (int i = 0; i < this.m_extensionsCount; ++i) {
            this.m_extensionSummaries[i].addCompletionListener((ActionListener)new ExtensionListener(i));
            this.m_extensionForms[i].addCompletionListener((ActionListener)new ResetListener());
            this.add((Component)this.m_extensionSummaries[i]);
            this.add((Component)this.m_extensionForms[i]);
        }
        this.add((Component)this.m_summary);
        this.add((Component)this.m_add);
    }

    public void register(Page p) {
        super.register(p);
        p.setVisibleDefault((Component)this.m_add, false);
        for (int i = 0; i < this.m_extensionsCount; ++i) {
            p.setVisibleDefault((Component)this.m_extensionForms[i], false);
        }
        p.addGlobalStateParam((ParameterModel)this.m_root);
        p.addGlobalStateParam((ParameterModel)this.m_mode);
    }

    public void reset(PageState state) {
        state.setValue((ParameterModel)this.m_root, null);
        state.setValue((ParameterModel)this.m_mode, null);
        this.m_summary.setVisible(state, true);
        this.m_add.setVisible(state, false);
        for (int i = 0; i < this.m_extensionsCount; ++i) {
            this.m_extensionSummaries[i].setVisible(state, true);
            this.m_extensionForms[i].setVisible(state, false);
        }
    }

    private class ExtensionListener
    implements ActionListener {
        int extensionIndex;

        public ExtensionListener(int i) {
            this.extensionIndex = i;
        }

        public void actionPerformed(ActionEvent e) {
            PageState state = e.getPageState();
            ItemCategoryStep.this.m_summary.setVisible(state, false);
            ItemCategoryStep.this.m_add.setVisible(state, false);
            for (int i = 0; i < ItemCategoryStep.this.m_extensionsCount; ++i) {
                ItemCategoryStep.this.m_extensionSummaries[i].setVisible(state, false);
            }
            ItemCategoryStep.this.m_extensionForms[this.extensionIndex].setVisible(state, true);
        }
    }

    private class ResetListener
    implements ActionListener {
        private ResetListener() {
        }

        public void actionPerformed(ActionEvent e) {
            PageState state = e.getPageState();
            ItemCategoryStep.this.reset(state);
            throw new RedirectSignal(state.toURL(), true);
        }
    }

    private class AddActionListener
    implements ActionListener {
        private String m_mode;

        public AddActionListener(String mode) {
            this.m_mode = mode;
        }

        public void actionPerformed(ActionEvent e) {
            PageState state = e.getPageState();
            state.setValue((ParameterModel)ItemCategoryStep.this.m_root, (Object)new BigDecimal(state.getControlEventValue()));
            state.setValue((ParameterModel)ItemCategoryStep.this.m_mode, (Object)this.m_mode);
            ItemCategoryStep.this.m_summary.setVisible(state, false);
            ItemCategoryStep.this.m_add.setVisible(state, true);
            for (int i = 0; i < ItemCategoryStep.this.m_extensionsCount; ++i) {
                ItemCategoryStep.this.m_extensionSummaries[i].setVisible(state, false);
                ItemCategoryStep.this.m_extensionForms[i].setVisible(state, false);
            }
        }
    }
}

