/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.authoring;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.cms.AuthoringKit;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.FileAsset;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.ImageAsset;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.TextAsset;
import com.arsdigita.cms.ui.authoring.ApplyWorkflowFormSection;
import com.arsdigita.cms.ui.authoring.CreationComponent;
import com.arsdigita.cms.ui.authoring.CreationSelector;
import com.arsdigita.cms.ui.authoring.PageCreate;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.dispatcher.MultipartHttpServletRequest;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.metadata.DynamicObjectType;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.MetadataRoot;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.Assert;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;

public class PageCreateDynamic
extends FormSection
implements FormInitListener,
FormProcessListener,
FormValidationListener,
FormSubmissionListener,
CreationComponent {
    private static Logger s_log = Logger.getLogger((String)PageCreateDynamic.class.getName());
    private ItemSelectionModel m_itemModel;
    private static Class[] s_args = new Class[]{ItemSelectionModel.class, CreationSelector.class};
    private static Class[] s_userDefinedArgs = new Class[]{ItemSelectionModel.class, CreationSelector.class, ContentType.class};
    private ContentType m_useContentType = null;
    private ContentType m_parentType = null;
    private CreationComponent m_parentComponent = null;
    public static final String NAME = "name";
    public static final String TITLE = "title";
    public static final String LAUNCH_DATE = "launchDate";
    public static final String LANGUAGE = "language";
    private CreationSelector m_parent;
    public static final String SECTION_ID = "sid";

    public PageCreateDynamic(ItemSelectionModel itemModel, CreationSelector parent) {
        this(itemModel, parent, null);
    }

    public PageCreateDynamic(ItemSelectionModel itemModel, CreationSelector parent, ContentType useContentType) {
        ObjectType parentObjectType;
        ObjectType thisObjectType;
        this.m_itemModel = itemModel;
        this.m_parent = parent;
        this.m_useContentType = useContentType;
        if (this.m_useContentType == null) {
            this.m_useContentType = this.m_itemModel.getContentType();
        }
        if ((thisObjectType = MetadataRoot.getMetadataRoot().getObjectType(this.m_useContentType.getAssociatedObjectType())) != null && (parentObjectType = thisObjectType.getSupertype()) != null) {
            try {
                this.m_parentType = ContentType.findByAssociatedObjectType(parentObjectType.getQualifiedName());
            }
            catch (DataObjectNotFoundException e) {
                // empty catch block
            }
        }
        AuthoringKit parentKit = null;
        if (this.m_parentType != null) {
            parentKit = this.m_parentType.getAuthoringKit();
        }
        String parentCreateComponent = null;
        if (parentKit != null) {
            parentCreateComponent = parentKit.getCreateComponent();
        }
        if (parentCreateComponent != null) {
            try {
                Class[] args;
                Object[] vals;
                Class<?> createClass = Class.forName(parentCreateComponent);
                if (parentCreateComponent.equals("com.arsdigita.cms.ui.authoring.PageCreateDynamic")) {
                    vals = new Object[]{this.m_itemModel, parent, this.m_parentType};
                    args = s_userDefinedArgs;
                } else {
                    vals = new Object[]{this.m_itemModel, parent};
                    args = s_args;
                }
                Constructor<?> constr = createClass.getConstructor(args);
                Component tempComponent = (Component)constr.newInstance(vals);
                if (tempComponent instanceof CreationComponent) {
                    this.m_parentComponent = (CreationComponent)tempComponent;
                }
            }
            catch (Exception e) {}
        } else {
            this.m_parentComponent = new PageCreate(this.m_itemModel, parent);
        }
        if (this.m_parentComponent != null) {
            super.add((Component)this.m_parentComponent);
            this.getSaveCancelSection().getSaveButton().setButtonLabel("Create");
            this.addInitListener(this);
            this.m_parentComponent.removeProcessListener(this.m_parentComponent);
            this.addProcessListener(this);
            this.addValidationListener(this);
        } else {
            this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.authoring.invalid_create_component")));
        }
    }

    public ItemSelectionModel getItemSelectionModel() {
        return this.m_itemModel;
    }

    @Override
    public void addSaveCancelSection() {
        if (this.m_parentComponent != null) {
            this.m_parentComponent.addSaveCancelSection();
        }
    }

    @Override
    public SaveCancelSection getSaveCancelSection() {
        if (this.m_parentComponent != null) {
            return this.m_parentComponent.getSaveCancelSection();
        }
        return null;
    }

    @Override
    public ApplyWorkflowFormSection getWorkflowSection() {
        if (this.m_parentComponent != null) {
            return this.m_parentComponent.getWorkflowSection();
        }
        return null;
    }

    public void init(FormSectionEvent e) throws FormProcessException {
    }

    public void submitted(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        if (this.getSaveCancelSection().getCancelButton().isSelected(state)) {
            this.m_parent.redirectBack(state);
            throw new FormProcessException((String)GlobalizationUtil.globalize("cms.ui.authoring.submission_cancelled").localize());
        }
    }

    public void validate(FormSectionEvent e) throws FormProcessException {
        Folder f = this.m_parent.getFolder(e.getPageState());
        Assert.exists((Object)f);
        this.validateNameUniqueness(f, e);
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        FormData data = e.getFormData();
        PageState state = e.getPageState();
        ContentPage item = this.createUDItem(state);
        item.setLanguage((String)data.get((Object)LANGUAGE));
        item.setName((String)data.get((Object)NAME));
        item.setTitle((String)data.get((Object)TITLE));
        if (!ContentSection.getConfig().getHideLaunchDate()) {
            item.setLaunchDate((Date)data.get((Object)LAUNCH_DATE));
        }
        this.m_itemModel.setSelectedKey(state, item.getID());
        this.m_itemModel.setSelectedObject(state, (DomainObject)item);
        DynamicObjectType dot = new DynamicObjectType(this.m_useContentType.getAssociatedObjectType());
        ObjectType thisObjType = dot.getObjectType();
        ArrayList<TextAsset> assetsToSave = new ArrayList<TextAsset>();
        do {
            Iterator declaredProperties = thisObjType.getDeclaredProperties();
            Property currentProperty = null;
            Object value = null;
            while (declaredProperties.hasNext()) {
                currentProperty = (Property)declaredProperties.next();
                try {
                    String fileName;
                    String currentPropertyName;
                    value = data.get((Object)currentProperty.getName());
                    if (value == null) continue;
                    if (currentProperty.isAttribute()) {
                        item.set(currentProperty.getName(), value);
                        continue;
                    }
                    if (currentProperty.getType().getName().equals("TextAsset")) {
                        TextAsset thisAsset = new TextAsset();
                        thisAsset.setName(item.getName() + "_text_" + thisAsset.getID());
                        assetsToSave.add(thisAsset);
                        thisAsset.setText((String)value);
                        thisAsset.save();
                        DataObject thisDataObj = SessionManager.getSession().retrieve(thisAsset.getOID());
                        item.set(currentProperty.getName(), thisDataObj);
                        continue;
                    }
                    if (currentProperty.getType().getName().equals("ImageAsset")) {
                        currentPropertyName = currentProperty.getName();
                        String imageAction = (String)data.get((Object)(currentPropertyName + "." + "action"));
                        fileName = (String)data.get((Object)(currentPropertyName + "." + "file_upload"));
                        if (imageAction.equals("upload")) {
                            File file = null;
                            if (fileName == null || fileName.length() <= 0) continue;
                            file = ((MultipartHttpServletRequest)state.getRequest()).getFile(currentPropertyName + "." + "file_upload");
                            ImageAsset a = new ImageAsset();
                            try {
                                a.loadFromFile(fileName, file, "image/jpeg");
                            }
                            catch (IOException ex) {
                                s_log.error((Object)"Error creating new item", (Throwable)ex);
                                throw new FormProcessException((Throwable)ex);
                            }
                            a.save();
                            DataObject thisDataObj = SessionManager.getSession().retrieve(a.getOID());
                            item.set(currentPropertyName, thisDataObj);
                            continue;
                        }
                        if (!imageAction.equals("delete") && !imageAction.equals("none")) continue;
                    }
                    if (currentProperty.getType().getName().equals("FileAsset")) {
                        currentPropertyName = currentProperty.getName();
                        String fileAction = (String)data.get((Object)(currentPropertyName + "." + "action"));
                        fileName = (String)data.get((Object)(currentPropertyName + "." + "file_upload"));
                        String mimeType = (String)data.get((Object)(currentPropertyName + "." + "mime_type"));
                        if (fileAction.equals("upload")) {
                            File file = null;
                            if (fileName == null || fileName.length() <= 0) continue;
                            file = ((MultipartHttpServletRequest)state.getRequest()).getFile(currentPropertyName + "." + "file_upload");
                            FileAsset a = new FileAsset();
                            try {
                                a.loadFromFile(fileName, file, "-guess-".equals(mimeType) ? (String)null : mimeType);
                            }
                            catch (IOException ex) {
                                s_log.error((Object)"Error creating new item", (Throwable)ex);
                                throw new FormProcessException((Throwable)ex);
                            }
                            a.save();
                            DataObject thisDataObj = SessionManager.getSession().retrieve(a.getOID());
                            item.set(currentPropertyName, thisDataObj);
                            continue;
                        }
                        if (!fileAction.equals("delete") && !fileAction.equals("none")) continue;
                    }
                    String typeName = currentProperty.getType().getQualifiedName();
                    try {
                        ContentType assocType = ContentType.findByAssociatedObjectType(typeName);
                        if (value == null || value.equals("")) {
                            item.set(currentProperty.getName(), null);
                            continue;
                        }
                        DataObject thisObj = SessionManager.getSession().retrieve(new OID(typeName, (Object)new BigDecimal((String)value)));
                        item.set(currentProperty.getName(), thisObj);
                    }
                    catch (DataObjectNotFoundException ex) {
                    }
                }
                catch (IllegalArgumentException ex) {}
            }
        } while ((thisObjType = thisObjType.getSupertype()) != null && thisObjType.getQualifiedName() != "com.arsdigita.cms.ContentPage");
        ContentBundle bundle = new ContentBundle(item);
        bundle.setParent((ACSObject)this.m_parent.getFolder(state));
        bundle.setContentSection(this.m_parent.getContentSection(state));
        item.save();
        bundle.save();
        for (TextAsset thisAsset : assetsToSave) {
            thisAsset.setParent((ACSObject)item);
            thisAsset.save();
        }
        ContentSection section = this.m_parent.getContentSection(state);
        this.m_parentComponent.getWorkflowSection().applyWorkflow(state, item);
        this.m_parent.editItem(state, item);
    }

    public void validateNameUniqueness(Folder parent, FormSectionEvent e) throws FormProcessException {
        FormData data = e.getFormData();
        if (parent.getItem((String)data.get((Object)NAME), false) != null) {
            throw new FormProcessException((String)GlobalizationUtil.globalize("cms.ui.authoring.an_item_with_this_name_already_exists").localize());
        }
    }

    public ContentPage createUDItem(PageState state) throws FormProcessException {
        ItemSelectionModel m = this.getItemSelectionModel();
        ContentPage item = null;
        try {
            if (this.m_useContentType == null) {
                item = (ContentPage)m.createItem();
            } else {
                Class<?> itemClass = Class.forName(this.m_useContentType.getClassName());
                Constructor<?> constr = itemClass.getConstructor(String.class);
                item = (ContentPage)constr.newInstance(this.m_useContentType.getAssociatedObjectType());
                item.setContentType(this.m_useContentType);
            }
        }
        catch (ServletException ex) {
            s_log.error((Object)"error creating new item", (Throwable)ex);
            throw new FormProcessException("couldn't create item", (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            s_log.error((Object)"error creating new item", (Throwable)ex);
            throw new FormProcessException("couldn't create item", (Throwable)ex);
        }
        catch (NoSuchMethodException ex) {
            s_log.error((Object)"error creating new item", (Throwable)ex);
            throw new FormProcessException("couldn't create item", (Throwable)ex);
        }
        catch (InstantiationException ex) {
            s_log.error((Object)"error creating new item", (Throwable)ex);
            throw new FormProcessException("couldn't create item", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            s_log.error((Object)"programmer's error: cnstr should've been made public", (Throwable)ex);
            throw new FormProcessException("couldn't create item", (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            s_log.error((Object)"error creating new item", (Throwable)ex);
            throw new FormProcessException("couldn't create item", (Throwable)ex);
        }
        if (m.getSelectedKey(state) == null) {
            m.setSelectedObject(state, (DomainObject)item);
        }
        return item;
    }

    public void add(Component pc) {
        if (this.m_parentComponent != null) {
            this.m_parentComponent.add(pc);
        } else {
            super.add(pc);
        }
    }

    public void add(Component pc, int constraints) {
        if (this.m_parentComponent != null) {
            this.m_parentComponent.add(pc, constraints);
        } else {
            super.add(pc, constraints);
        }
    }

    public static class ContentItemSelectPrintListener
    implements PrintListener {
        private String m_contentTypeStr = null;

        public ContentItemSelectPrintListener(String contentType) {
            this.m_contentTypeStr = contentType;
        }

        public void prepare(PrintEvent event) {
            SingleSelect t = (SingleSelect)event.getTarget();
            PageState s = event.getPageState();
            ContentSection section = CMS.getContext().getContentSection();
            t.addOption(new Option("", "-- select --"));
            ContentType contentType = null;
            try {
                contentType = ContentType.findByAssociatedObjectType(this.m_contentTypeStr);
                ObjectType contentObjectType = MetadataRoot.getMetadataRoot().getObjectType(contentType.getAssociatedObjectType());
                DataCollection items = SessionManager.getSession().retrieve(contentObjectType);
                while (items.next()) {
                    try {
                        ContentItem item = (ContentItem)DomainObjectFactory.newInstance((DataObject)items.getDataObject());
                        if (!"draft".equals(item.getVersion())) continue;
                        BigDecimal itemID = item.getID();
                        String title = null;
                        title = item instanceof ContentPage ? ((ContentPage)item).getTitle() : item.getName();
                        t.addOption(new Option(itemID.toString(), title));
                    }
                    catch (PersistenceException ex) {}
                }
            }
            catch (DataObjectNotFoundException e) {
                // empty catch block
            }
        }
    }
}

