/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.authoring;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.ui.ItemPropertySheet;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.BasicPageForm;
import com.arsdigita.cms.ui.authoring.SimpleEditStep;
import com.arsdigita.cms.ui.workflow.WorkflowLockedComponentAccess;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.util.Assert;
import java.text.DateFormat;
import org.apache.log4j.Logger;

public class PageEdit
extends SimpleEditStep {
    private static Logger s_log = Logger.getLogger(PageEdit.class);
    public static final boolean VALUE_OUTPUT_ESCAPE = true;

    public PageEdit(ItemSelectionModel itemModel, AuthoringKitWizard parent) {
        super(itemModel, parent);
        PageEditForm form = new PageEditForm(itemModel);
        this.add("edit", "Edit", new WorkflowLockedComponentAccess((Component)form, itemModel), form.getSaveCancelSection().getCancelButton());
        ItemPropertySheet sheet = new ItemPropertySheet(itemModel, true);
        sheet.add((String)GlobalizationUtil.globalize("cms.ui.authoring.name").localize(), "name");
        sheet.add((String)GlobalizationUtil.globalize("cms.ui.authoring.title").localize(), "title");
        if (!ContentSection.getConfig().getHideLaunchDate()) {
            sheet.add("Launch Date:", "launchDate", new ItemPropertySheet.AttributeFormatter(){

                @Override
                public String format(ContentItem item, String attribute, PageState state) {
                    ContentPage page = (ContentPage)item;
                    if (page.getLaunchDate() != null) {
                        return DateFormat.getDateInstance(1).format(page.getLaunchDate());
                    }
                    return "<i>unknown</i>";
                }
            });
        }
        this.setDisplayComponent((Component)sheet);
    }

    private class PageEditForm
    extends BasicPageForm {
        public PageEditForm(ItemSelectionModel itemModel) {
            super("PageEditForm", itemModel);
        }

        @Override
        public void init(FormSectionEvent e) throws FormProcessException {
            super.initBasicWidgets(e);
        }

        @Override
        public void process(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            ContentPage item = super.processBasicWidgets(e);
            if (item != null) {
                item.save();
            }
        }

        @Override
        public void validate(FormSectionEvent event) throws FormProcessException {
            super.validate(event);
            PageState state = event.getPageState();
            FormData data = event.getFormData();
            ContentItem item = (ContentItem)this.getItemSelectionModel().getSelectedObject(state);
            Assert.exists((Object)item);
            String newName = (String)data.get((Object)"name");
            String oldName = item.getName();
            if (!newName.equalsIgnoreCase(oldName)) {
                this.validateNameUniqueness((Folder)item.getParent(), event);
            }
        }
    }
}

