/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.authoring;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Date;
import com.arsdigita.bebop.form.Hidden;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.DateParameter;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.parameters.TrimmedStringParameter;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.FileAsset;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.ImageAsset;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.TextAsset;
import com.arsdigita.cms.ui.FileUploadSection;
import com.arsdigita.cms.ui.SecurityPropertyEditor;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.ui.authoring.BasicPageForm;
import com.arsdigita.cms.ui.authoring.NameValidationListener;
import com.arsdigita.cms.ui.authoring.PageCreateDynamic;
import com.arsdigita.cms.ui.authoring.WorkflowLockedComponentAccess;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.dispatcher.MultipartHttpServletRequest;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.formbuilder.PersistentComponent;
import com.arsdigita.formbuilder.PersistentForm;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.ui.DomainObjectSelectionModel;
import com.arsdigita.metadata.DynamicObjectType;
import com.arsdigita.persistence.DataAssociationCursor;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.toolbox.ui.DomainObjectPropertySheet;
import com.arsdigita.util.Assert;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Iterator;
import java.util.TooManyListenersException;
import org.apache.log4j.Logger;

public class PageEditDynamic
extends SecurityPropertyEditor {
    private static Logger s_log = Logger.getLogger((String)PageEditDynamic.class.getName());
    private AuthoringKitWizard m_parent;
    private ItemSelectionModel m_itemModel;
    private ContentType m_originatingType = null;
    private boolean m_isPrimaryStep = true;

    public PageEditDynamic(ItemSelectionModel itemModel, AuthoringKitWizard parent) {
        this(itemModel, parent, null);
    }

    public PageEditDynamic(ItemSelectionModel itemModel, AuthoringKitWizard parent, ContentType originatingType) {
        this(itemModel, parent, originatingType, true);
    }

    public PageEditDynamic(ItemSelectionModel itemModel, AuthoringKitWizard parent, ContentType originatingType, boolean isPrimaryStep) {
        this.m_parent = parent;
        this.m_itemModel = itemModel;
        this.m_originatingType = originatingType;
        this.m_isPrimaryStep = isPrimaryStep;
        if (this.m_originatingType == null) {
            this.m_originatingType = this.m_itemModel.getContentType();
        }
        parent.getList().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                PageEditDynamic.this.showDisplayPane(state);
            }
        });
        PageEditDynamicForm form = new PageEditDynamicForm(itemModel);
        this.add("edit", "Edit", new WorkflowLockedComponentAccess((Component)form, itemModel), form.getSaveCancelSection().getCancelButton());
        DomainObjectPropertySheet sheet = new DomainObjectPropertySheet((DomainObjectSelectionModel)itemModel);
        this.addNameTitleFields(sheet);
        DynamicObjectType dot = new DynamicObjectType(this.m_originatingType.getAssociatedObjectType());
        Iterator declaredProperties = dot.getObjectType().getDeclaredProperties();
        Property currentProperty = null;
        while (declaredProperties.hasNext()) {
            currentProperty = (Property)declaredProperties.next();
            String propertyPath = currentProperty.getName();
            if (currentProperty.getType().getName().equals("TextAsset")) {
                propertyPath = propertyPath + ".content";
            } else if (currentProperty.getType().getName().equals("ImageAsset")) {
                propertyPath = propertyPath + ".displayName";
            } else if (currentProperty.getType().getName().equals("FileAsset")) {
                propertyPath = propertyPath + ".displayName";
            } else if (!currentProperty.isAttribute()) {
                propertyPath = propertyPath + ".title";
            }
            sheet.add(currentProperty.getName().concat(":"), propertyPath);
        }
        this.setDisplayComponent((Component)sheet);
    }

    protected void addNameTitleFields(DomainObjectPropertySheet sheet) {
        sheet.add((String)GlobalizationUtil.globalize("cms.ui.authoring.name").localize(), "name");
        sheet.add((String)GlobalizationUtil.globalize("cms.ui.authoring.title").localize(), "title");
        if (!ContentSection.getConfig().getHideLaunchDate()) {
            sheet.add("Launch Date:", "launchDate", new DomainObjectPropertySheet.AttributeFormatter(){

                public String format(DomainObject item, String attribute, PageState state) {
                    ContentPage page = (ContentPage)item;
                    if (page.getLaunchDate() != null) {
                        return DateFormat.getDateInstance(1).format(page.getLaunchDate());
                    }
                    return "<i>unknown</i>";
                }
            });
        }
    }

    public AuthoringKitWizard getParentWizard() {
        return this.m_parent;
    }

    public ItemSelectionModel getItemSelectionModel() {
        return this.m_itemModel;
    }

    private class PageEditDynamicForm
    extends BasicPageForm {
        public PageEditDynamicForm(ItemSelectionModel itemModel) {
            super(PageEditDynamic.this.m_originatingType.getLabel() + "PageEditDynamicForm", new ColumnPanel(3), itemModel);
            PageEditDynamic.this.m_itemModel = itemModel;
            ColumnPanel panel = (ColumnPanel)this.getPanel();
            panel.setBorder(false);
            panel.setPadColor("#FFFFFF");
            this.addWidgets();
            this.addPersistentWidgets(itemModel);
            this.addSaveCancelSection();
            this.addInitListener(this);
            this.addProcessListener(this);
            this.addValidationListener(this);
        }

        @Override
        protected void addWidgets() {
            if (PageEditDynamic.this.m_isPrimaryStep) {
                this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.authoring.name")));
                this.add((Component)new Label(""));
                TextField nameWidget = new TextField((ParameterModel)new TrimmedStringParameter("name"));
                nameWidget.addValidationListener((ParameterListener)new NameValidationListener());
                this.add((Component)nameWidget);
                this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.authoring.title")));
                this.add((Component)new Label(""));
                TextField titleWidget = new TextField((ParameterModel)new TrimmedStringParameter("title"));
                titleWidget.addValidationListener((ParameterListener)new NotNullValidationListener());
                this.add((Component)titleWidget);
                this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.authoring.page_launch_date")));
                this.add((Component)new Label(""));
                DateParameter launchDateParam = new DateParameter("launchDate");
                launchDateParam.addParameterListener((ParameterListener)new NotNullValidationListener());
                Date launchDate = new Date((ParameterModel)launchDateParam);
                this.add((Component)launchDate);
            }
        }

        private void addPersistentWidgets(ItemSelectionModel itemSel) {
            ContentType type = itemSel.getContentType();
            PersistentForm pForm = PageEditDynamic.this.m_originatingType.getItemForm();
            DataAssociationCursor components = pForm.getComponents();
            String associationTypeParameter = null;
            String associationContentType = null;
            while (components.next()) {
                PersistentComponent component = (PersistentComponent)DomainObjectFactory.newInstance((DataObject)components.getDataObject());
                Component thisComponent = component.createComponent();
                if (thisComponent instanceof Hidden) {
                    FileUploadSection fileUpload;
                    SingleSelect actionSelect;
                    String thisParameterName = ((Hidden)thisComponent).getParameterModel().getName();
                    String thisValue = ((Hidden)thisComponent).getDefaultValue();
                    if ((thisParameterName + ".image").equals(thisValue)) {
                        FormSection imageUploadSection = new FormSection((Container)new ColumnPanel(2));
                        actionSelect = new SingleSelect((ParameterModel)new StringParameter(thisParameterName + "." + "action"));
                        actionSelect.addOption(new Option("none", "Leave Image Unchanged"));
                        actionSelect.addOption(new Option("upload", "Upload New Image"));
                        actionSelect.addOption(new Option("delete", "Delete Current Image"));
                        imageUploadSection.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.authoring.image_action")));
                        imageUploadSection.add((Component)actionSelect);
                        fileUpload = new FileUploadSection("Image&nbsp;Type:", "image", "image/jpeg", thisParameterName + ".");
                        imageUploadSection.add((Component)fileUpload, 128);
                        this.add((Component)imageUploadSection);
                    } else if ((thisParameterName + ".file").equals(thisValue)) {
                        FormSection fileAssetUploadSection = new FormSection((Container)new ColumnPanel(2));
                        actionSelect = new SingleSelect((ParameterModel)new StringParameter(thisParameterName + "." + "action"));
                        actionSelect.addOption(new Option("none", "Leave File Unchanged"));
                        actionSelect.addOption(new Option("upload", "Upload New File"));
                        actionSelect.addOption(new Option("delete", "Delete Current File"));
                        fileAssetUploadSection.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.authoring.file_action")));
                        fileAssetUploadSection.add((Component)actionSelect);
                        fileUpload = new FileUploadSection("File&nbsp;Type:", null, null, thisParameterName + ".");
                        fileAssetUploadSection.add((Component)fileUpload, 128);
                        this.add((Component)fileAssetUploadSection);
                    } else {
                        associationContentType = thisValue;
                        associationTypeParameter = thisParameterName;
                    }
                }
                if (thisComponent instanceof SingleSelect && (((SingleSelect)thisComponent).getParameterModel().getName() + "Type").equals(associationTypeParameter)) {
                    try {
                        ((SingleSelect)thisComponent).addPrintListener((PrintListener)new PageCreateDynamic.ContentItemSelectPrintListener(associationContentType));
                    }
                    catch (TooManyListenersException ex) {
                        // empty catch block
                    }
                }
                this.add(thisComponent);
            }
        }

        @Override
        public void init(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            FormData data = e.getFormData();
            ContentPage item = PageEditDynamic.this.m_isPrimaryStep ? super.initBasicWidgets(e) : (ContentPage)this.getItemSelectionModel().getSelectedObject(state);
            DynamicObjectType dot = new DynamicObjectType(PageEditDynamic.this.m_originatingType.getAssociatedObjectType());
            if (item != null) {
                Iterator declaredProperties = dot.getObjectType().getDeclaredProperties();
                Property currentProperty = null;
                Object value = null;
                while (declaredProperties.hasNext()) {
                    currentProperty = (Property)declaredProperties.next();
                    value = item.get(currentProperty.getName());
                    if (value != null && currentProperty.getType().getName().equals("TextAsset")) {
                        String content = (String)((DataObject)value).get("content");
                        data.put((Object)currentProperty.getName(), (Object)content);
                        continue;
                    }
                    if (currentProperty.getType().getName().equals("ImageAsset") || currentProperty.getType().getName().equals("FileAsset")) continue;
                    if (value instanceof DataObject) {
                        BigDecimal id = (BigDecimal)((DataObject)value).get("id");
                        data.put((Object)currentProperty.getName(), (Object)id);
                        continue;
                    }
                    if (value == null) continue;
                    data.put((Object)currentProperty.getName(), value);
                }
            }
        }

        @Override
        public void process(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            FormData data = e.getFormData();
            ContentPage item = PageEditDynamic.this.m_isPrimaryStep ? super.processBasicWidgets(e) : (ContentPage)this.getItemSelectionModel().getSelectedObject(state);
            DynamicObjectType dot = new DynamicObjectType(PageEditDynamic.this.m_originatingType.getAssociatedObjectType());
            if (item != null) {
                Iterator declaredProperties = dot.getObjectType().getDeclaredProperties();
                Property currentProperty = null;
                Object value = null;
                while (declaredProperties.hasNext()) {
                    String fileName;
                    String currentPropertyName;
                    currentProperty = (Property)declaredProperties.next();
                    value = data.get((Object)currentProperty.getName());
                    if (value == null) continue;
                    if (currentProperty.isAttribute()) {
                        item.set(currentProperty.getName(), value);
                        continue;
                    }
                    if (currentProperty.getType().getName().equals("TextAsset")) {
                        TextAsset thisAsset = null;
                        DataObject assetDO = (DataObject)item.get(currentProperty.getName());
                        if (assetDO != null) {
                            thisAsset = new TextAsset(assetDO);
                        }
                        if (thisAsset == null) {
                            thisAsset = new TextAsset();
                            thisAsset.setName(item.getName() + "_text_" + thisAsset.getID());
                            thisAsset.setParent((ACSObject)item);
                            thisAsset.setText((String)value);
                            thisAsset.save();
                            DataObject thisDataObj = SessionManager.getSession().retrieve(thisAsset.getOID());
                            item.set(currentProperty.getName(), thisDataObj);
                            continue;
                        }
                        thisAsset.setText((String)value);
                        thisAsset.save();
                        continue;
                    }
                    if (currentProperty.getType().getName().equals("ImageAsset")) {
                        currentPropertyName = currentProperty.getName();
                        String imageAction = (String)data.get((Object)(currentPropertyName + "." + "action"));
                        fileName = (String)data.get((Object)(currentPropertyName + "." + "file_upload"));
                        if (imageAction.equals("upload")) {
                            File file = null;
                            if (fileName == null || fileName.length() <= 0) continue;
                            file = ((MultipartHttpServletRequest)state.getRequest()).getFile(currentPropertyName + "." + "file_upload");
                            ImageAsset a = new ImageAsset();
                            try {
                                a.loadFromFile(fileName, file, "image/jpeg");
                            }
                            catch (IOException ex) {
                                s_log.error((Object)"Error processing form", (Throwable)ex);
                                throw new FormProcessException((Throwable)ex);
                            }
                            a.save();
                            DataObject thisDataObj = SessionManager.getSession().retrieve(a.getOID());
                            item.set(currentPropertyName, thisDataObj);
                            continue;
                        }
                        if (imageAction.equals("delete")) {
                            item.set(currentPropertyName, null);
                            continue;
                        }
                        if (!imageAction.equals("none")) continue;
                    }
                    if (currentProperty.getType().getName().equals("FileAsset")) {
                        currentPropertyName = currentProperty.getName();
                        String fileAction = (String)data.get((Object)(currentPropertyName + "." + "action"));
                        fileName = (String)data.get((Object)(currentPropertyName + "." + "file_upload"));
                        String mimeType = (String)data.get((Object)(currentPropertyName + "." + "mime_type"));
                        if (fileAction.equals("upload")) {
                            File file = null;
                            if (fileName == null || fileName.length() <= 0) continue;
                            file = ((MultipartHttpServletRequest)state.getRequest()).getFile(currentPropertyName + "." + "file_upload");
                            FileAsset a = new FileAsset();
                            try {
                                a.loadFromFile(fileName, file, "-guess-".equals(mimeType) ? (String)null : mimeType);
                            }
                            catch (IOException ex) {
                                s_log.error((Object)"Error processing form", (Throwable)ex);
                                throw new FormProcessException((Throwable)ex);
                            }
                            a.save();
                            DataObject thisDataObj = SessionManager.getSession().retrieve(a.getOID());
                            item.set(currentPropertyName, thisDataObj);
                            continue;
                        }
                        if (fileAction.equals("delete")) {
                            item.set(currentPropertyName, null);
                            continue;
                        }
                        if (!fileAction.equals("none")) continue;
                    }
                    String typeName = currentProperty.getType().getQualifiedName();
                    try {
                        ContentType assocType = ContentType.findByAssociatedObjectType(typeName);
                        if (value == null || value.equals("")) {
                            item.set(currentProperty.getName(), null);
                            continue;
                        }
                        DataObject thisObj = SessionManager.getSession().retrieve(new OID(typeName, (Object)((BigDecimal)value)));
                        item.set(currentProperty.getName(), thisObj);
                    }
                    catch (DataObjectNotFoundException ex) {}
                }
                item.save();
            }
        }

        @Override
        public void validate(FormSectionEvent event) throws FormProcessException {
            String oldName;
            String newName;
            super.validate(event);
            PageState state = event.getPageState();
            FormData data = event.getFormData();
            ContentItem item = (ContentItem)this.getItemSelectionModel().getSelectedObject(state);
            Assert.exists((Object)item);
            if (PageEditDynamic.this.m_isPrimaryStep && !(newName = (String)data.get((Object)"name")).equalsIgnoreCase(oldName = item.getName())) {
                this.validateNameUniqueness((Folder)item.getParent(), event);
            }
        }
    }
}

