/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.authoring;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Resettable;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.cms.AuthoringKit;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.ui.authoring.AuthoringKitSelector;
import com.arsdigita.cms.ui.authoring.AuthoringKitWizard;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;

public class WizardSelector
extends AuthoringKitSelector
implements Resettable {
    private ItemSelectionModel m_itemSel;

    public WizardSelector(ItemSelectionModel model, SingleSelectionModel typeModel) {
        super(typeModel);
        this.m_itemSel = model;
        super.processKit();
    }

    @Override
    public Component instantiateKitComponent(AuthoringKit kit, ContentType type) {
        ItemSelectionModel itemModel = new ItemSelectionModel(type, (BigDecimalParameter)this.m_itemSel.getStateParameter());
        AuthoringKitWizard w = new AuthoringKitWizard(type, itemModel);
        return w;
    }

    public ItemSelectionModel getSelectionModel() {
        return this.m_itemSel;
    }

    private Component getCurrentWizard(PageState state) {
        BigDecimal typeId;
        if (!this.m_itemSel.isSelected(state)) {
            throw new RuntimeException((String)GlobalizationUtil.globalize("cms.ui.authoring.missing_item_id").localize());
        }
        ContentItem item = (ContentItem)this.m_itemSel.getSelectedObject(state);
        ContentType type = item.getContentType();
        if (type == null) {
            typeId = (BigDecimal)this.getComponentSelectionModel().getSelectedKey(state);
            if (typeId == null) {
                throw new RuntimeException((String)GlobalizationUtil.globalize("cms.ui.authoring.missing_content_type").localize());
            }
        } else {
            typeId = type.getID();
        }
        return this.getComponent(typeId);
    }

    @Override
    public void generateXML(PageState state, Element parent) {
        Component c = this.getCurrentWizard(state);
        if (c == null) {
            throw new RuntimeException((String)GlobalizationUtil.globalize("cms.ui.authoring.no_current_wizard").localize());
        }
        c.generateXML(state, parent);
    }

    public void reset(PageState state) {
        Resettable r = (Resettable)this.getCurrentWizard(state);
        if (r != null) {
            r.reset(state);
        }
    }
}

