/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.authoringkit;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.cms.AuthoringKit;
import com.arsdigita.cms.AuthoringStep;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ui.type.ContentTypeRequestLocal;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;

public class DeleteStep
extends Form
implements FormProcessListener,
FormSubmissionListener {
    private final SingleSelectionModel m_steps;
    protected final ContentTypeRequestLocal m_type;
    private Submit m_deleteWidget;
    private Submit m_cancelWidget;

    public DeleteStep(SingleSelectionModel m, ContentTypeRequestLocal type) {
        super("PhaseDefinitionDelete");
        this.m_steps = m;
        this.m_type = type;
        Label confirmation = new Label(GlobalizationUtil.globalize("cms.ui.authoringkit.do_you_really_want_to_delete_this_authoring_step"));
        this.add((Component)confirmation, 64);
        BoxPanel buttons = new BoxPanel(1);
        this.m_deleteWidget = new Submit("delete");
        this.m_deleteWidget.setButtonLabel("Delete");
        buttons.add((Component)this.m_deleteWidget);
        this.m_cancelWidget = new Submit("cancel");
        this.m_cancelWidget.setButtonLabel("Cancel");
        buttons.add((Component)this.m_cancelWidget);
        this.add((Component)buttons, 66);
        this.addProcessListener(this);
        this.addSubmissionListener(this);
    }

    boolean isCancelled(PageState s) {
        return this.m_cancelWidget.isSelected(s);
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        FormData data = e.getFormData();
        try {
            AuthoringKit kit = this.getKit(state);
            AuthoringStep step = this.getStep(state);
            kit.removeStep(step);
            step.delete();
        }
        catch (DataObjectNotFoundException ex) {
            // empty catch block
        }
    }

    public void submitted(FormSectionEvent e) throws FormProcessException {
        if (this.m_cancelWidget.isSelected(e.getPageState())) {
            throw new FormProcessException((String)GlobalizationUtil.globalize("cms.ui.authoringkit.submission_cancelled").localize());
        }
    }

    protected AuthoringStep getStep(PageState state) {
        String step_key = (String)this.m_steps.getSelectedKey(state);
        BigDecimal stepID = new BigDecimal(step_key);
        try {
            return new AuthoringStep(stepID);
        }
        catch (DataObjectNotFoundException ex) {
            throw new UncheckedWrapperException("Authoring Step ID#" + step_key + " not found", (Throwable)ex);
        }
    }

    protected AuthoringKit getKit(PageState state) {
        ContentType type = this.m_type.getContentType(state);
        try {
            return type.getAuthoringKit();
        }
        catch (DataObjectNotFoundException ex) {
            throw new UncheckedWrapperException("Authoring kit not found", (Throwable)ex);
        }
    }
}

