/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.authoringkit;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.cms.AuthoringKit;
import com.arsdigita.cms.AuthoringStep;
import com.arsdigita.cms.AuthoringStepCollection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ui.CMSContainer;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;

public class KitInfo
extends CMSContainer {
    private final SingleSelectionModel m_types;
    private final Table m_stepTable;
    private final RequestLocal m_authoringKit;

    public KitInfo(SingleSelectionModel m) {
        this.m_types = m;
        this.m_authoringKit = new RequestLocal();
        this.m_stepTable = this.makeStepTable();
        this.m_stepTable.setClassAttr("authoringStepsTable");
        this.add((Component)this.m_stepTable);
    }

    public Table getStepTable() {
        return this.m_stepTable;
    }

    private void initializeAuthoringKit(PageState state) {
        Assert.isTrue((boolean)this.m_types.isSelected(state));
        BigDecimal typeId = new BigDecimal(this.m_types.getSelectedKey(state).toString());
        ContentType type = new ContentType(typeId);
        AuthoringKit kit = type.getAuthoringKit();
        this.m_authoringKit.set(state, (Object)kit);
    }

    public void generateXML(PageState state, Element parent) {
        if (this.isVisible(state)) {
            Element element = parent.newChildElement("cms:foo", "http://www.arsdigita.com/cms/1.0");
            this.exportAttributes(element);
            this.initializeAuthoringKit(state);
            AuthoringKit kit = (AuthoringKit)((Object)this.m_authoringKit.get(state));
            if (kit != null) {
                element.addAttribute("createComponentName", kit.getCreateComponent());
                this.m_stepTable.generateXML(state, element);
            } else {
                element.addAttribute("createComponentName", "n/a - This is not a creatable Content Type");
            }
        }
    }

    private Table makeStepTable() {
        Object[] headers = new String[]{"#", "Label", "Description", "Component"};
        TableModelBuilder b = new TableModelBuilder((String[])headers){
            private boolean m_locked;
            final /* synthetic */ String[] val$headers;
            {
                this.val$headers = stringArray;
            }

            public TableModel makeModel(Table t, final PageState s) {
                Assert.isTrue((boolean)KitInfo.this.m_types.isSelected(s));
                return new TableModel(){
                    AuthoringKit m_kit = this.getKit();
                    AuthoringStepCollection m_steps = null;
                    AuthoringStep m_currentStep = null;

                    private AuthoringKit getKit() {
                        KitInfo.this.initializeAuthoringKit(s);
                        return (AuthoringKit)((Object)KitInfo.this.m_authoringKit.get(s));
                    }

                    public int getColumnCount() {
                        return val$headers.length;
                    }

                    public boolean nextRow() {
                        boolean next;
                        if (this.m_steps == null) {
                            this.m_steps = this.m_kit.getSteps();
                            if (this.m_steps == null) {
                                return false;
                            }
                        }
                        if (next = this.m_steps.next()) {
                            this.m_currentStep = this.m_steps.getAuthoringStep();
                        }
                        return next;
                    }

                    public Object getElementAt(int columnIndex) {
                        if (this.m_currentStep == null) {
                            throw new IllegalArgumentException("Current row does not exists");
                        }
                        switch (columnIndex) {
                            case 0: {
                                if (this.m_kit != null) {
                                    return this.m_kit.getOrdering(this.m_currentStep);
                                }
                                return "";
                            }
                            case 1: {
                                return this.m_currentStep.getLabel();
                            }
                            case 2: {
                                return this.m_currentStep.getDescription();
                            }
                            case 3: {
                                return this.m_currentStep.getComponent();
                            }
                        }
                        throw new IllegalArgumentException("columnIndex exceeds the number of columns available");
                    }

                    public Object getKeyAt(int columnIndex) {
                        if (this.m_currentStep == null) {
                            throw new IllegalArgumentException("Current row does not exists");
                        }
                        return this.m_currentStep.getID();
                    }
                };
            }

            public void lock() {
                this.m_locked = true;
            }

            public boolean isLocked() {
                return this.m_locked;
            }
        };
        return new Table(b, headers);
    }
}

