/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.category;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.parameters.GlobalizedParameterListener;
import com.arsdigita.bebop.parameters.ParameterData;
import com.arsdigita.categorization.Category;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ui.BaseForm;
import com.arsdigita.cms.ui.category.CategoryUseContextModelBuilder;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.permissions.ObjectPermissionCollection;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.persistence.OID;
import org.apache.log4j.Logger;

class AddUseContextForm
extends BaseForm {
    private static final Logger s_log = Logger.getLogger(AddUseContextForm.class);
    private final SingleSelectionModel m_model;
    private final BaseForm.Name m_useContext;
    private final BaseForm.Name m_rootName;
    private final BaseForm.Description m_rootDescription;

    AddUseContextForm(SingleSelectionModel model) {
        super("useContext", AddUseContextForm.gz("cms.ui.category.add_use_context"));
        this.m_model = model;
        this.m_useContext = new BaseForm.Name("useContext", 200, true);
        this.addField(AddUseContextForm.gz("cms.ui.category.use_context"), (Component)this.m_useContext);
        this.m_rootName = new BaseForm.Name("rootName", 200, true);
        this.addField(AddUseContextForm.gz("cms.ui.name"), (Component)this.m_rootName);
        this.m_rootDescription = new BaseForm.Description("rootName", 200, true);
        this.addField(AddUseContextForm.gz("cms.ui.description"), (Component)this.m_rootDescription);
        this.addAction(new BaseForm.Finish());
        this.addAction(new BaseForm.Cancel());
        this.addSecurityListener("category_admin");
        this.m_useContext.addValidationListener((ParameterListener)new ValidationListener());
        this.addProcessListener(new ProcessListener());
    }

    private class ProcessListener
    implements FormProcessListener {
        private ProcessListener() {
        }

        public final void process(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            String useContext = (String)AddUseContextForm.this.m_useContext.getValue(state);
            String rootName = (String)AddUseContextForm.this.m_rootName.getValue(state);
            String rootDescription = (String)AddUseContextForm.this.m_rootDescription.getValue(state);
            Category root = new Category();
            root.setName(rootName);
            root.setDescription(rootDescription);
            root.setAbstract(true);
            ContentSection section = CMS.getContext().getContentSection();
            Category.setRootForObject((ACSObject)section, (Category)root, (String)useContext);
            PermissionService.setContext((ACSObject)root, (ACSObject)section);
            Category defaultRoot = Category.getRootForObject((ACSObject)section);
            if (defaultRoot != null) {
                ObjectPermissionCollection coll = PermissionService.getDirectGrantedPermissions((OID)defaultRoot.getOID());
                while (coll.next()) {
                    PermissionService.grantPermission((PermissionDescriptor)new PermissionDescriptor(coll.getPrivilege(), root.getOID(), coll.getGranteeOID()));
                }
            }
            AddUseContextForm.this.m_model.setSelectedKey(state, (Object)(useContext == null ? CategoryUseContextModelBuilder.DEFAULT_USE_CONTEXT : useContext));
        }
    }

    private class ValidationListener
    extends GlobalizedParameterListener {
        public ValidationListener() {
            this.setError(GlobalizationUtil.globalize("cms.ui.category.use_context_must_be_unique"));
        }

        public final void validate(ParameterEvent e) throws FormProcessException {
            ParameterData data = e.getParameterData();
            String name = (String)AddUseContextForm.this.m_useContext.getValue(e.getPageState());
            if (Category.getRootForObject((ACSObject)CMS.getContext().getContentSection(), (String)name) != null) {
                data.addError(this.getError());
            }
        }
    }
}

