/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.category;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.BaseLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.categorization.CategorizedCollection;
import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.CategoryCollection;
import com.arsdigita.categorization.CategoryNotFoundException;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.dispatcher.AccessDeniedException;
import com.arsdigita.cms.ui.BaseItemPane;
import com.arsdigita.cms.ui.CMSForm;
import com.arsdigita.cms.ui.ContentItemPage;
import com.arsdigita.cms.ui.VisibilityComponent;
import com.arsdigita.cms.ui.category.CategorizedObjectsList;
import com.arsdigita.cms.ui.category.CategoryLinks;
import com.arsdigita.cms.ui.category.CategoryLocalizationAddForm;
import com.arsdigita.cms.ui.category.CategoryLocalizationEditForm;
import com.arsdigita.cms.ui.category.CategoryLocalizationTable;
import com.arsdigita.cms.ui.category.CategoryRequestLocal;
import com.arsdigita.cms.ui.category.IndexItemSelectionForm;
import com.arsdigita.cms.ui.category.LinkForm;
import com.arsdigita.cms.ui.category.SubcategoryList;
import com.arsdigita.cms.ui.permissions.CMSPermissionsPane;
import com.arsdigita.cms.ui.templates.CategoryTemplates;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.ObjectPermissionCollection;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.toolbox.ui.ActionGroup;
import com.arsdigita.toolbox.ui.ModalPanel;
import com.arsdigita.toolbox.ui.PropertyList;
import com.arsdigita.toolbox.ui.Section;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Web;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

class CategoryItemPane
extends BaseItemPane {
    private static final Logger s_log = Logger.getLogger(CategoryItemPane.class);
    private final SingleSelectionModel m_model;
    private final CategoryRequestLocal m_category;
    private final SimpleContainer m_detailPane;

    public CategoryItemPane(SingleSelectionModel model, CategoryRequestLocal category, ActionLink addLink, ActionLink editLink, ActionLink deleteLink) {
        this.m_model = model;
        this.m_category = category;
        this.m_detailPane = new SimpleContainer();
        this.add((Component)this.m_detailPane);
        this.setDefault((Component)this.m_detailPane);
        ActionLink orderItemsLink = new ActionLink((Component)new Label(CategoryItemPane.gz("cms.ui.category.categorized_objects"))){

            public boolean isVisible(PageState state) {
                if (!super.isVisible(state)) {
                    return false;
                }
                CategorizedCollection items = CategoryItemPane.this.m_category.getCategory(state).getObjects("com.arsdigita.cms.ContentItem");
                items.addEqualsFilter("version", (Object)"live");
                boolean canOrder = items.size() > 1L;
                items.close();
                return canOrder;
            }
        };
        OrderItemsForm orderItemsForm = new OrderItemsForm(this.m_category);
        OrderItemsForm orderItemsForm2 = new OrderItemsForm(this.m_category);
        this.add((Component)orderItemsForm);
        this.add((Component)orderItemsForm2);
        ActionLink indexLink = new ActionLink((Component)new Label(CategoryItemPane.gz("cms.ui.category.change_index_item")));
        IndexItemSelectionForm indexForm = new IndexItemSelectionForm(this.m_category);
        this.add((Component)indexForm);
        ViewItemLink viewIndexLink = new ViewItemLink((Component)new Label(CategoryItemPane.gz("cms.ui.category.view_index_item")), "");
        EditItemLink editIndexLink = new EditItemLink((Component)new Label(CategoryItemPane.gz("cms.ui.category.edit_index_item")), "");
        this.m_detailPane.add((Component)new SummarySection(editLink, deleteLink, indexLink, (BaseLink)viewIndexLink, (BaseLink)editIndexLink, orderItemsLink));
        ActionLink addCategoryLocalizationLink = new ActionLink((Component)new Label(CategoryItemPane.gz("cms.ui.category.localization_add"))){

            public boolean isVisible(PageState state) {
                int countSupportedLanguages = Kernel.getConfig().getSupportedLanguagesTokenizer().countTokens();
                long countLanguages = CategoryItemPane.this.m_category.getCategory(state).getCategoryLocalizationCollection().size();
                return CategoryItemPane.this.m_category.getCategory(state).canEdit() && countLanguages < (long)countSupportedLanguages;
            }
        };
        CategoryLocalizationAddForm addCategoryLocalizationForm = new CategoryLocalizationAddForm(this.m_category);
        this.m_detailPane.add((Component)new CategoryLocalizationSection(addCategoryLocalizationLink));
        this.add((Component)addCategoryLocalizationForm);
        this.connect(addCategoryLocalizationLink, (FormSection)addCategoryLocalizationForm);
        this.connect((FormSection)addCategoryLocalizationForm);
        this.m_detailPane.add((Component)new SubcategorySection(addLink));
        ActionLink linkAddLink = new ActionLink((Component)new Label(CategoryItemPane.gz("cms.ui.category.linked_add")));
        LinkForm linkForm = new LinkForm(this.m_category);
        this.add((Component)linkForm);
        linkAddLink.addActionListener((ActionListener)new ModalPanel.NavigationListener((ModalPanel)this, (Component)linkForm));
        linkForm.addSubmissionListener((FormSubmissionListener)new ModalPanel.CancelListener((ModalPanel)this, (FormSection)linkForm));
        this.m_detailPane.add((Component)new LinkedCategorySection(linkAddLink));
        this.m_detailPane.add((Component)new AdminVisible((Component)new CategoryTemplateSection()));
        this.m_detailPane.add((Component)new PermissionsSection());
        this.connect(indexLink, (FormSection)indexForm);
        this.connect((FormSection)indexForm);
        this.connect(orderItemsLink, (FormSection)orderItemsForm);
        this.connect((FormSection)orderItemsForm);
    }

    private Category findParentCategoryWithNonInheritedIndexItem(Category c) {
        if (c.getParentCategoryCount() == 0L) {
            return null;
        }
        CategoryCollection parents = c.getParents();
        while (parents.next()) {
            Category p = parents.getCategory();
            if (p.getDirectIndexObject() != null || p.ignoreParentIndexItem()) {
                return p;
            }
            Category gp = this.findParentCategoryWithNonInheritedIndexItem(p);
            if (gp == null) continue;
            return gp;
        }
        return null;
    }

    private class EditItemLink
    extends Link {
        EditItemLink(Component c, String s) {
            super(c, s);
        }

        protected String prepareURL(PageState state, String location) {
            boolean canEdit = false;
            ContentItem indexItem = ((ContentBundle)CategoryItemPane.this.m_category.getCategory(state).getDirectIndexObject()).getPrimaryInstance();
            if (indexItem == null) {
                return "";
            }
            if (!this.isItemEditable(indexItem, state)) {
                return "";
            }
            BigDecimal draftID = indexItem.getDraftVersion().getID();
            return "item.jsp?item_id=" + draftID + "&set_tab=" + ContentItemPage.AUTHORING_TAB;
        }

        public boolean isVisible(PageState state) {
            if (!super.isVisible(state)) {
                return false;
            }
            ACSObject indexItem = CategoryItemPane.this.m_category.getCategory(state).getDirectIndexObject();
            if (indexItem == null) {
                return false;
            }
            return this.isItemEditable((ContentItem)indexItem, state);
        }

        private boolean isItemEditable(ContentItem item, PageState state) {
            BigDecimal id = item.getID();
            User user = Web.getContext().getUser();
            ContentItem ci = new ContentItem(new OID(ContentItem.class.getName(), Integer.parseInt(id.toString())));
            Iterator permissions = PermissionService.getImpliedPrivileges((OID)ci.getOID(), (OID)user.getOID());
            while (permissions.hasNext()) {
                PrivilegeDescriptor permission = (PrivilegeDescriptor)permissions.next();
                if (!permission.equals((Object)PrivilegeDescriptor.ADMIN) && !permission.equals((Object)PrivilegeDescriptor.EDIT)) continue;
                return true;
            }
            return false;
        }
    }

    private class ViewItemLink
    extends Link {
        ViewItemLink(Component c, String s) {
            super(c, s);
        }

        protected String prepareURL(PageState state, String location) {
            ContentItem indexItem = ((ContentBundle)CategoryItemPane.this.m_category.getCategory(state).getDirectIndexObject()).getPrimaryInstance();
            if (indexItem == null) {
                return "";
            }
            return "/redirect/?oid=" + URLEncoder.encode(indexItem.getOID().toString());
        }

        public boolean isVisible(PageState state) {
            if (!super.isVisible(state)) {
                return false;
            }
            ACSObject indexItem = CategoryItemPane.this.m_category.getCategory(state).getDirectIndexObject();
            return indexItem != null;
        }
    }

    private static class OrderItemsForm
    extends CMSForm {
        public OrderItemsForm(CategoryRequestLocal category) {
            super("orderItems", (Container)new SimpleContainer());
            Label header = new Label(CategoryItemPane.gz("cms.ui.category.categorized_objects"));
            header.setFontWeight("b");
            this.add((Component)header);
            this.add((Component)new CategorizedObjectsList(category));
            this.add((Component)new Submit("Done"));
        }
    }

    private class PermissionsSection
    extends Section {
        public boolean isVisible(PageState ps) {
            Category cat = CategoryItemPane.this.m_category.getCategory(ps);
            return !cat.isRoot() && cat.canAdmin();
        }

        PermissionsSection() {
            this.setHeading((Component)new Label(CategoryItemPane.gz("cms.ui.permissions")));
            ActionGroup group = new ActionGroup();
            this.setBody((Component)group);
            PrivilegeDescriptor[] privs = new PrivilegeDescriptor[]{PrivilegeDescriptor.EDIT, Category.MAP_DESCRIPTOR, PrivilegeDescriptor.DELETE, PrivilegeDescriptor.ADMIN};
            HashMap<String, String> privMap = new HashMap<String, String>();
            privMap.put("edit", "Edit");
            privMap.put("delete", "Delete");
            privMap.put(Category.MAP_DESCRIPTOR.getName(), "Categorize Items");
            privMap.put("admin", "Admin");
            final CMSPermissionsPane permPane = new CMSPermissionsPane(privs, privMap, new ACSObjectSelectionModel(CategoryItemPane.this.m_model)){

                @Override
                public void showAdmin(PageState ps) {
                    Assert.exists((Object)CategoryItemPane.this.m_model.getSelectedKey(ps));
                    super.showAdmin(ps);
                    this.getAdminListingPanel().setVisible(ps, false);
                }
            };
            ActionLink restoreDefault = new ActionLink((Component)new Label(CategoryItemPane.gz("cms.ui.restore_default_permissions"))){

                public boolean isVisible(PageState ps) {
                    Category cat = CategoryItemPane.this.m_category.getCategory(ps);
                    return PermissionService.getContext((ACSObject)cat) == null;
                }
            };
            ActionLink useCustom = new ActionLink((Component)new Label(CategoryItemPane.gz("cms.ui.use_custom_permissions"))){

                public boolean isVisible(PageState ps) {
                    Category cat = CategoryItemPane.this.m_category.getCategory(ps);
                    return PermissionService.getContext((ACSObject)cat) != null;
                }
            };
            ActionListener al = new ActionListener(){

                public void actionPerformed(ActionEvent event) {
                    PageState state = event.getPageState();
                    Category cat = CategoryItemPane.this.m_category.getCategory(state);
                    if (!cat.canAdmin()) {
                        throw new AccessDeniedException();
                    }
                    DataObject context = PermissionService.getContext((ACSObject)cat);
                    if (context != null) {
                        PermissionService.clonePermissions((ACSObject)cat);
                    } else {
                        Category parent;
                        try {
                            parent = cat.getDefaultParentCategory();
                        }
                        catch (CategoryNotFoundException ce) {
                            throw new IllegalStateException("link shouldn't exist for root categories");
                        }
                        PermissionService.setContext((ACSObject)cat, (ACSObject)parent);
                        ObjectPermissionCollection perms = PermissionService.getDirectGrantedPermissions((OID)cat.getOID());
                        while (perms.next()) {
                            PermissionService.revokePermission((PermissionDescriptor)new PermissionDescriptor(perms.getPrivilege(), cat.getOID(), perms.getGranteeOID()));
                        }
                    }
                    permPane.reset(state);
                }
            };
            restoreDefault.addActionListener(al);
            useCustom.addActionListener(al);
            SimpleContainer links = new SimpleContainer();
            links.add((Component)restoreDefault);
            links.add((Component)useCustom);
            group.setSubject((Component)permPane);
            group.addAction((Component)links);
            CategoryItemPane.this.m_model.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    PageState ps = e.getPageState();
                }
            });
        }
    }

    private class CategoryTemplateSection
    extends Section {
        CategoryTemplateSection() {
            this.setHeading((Component)new Label(CategoryItemPane.gz("cms.ui.category.templates")));
            ActionGroup group = new ActionGroup();
            this.setBody((Component)group);
            group.setSubject((Component)new CategoryTemplates(CategoryItemPane.this.m_category));
        }
    }

    private class LinkedCategorySection
    extends Section {
        LinkedCategorySection(ActionLink linkAddLink) {
            this.setHeading((Component)new Label(CategoryItemPane.gz("cms.ui.category.linked")));
            ActionGroup group = new ActionGroup();
            this.setBody((Component)group);
            group.setSubject((Component)new CategoryLinks(CategoryItemPane.this.m_category, CategoryItemPane.this.m_model));
            group.addAction((Component)new EditVisible((Component)linkAddLink), "edit");
        }

        public final boolean isVisible(PageState state) {
            return !CategoryItemPane.this.m_category.getCategory(state).isRoot();
        }
    }

    private class SubcategorySection
    extends Section {
        SubcategorySection(ActionLink addLink) {
            this.setHeading((Component)new Label(CategoryItemPane.gz("cms.ui.category.subcategories")));
            ActionGroup group = new ActionGroup();
            this.setBody((Component)group);
            group.setSubject((Component)new SubcategoryList(CategoryItemPane.this.m_category, CategoryItemPane.this.m_model));
            group.addAction((Component)new AdminVisible((Component)addLink), "add");
        }
    }

    private class CategoryLocalizationSection
    extends Section {
        private CategoryLocalizationTable m_catLocalizationTable;
        private CategoryLocalizationEditForm m_editCategoryLocalizationForm;
        private StringParameter m_catLocaleParam;
        private ParameterSingleSelectionModel m_catLocale;

        CategoryLocalizationSection(ActionLink addLink) {
            this.setHeading((Component)new Label(CategoryItemPane.gz("cms.ui.category.localizations")));
            this.m_catLocaleParam = new StringParameter("catLocale");
            this.m_catLocale = new ParameterSingleSelectionModel((ParameterModel)this.m_catLocaleParam);
            ActionGroup group = new ActionGroup();
            this.setBody((Component)group);
            this.m_catLocalizationTable = new CategoryLocalizationTable(CategoryItemPane.this.m_category, CategoryItemPane.this.m_model, (SingleSelectionModel)this.m_catLocale);
            group.setSubject((Component)this.m_catLocalizationTable);
            group.addAction((Component)new AdminVisible((Component)addLink), "add");
            this.m_editCategoryLocalizationForm = new CategoryLocalizationEditForm(CategoryItemPane.this.m_category, (SingleSelectionModel)this.m_catLocale);
            CategoryItemPane.this.add((Component)this.m_editCategoryLocalizationForm);
            CategoryItemPane.this.connect((FormSection)this.m_editCategoryLocalizationForm);
            CategoryItemPane.this.connect(this.m_catLocalizationTable, 0, (FormSection)this.m_editCategoryLocalizationForm);
        }

        public void register(Page page) {
            super.register(page);
            page.addComponentStateParam((Component)this.m_editCategoryLocalizationForm, (ParameterModel)this.m_catLocaleParam);
        }
    }

    private class SummarySection
    extends Section {
        SummarySection(ActionLink editLink, ActionLink deleteLink, ActionLink indexLink, ActionLink orderItemsLink) {
            this.setHeading((Component)new Label(CategoryItemPane.gz("cms.ui.category.details")));
            ActionGroup group = new ActionGroup();
            this.setBody((Component)group);
            group.setSubject((Component)new Properties());
            group.addAction((Component)new EditVisible((Component)editLink), "edit");
            group.addAction((Component)new EditVisible((Component)orderItemsLink));
            group.addAction((Component)new EditVisible((Component)indexLink));
            group.addAction((Component)new AdminVisible((Component)deleteLink), "delete");
        }

        SummarySection(ActionLink editLink, ActionLink deleteLink, ActionLink indexLink, BaseLink viewIndexItem, BaseLink editIndexItem, ActionLink orderItemsLink) {
            this.setHeading((Component)new Label(CategoryItemPane.gz("cms.ui.category.details")));
            ActionGroup group = new ActionGroup();
            this.setBody((Component)group);
            group.setSubject((Component)new Properties());
            group.addAction((Component)new EditVisible((Component)editLink), "edit");
            group.addAction((Component)new EditVisible((Component)orderItemsLink));
            group.addAction((Component)new EditVisible((Component)indexLink));
            group.addAction((Component)new EditVisible((Component)viewIndexItem));
            group.addAction((Component)new EditVisible((Component)editIndexItem));
            group.addAction((Component)new AdminVisible((Component)deleteLink), "delete");
        }

        private class Properties
        extends PropertyList {
            private Properties() {
            }

            protected final List properties(PageState state) {
                Category ancestor;
                List props = super.properties(state);
                Category category = CategoryItemPane.this.m_category.getCategory(state);
                ACSObject item = category.getDirectIndexObject();
                String itemTitle = "None";
                if (item != null) {
                    itemTitle = item.getDisplayName();
                } else if (!category.ignoreParentIndexItem() && category.getParentCategoryCount() > 0L && (ancestor = CategoryItemPane.this.findParentCategoryWithNonInheritedIndexItem(category)) != null) {
                    if (ancestor.getIndexObject() != null) {
                        itemTitle = ancestor.getIndexObject().getDisplayName();
                    }
                    itemTitle = itemTitle + " (Inherited from " + ancestor.getDisplayName() + ")";
                }
                props.add(new PropertyList.Property(CategoryItemPane.gz("cms.ui.name"), category.getName("")));
                props.add(new PropertyList.Property(CategoryItemPane.gz("cms.ui.description"), category.getDescription("")));
                props.add(new PropertyList.Property(CategoryItemPane.gz("cms.ui.category.url"), category.getURL("")));
                props.add(new PropertyList.Property(CategoryItemPane.gz("cms.ui.category.is_not_abstract"), category.isAbstract() ? CategoryItemPane.gz("cms.ui.no") : CategoryItemPane.gz("cms.ui.yes")));
                props.add(new PropertyList.Property(CategoryItemPane.gz("cms.ui.category.is_enabled"), category.isEnabled("") ? CategoryItemPane.gz("cms.ui.yes") : CategoryItemPane.gz("cms.ui.no")));
                props.add(new PropertyList.Property(CategoryItemPane.gz("cms.ui.category.index_item"), itemTitle));
                return props;
            }
        }
    }

    private class AdminVisible
    extends VisibilityComponent {
        AdminVisible(Component child) {
            super(child, null);
        }

        @Override
        public boolean hasPermission(PageState ps) {
            return CategoryItemPane.this.m_category.getCategory(ps).canAdmin();
        }
    }

    private class EditVisible
    extends VisibilityComponent {
        EditVisible(Component child) {
            super(child, null);
        }

        @Override
        public boolean hasPermission(PageState ps) {
            return CategoryItemPane.this.m_category.getCategory(ps).canEdit();
        }
    }
}

