/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.category;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.categorization.Category;
import com.arsdigita.cms.ui.category.CategoryAddForm;
import com.arsdigita.cms.ui.category.CategoryLocalizationForm;
import com.arsdigita.cms.ui.category.CategoryRequestLocal;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.dispatcher.AccessDeniedException;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelConfig;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class CategoryLocalizationAddForm
extends CategoryLocalizationForm {
    private static final Logger s_log = Logger.getLogger(CategoryAddForm.class);

    public CategoryLocalizationAddForm(CategoryRequestLocal category) {
        super("AddCategoryLocalization", CategoryLocalizationAddForm.gz("cms.ui.category.localization_add"), category);
        this.addInitListener(new InitListener());
        this.addProcessListener(new ProcessListener());
    }

    private final class ProcessListener
    implements FormProcessListener {
        private ProcessListener() {
        }

        public final void process(FormSectionEvent e) throws FormProcessException {
            s_log.debug((Object)("Adding a categoryLocalization to category " + (Object)((Object)CategoryLocalizationAddForm.this.m_category)));
            PageState state = e.getPageState();
            Category category = CategoryLocalizationAddForm.this.m_category.getCategory(state);
            String locale = (String)CategoryLocalizationAddForm.this.m_locale.getValue(state);
            String name = (String)CategoryLocalizationAddForm.this.m_name.getValue(state);
            String description = (String)CategoryLocalizationAddForm.this.m_description.getValue(state);
            String url = (String)CategoryLocalizationAddForm.this.m_url.getValue(state);
            String isEnabled = (String)CategoryLocalizationAddForm.this.m_isEnabled.getValue(state);
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Adding localization for locale " + locale + " to category " + category));
            }
            if (!category.canEdit()) {
                throw new AccessDeniedException();
            }
            category.addLanguage(locale, name, description, url);
            category.setEnabled("yes".equals(isEnabled), locale);
            category.save();
        }
    }

    private class InitListener
    implements FormInitListener {
        private InitListener() {
        }

        public final void init(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            Category category = CategoryLocalizationAddForm.this.m_category.getCategory(state);
            CategoryLocalizationAddForm.this.m_locale.addOption(new Option("", (Component)new Label((String)GlobalizationUtil.globalize("cms.ui.select_one").localize())), state);
            KernelConfig kernelConfig = Kernel.getConfig();
            StringTokenizer strTok = kernelConfig.getSupportedLanguagesTokenizer();
            while (strTok.hasMoreTokens()) {
                String code = strTok.nextToken();
                if (category.getCategoryLocalizationCollection().localizationExists(code)) continue;
                CategoryLocalizationAddForm.this.m_locale.addOption(new Option(code, new Locale(code).getDisplayLanguage()), state);
            }
        }
    }
}

