/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.category;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.categorization.Category;
import com.arsdigita.cms.ui.category.CategoryLocalizationForm;
import com.arsdigita.cms.ui.category.CategoryRequestLocal;
import com.arsdigita.dispatcher.AccessDeniedException;
import java.util.Locale;
import org.apache.log4j.Logger;

public class CategoryLocalizationEditForm
extends CategoryLocalizationForm {
    private static final Logger s_log = Logger.getLogger(CategoryLocalizationEditForm.class);
    private final SingleSelectionModel m_catLocale;

    public CategoryLocalizationEditForm(CategoryRequestLocal category, SingleSelectionModel catLocale) {
        super("EditCategoryLocalization", CategoryLocalizationEditForm.gz("cms.ui.category.localization_edit"), category);
        this.m_catLocale = catLocale;
        this.addInitListener(new InitListener());
        this.addProcessListener(new ProcessListener());
    }

    private class ProcessListener
    implements FormProcessListener {
        private ProcessListener() {
        }

        public final void process(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            Category category = CategoryLocalizationEditForm.this.m_category.getCategory(state);
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Editing localization for locale " + CategoryLocalizationEditForm.this.m_locale + " for category " + category));
            }
            if (!category.canEdit()) {
                throw new AccessDeniedException();
            }
            category.setName((String)CategoryLocalizationEditForm.this.m_name.getValue(state), (String)CategoryLocalizationEditForm.this.m_locale.getValue(state));
            category.setDescription((String)CategoryLocalizationEditForm.this.m_description.getValue(state), (String)CategoryLocalizationEditForm.this.m_locale.getValue(state));
            category.setURL((String)CategoryLocalizationEditForm.this.m_url.getValue(state), (String)CategoryLocalizationEditForm.this.m_locale.getValue(state));
            category.setEnabled("yes".equals((String)CategoryLocalizationEditForm.this.m_isEnabled.getValue(state)), (String)CategoryLocalizationEditForm.this.m_locale.getValue(state));
            category.save();
        }
    }

    private class InitListener
    implements FormInitListener {
        private InitListener() {
        }

        public final void init(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            Category category = CategoryLocalizationEditForm.this.m_category.getCategory(state);
            String categoryLocalizationLocale = (String)CategoryLocalizationEditForm.this.m_catLocale.getSelectedKey(state);
            CategoryLocalizationEditForm.this.m_locale.addOption(new Option(categoryLocalizationLocale, new Locale(categoryLocalizationLocale).getDisplayLanguage()), state);
            CategoryLocalizationEditForm.this.m_locale.setValue(state, (Object)categoryLocalizationLocale);
            CategoryLocalizationEditForm.this.m_locale.lock();
            CategoryLocalizationEditForm.this.m_name.setValue(state, (Object)category.getName(categoryLocalizationLocale));
            CategoryLocalizationEditForm.this.m_description.setValue(state, (Object)category.getDescription(categoryLocalizationLocale));
            CategoryLocalizationEditForm.this.m_url.setValue(state, (Object)category.getURL(categoryLocalizationLocale));
            if (category.isEnabled(categoryLocalizationLocale)) {
                CategoryLocalizationEditForm.this.m_isEnabled.setValue(state, (Object)"yes");
            } else {
                CategoryLocalizationEditForm.this.m_isEnabled.setValue(state, (Object)"no");
            }
        }
    }
}

