/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.category;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.ParameterEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.RadioGroup;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.TextArea;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.form.Widget;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterData;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringInRangeValidationListener;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.bebop.parameters.TrimmedStringParameter;
import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.CategoryCollection;
import com.arsdigita.cms.ui.BaseForm;
import com.arsdigita.cms.ui.category.CategoryRequestLocal;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.xml.Element;

public class CategoryLocalizationForm
extends BaseForm {
    final CategoryRequestLocal m_category;
    final SingleSelect m_locale;
    final TextField m_name;
    final TextArea m_description;
    final TextField m_url;
    final RadioGroup m_isEnabled;
    private Label m_script = new Label("<script language=\"javascript\" src=\"/javascript/manipulate-input.js\"></script>", false);
    private static final String LOCALE = "locale";
    private static final String NAME = "name";
    private static final String DESCRIPTION = "description";
    private static final String URL = "url";
    private static final String IS_ENABLED = "isEnabled";

    public CategoryLocalizationForm(String key, GlobalizedMessage heading, CategoryRequestLocal category) {
        super(key, heading);
        this.m_category = category;
        StringParameter localeParam = new StringParameter(LOCALE);
        localeParam.addParameterListener((ParameterListener)new StringInRangeValidationListener(0, 2));
        this.m_locale = new SingleSelect((ParameterModel)localeParam);
        this.m_locale.addValidationListener(new ParameterListener(){

            public void validate(ParameterEvent e) throws FormProcessException {
                ParameterData data = e.getParameterData();
                String code = (String)data.getValue();
                if (code == null || code.length() == 0) {
                    data.addError((String)GlobalizationUtil.globalize("cms.ui.category.localization_error_locale").localize());
                }
            }
        });
        this.addField(CategoryLocalizationForm.gz("cms.ui.category.localization_locale"), (Component)this.m_locale);
        this.m_name = new TextField((ParameterModel)new TrimmedStringParameter(NAME));
        this.addField(CategoryLocalizationForm.gz("cms.ui.name"), (Component)this.m_name);
        this.m_name.setSize(30);
        this.m_name.setMaxLength(200);
        this.m_name.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.m_name.setOnFocus("if (this.form.url.value == '') {  defaulting = true; this.form.url.value = urlize(this.value); }");
        this.m_name.setOnKeyUp("if (defaulting) { this.form.url.value = urlize(this.value) }");
        this.m_isEnabled = new RadioGroup(IS_ENABLED);
        this.m_isEnabled.addOption(new Option("no", (Component)new Label(CategoryLocalizationForm.gz("cms.ui.no"))));
        this.m_isEnabled.addOption(new Option("yes", (Component)new Label(CategoryLocalizationForm.gz("cms.ui.yes"))));
        this.addField(CategoryLocalizationForm.gz("cms.ui.category.is_enabled"), (Component)this.m_isEnabled);
        this.m_description = new TextArea((ParameterModel)new TrimmedStringParameter(DESCRIPTION));
        this.addField(CategoryLocalizationForm.gz("cms.ui.description"), (Component)this.m_description);
        this.m_description.setWrap(2);
        this.m_description.setRows(5);
        this.m_description.setCols(40);
        this.m_url = new TextField((ParameterModel)new TrimmedStringParameter(URL));
        this.m_url.setSize(30);
        this.m_url.setMaxLength(200);
        this.m_url.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.m_url.setOnFocus("defaulting = false");
        this.m_url.setOnBlur("if (this.value == '') { defaulting = true; this.value = urlize(this.form.name.value) } else { this.value = urlize(this.value); }");
        this.addField(CategoryLocalizationForm.gz("cms.ui.category.url"), (Component)this.m_url);
        this.addAction(new BaseForm.Finish());
        this.addAction(new BaseForm.Cancel());
    }

    public void generateXML(PageState ps, Element parent) {
        this.m_script.generateXML(ps, parent);
        super.generateXML(ps, parent);
    }

    class NameUniqueListener
    implements ParameterListener {
        private final CategoryRequestLocal m_category;
        private final Widget m_widget;
        private final int m_type;
        public static final int NAME_FIELD = 1;
        public static final int URL_FIELD = 2;

        NameUniqueListener(CategoryRequestLocal category) {
            this(category, (Widget)categoryLocalizationForm.m_name, 1);
        }

        NameUniqueListener(CategoryRequestLocal category, Widget widget, int type) {
            this.m_category = category;
            this.m_widget = widget;
            this.m_type = type;
        }

        public final void validate(ParameterEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            String title = (String)this.m_widget.getValue(state);
            Category category = this.m_category.getCategory(state);
            CategoryCollection children = category.getChildren();
            while (children.next()) {
                Category child = children.getCategory();
                String compField = this.m_type == 2 ? child.getURL() : child.getName();
                if (!compField.equalsIgnoreCase(title) || this.m_category != null && this.m_category.getCategory(state).equals((Object)child)) continue;
                throw new FormProcessException(CategoryLocalizationForm.lz("cms.ui.category.name_not_unique"));
            }
        }
    }
}

