/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.category;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.bebop.table.TableColumnModel;
import com.arsdigita.bebop.table.TableModel;
import com.arsdigita.bebop.table.TableModelBuilder;
import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.CategoryLocalization;
import com.arsdigita.categorization.CategoryLocalizationCollection;
import com.arsdigita.cms.ui.category.CategoryRequestLocal;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.util.LockableImpl;
import java.math.BigDecimal;
import java.util.Locale;

public class CategoryLocalizationTable
extends Table
implements TableActionListener {
    private final CategoryRequestLocal m_category;
    private final SingleSelectionModel m_model;
    private final String TABLE_COL_LANG = "table_col_lang";
    private final String TABLE_COL_DEL = "table_col_del";
    private final SingleSelectionModel m_catLocale;

    public CategoryLocalizationTable(CategoryRequestLocal category, SingleSelectionModel model, SingleSelectionModel catLocale) {
        this.m_category = category;
        this.m_model = model;
        this.m_catLocale = catLocale;
        this.setEmptyView((Component)new Label(GlobalizationUtil.globalize("cms.ui.category.localization_none")));
        TableColumnModel tab_model = this.getColumnModel();
        tab_model.add(new TableColumn(0, GlobalizationUtil.globalize("cms.ui.category.localization.locale").localize(), (Object)"table_col_lang"));
        tab_model.add(new TableColumn(1, GlobalizationUtil.globalize("cms.ui.category.localization_name").localize()));
        tab_model.add(new TableColumn(2, GlobalizationUtil.globalize("cms.ui.category.localization_description").localize()));
        tab_model.add(new TableColumn(3, GlobalizationUtil.globalize("cms.ui.category.localization_url").localize()));
        tab_model.add(new TableColumn(4, GlobalizationUtil.globalize("cms.ui.category.localization_action").localize(), (Object)"table_col_del"));
        this.setModelBuilder(new CategoryLocalizationTableModelBuilder());
        tab_model.get(0).setCellRenderer((TableCellRenderer)new EditCellRenderer());
        tab_model.get(4).setCellRenderer((TableCellRenderer)new DeleteCellRenderer());
        this.addTableActionListener(this);
    }

    public void cellSelected(TableActionEvent evt) {
        PageState state = evt.getPageState();
        CategoryLocalization categoryLocalization = new CategoryLocalization(new BigDecimal(evt.getRowKey().toString()));
        Category category = this.m_category.getCategory(state);
        TableColumn col = this.getColumnModel().get(evt.getColumn().intValue());
        if (col.getHeaderKey().toString().equals("table_col_lang")) {
            this.m_catLocale.setSelectedKey(state, (Object)categoryLocalization.getLocale());
        }
        if (col.getHeaderKey().toString().equals("table_col_del")) {
            category.delLanguage(categoryLocalization.getLocale());
        }
    }

    public void headSelected(TableActionEvent e) {
        throw new UnsupportedOperationException("Not Implemented");
    }

    private class DeleteCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        private DeleteCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            if (CategoryLocalizationTable.this.m_category.getCategory(state).canDelete()) {
                ControlLink link = new ControlLink(value.toString());
                link.setConfirmation((String)GlobalizationUtil.globalize("cms.ui.category.localization_confirm_delete").localize());
                return link;
            }
            return null;
        }
    }

    private class EditCellRenderer
    extends LockableImpl
    implements TableCellRenderer {
        private EditCellRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            if (CategoryLocalizationTable.this.m_category.getCategory(state).canEdit()) {
                return new ControlLink(value.toString());
            }
            return new Label(value.toString());
        }
    }

    private class CategoryLocalizationTableModel
    implements TableModel {
        private final int MAX_DESC_LENGTH = 25;
        private Table m_table;
        private CategoryLocalizationCollection m_categoryLocalizations;
        private CategoryLocalization m_categoryLocalization;

        private CategoryLocalizationTableModel(Table t, PageState ps, Category category) {
            this.m_table = t;
            this.m_categoryLocalizations = new CategoryLocalizationCollection(category);
        }

        public int getColumnCount() {
            return this.m_table.getColumnModel().size();
        }

        public boolean nextRow() {
            if (this.m_categoryLocalizations != null && this.m_categoryLocalizations.next()) {
                this.m_categoryLocalization = this.m_categoryLocalizations.getCategoryLocalization();
                return true;
            }
            return false;
        }

        public Object getElementAt(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    Locale clLocale = new Locale(this.m_categoryLocalization.getLocale());
                    return clLocale.getDisplayLanguage();
                }
                case 1: {
                    return this.m_categoryLocalization.getName();
                }
                case 2: {
                    String desc = this.m_categoryLocalization.getDescription();
                    if (desc != null && desc.length() > 25) {
                        desc = desc.substring(22).concat("...");
                    }
                    return desc;
                }
                case 3: {
                    return this.m_categoryLocalization.getURL();
                }
                case 4: {
                    return GlobalizationUtil.globalize("cms.ui.delete").localize();
                }
            }
            return null;
        }

        public Object getKeyAt(int columnIndex) {
            return this.m_categoryLocalization.getID();
        }
    }

    private class CategoryLocalizationTableModelBuilder
    extends LockableImpl
    implements TableModelBuilder {
        private CategoryLocalizationTableModelBuilder() {
        }

        public TableModel makeModel(Table table, PageState state) {
            Category category = CategoryLocalizationTable.this.m_category.getCategory(state);
            if (category != null && category.hasLocalizations()) {
                return new CategoryLocalizationTableModel(table, state, category);
            }
            return Table.EMPTY_MODEL;
        }
    }
}

