/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.category;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.FormErrorDisplay;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.RadioGroup;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.parameters.ParameterData;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.categorization.CategorizedCollection;
import com.arsdigita.categorization.Category;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ui.CMSForm;
import com.arsdigita.cms.ui.FormSecurityListener;
import com.arsdigita.cms.ui.category.CategoryRequestLocal;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.util.TooManyListenersException;
import org.apache.log4j.Logger;

public class IndexItemSelectionForm
extends CMSForm {
    private static Logger s_log = Logger.getLogger(IndexItemSelectionForm.class);
    private final CategoryRequestLocal m_category;
    private RadioGroup m_options;
    private static final String NULL_OPTION_VALUE = "";
    private static final String NONE_OPTION_VALUE = "None";
    private FormErrorDisplay m_errors;
    private SaveCancelSection m_saveCancelSection;

    public IndexItemSelectionForm(CategoryRequestLocal m) {
        super("EditCategory");
        this.setMethod("post");
        this.m_category = m;
        Label header = new Label(GlobalizationUtil.globalize("cms.ui.category.select_index_item"));
        header.setFontWeight("b");
        this.add((Component)header, 64);
        this.m_errors = new FormErrorDisplay((Form)this);
        this.add((Component)this.m_errors, 64);
        this.m_options = new RadioGroup((ParameterModel)new StringParameter("items"));
        try {
            this.m_options.addPrintListener(new PrintListener(){

                public void prepare(PrintEvent event) {
                    RadioGroup group = (RadioGroup)event.getTarget();
                    PageState state = event.getPageState();
                    Category category = IndexItemSelectionForm.this.getCategory(event.getPageState());
                    CategorizedCollection children = category.getObjects("com.arsdigita.cms.ContentItem");
                    group.addOption(new Option(IndexItemSelectionForm.NONE_OPTION_VALUE, (Component)new Label(IndexItemSelectionForm.NONE_OPTION_VALUE)));
                    if (category.getParentCategoryCount() > 0L) {
                        group.addOption(new Option(IndexItemSelectionForm.NULL_OPTION_VALUE, (Component)new Label("Inherit Index from Parent Category")));
                    }
                    while (children.next()) {
                        ACSObject item = (ACSObject)children.getDomainObject();
                        if (!(item instanceof ContentItem) || !((ContentItem)item).getVersion().equals("draft")) continue;
                        group.addOption(new Option(item.getID().toString(), ((ContentItem)item).getName()));
                    }
                    ACSObject indexItem = category.getDirectIndexObject();
                    if (indexItem != null && indexItem instanceof ContentItem) {
                        group.setValue(state, (Object)((ContentItem)indexItem).getWorkingVersion().getID().toString());
                    } else {
                        String value = IndexItemSelectionForm.NONE_OPTION_VALUE;
                        if (!category.ignoreParentIndexItem() && category.getParentCategoryCount() > 0L) {
                            value = IndexItemSelectionForm.NULL_OPTION_VALUE;
                        }
                        group.setValue(state, (Object)value);
                    }
                }
            });
        }
        catch (TooManyListenersException e) {
            s_log.error((Object)"Error adding init listener to Radio Group", (Throwable)e);
            throw new UncheckedWrapperException((Throwable)e);
        }
        this.m_options.setLayout(2);
        this.add((Component)this.m_options);
        this.m_saveCancelSection = new SaveCancelSection();
        this.add((Component)this.m_saveCancelSection, 65);
        this.addSubmissionListener(new FormSecurityListener("category_admin"));
        this.addProcessListener(new FormProcessListener(){

            public void process(FormSectionEvent event) throws FormProcessException {
                PageState state = event.getPageState();
                FormData data = event.getFormData();
                ParameterData param = data.getParameter(IndexItemSelectionForm.this.m_options.getParameterModel().getName());
                String selectedValue = (String)param.getValue();
                Category category = IndexItemSelectionForm.this.getCategory(event.getPageState());
                ContentItem item = null;
                if (selectedValue != null) {
                    if (IndexItemSelectionForm.NULL_OPTION_VALUE.equals(selectedValue)) {
                        category.setIgnoreParentIndexItem(false);
                        selectedValue = null;
                    } else if (IndexItemSelectionForm.NONE_OPTION_VALUE.equals(selectedValue)) {
                        category.setIgnoreParentIndexItem(true);
                        selectedValue = null;
                    } else {
                        item = new ContentItem(new BigDecimal(selectedValue));
                        item = item.getWorkingVersion();
                    }
                }
                category.setIndexObject(item);
                category.save();
            }
        });
    }

    protected Submit getCancelButton() {
        return this.m_saveCancelSection.getCancelButton();
    }

    protected Category getCategory(PageState state) {
        Category category = this.m_category.getCategory(state);
        Assert.exists((Object)category);
        return category;
    }
}

