/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.category;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.categorization.Category;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ui.category.CategorizedObjectsList;
import com.arsdigita.cms.ui.category.CategoryRequestLocal;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.util.Assert;
import com.arsdigita.xml.Element;
import java.io.IOException;
import java.math.BigDecimal;
import javax.servlet.ServletException;
import org.apache.log4j.Logger;

public class OrderedCategorizedObjectsList
extends CategorizedObjectsList {
    private static final Logger s_log = Logger.getLogger(OrderedCategorizedObjectsList.class);
    private static final String SELECT_EVENT = "s";
    private static final String PREV_EVENT = "prev";
    private static final String NEXT_EVENT = "next";

    public OrderedCategorizedObjectsList(CategoryRequestLocal category) {
        super(category);
    }

    @Override
    public void generateXML(PageState state, Element parent) {
        boolean hasNext;
        if (!this.isVisible(state)) {
            return;
        }
        ListModel m = this.getModel(state);
        if (!m.next()) {
            super.generateXML(state, parent);
            return;
        }
        Element list = parent.newChildElement("cms:orderedCategorizedObjectList", "http://www.arsdigita.com/cms/1.0");
        this.exportAttributes(list);
        Object selKey = this.getSelectedKey(state);
        int i = 0;
        do {
            boolean selected;
            Element item = list.newChildElement("bebop:cell", "http://www.arsdigita.com/bebop/1.0");
            item.addAttribute("configure", "true");
            String key = m.getKey();
            Assert.exists((Object)key);
            boolean bl = selected = selKey != null && key.equals(selKey.toString());
            if (selected) {
                item.addAttribute("selected", "selected");
            }
            state.setControlEvent((Component)this, SELECT_EVENT, key);
            Label l = new Label(m.getElement().toString());
            ControlLink c = new ControlLink((Component)l);
            c.generateXML(state, item);
            hasNext = m.next();
            try {
                if (i > 0) {
                    state.setControlEvent((Component)this, PREV_EVENT, key);
                    item.addAttribute("prevURL", state.stateAsURL());
                }
                if (hasNext) {
                    state.setControlEvent((Component)this, NEXT_EVENT, key);
                    item.addAttribute("nextURL", state.stateAsURL());
                }
            }
            catch (IOException ex) {
                throw new IllegalStateException("Caught IOException: " + ex.getMessage());
            }
            ++i;
        } while (hasNext);
        state.clearControlEvent();
    }

    @Override
    public void respond(PageState ps) throws ServletException {
        String event = ps.getControlEventName();
        if (NEXT_EVENT.equals(event) || PREV_EVENT.equals(event)) {
            try {
                ContentItem child = new ContentItem(new BigDecimal(ps.getControlEventValue()));
                Category parent = this.getCategory(ps);
                if (NEXT_EVENT.equals(event)) {
                    parent.swapWithNext((ACSObject)child);
                } else {
                    parent.swapWithPrevious((ACSObject)child);
                }
                parent.save();
            }
            catch (DataObjectNotFoundException e) {
                s_log.error((Object)("Trying to create categories with state = " + ps), (Throwable)e);
                throw new ServletException((Throwable)e);
            }
        } else {
            super.respond(ps);
        }
    }
}

