/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.category;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.RequestLocal;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.OptionGroup;
import com.arsdigita.bebop.form.SingleSelect;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.util.SequentialMap;
import com.arsdigita.categorization.Category;
import com.arsdigita.categorization.CategoryPurpose;
import com.arsdigita.cms.ui.category.CategoryRequestLocal;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.PersistenceException;
import com.arsdigita.toolbox.ui.Cancellable;
import com.arsdigita.util.StringUtils;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.TooManyListenersException;
import org.apache.log4j.Logger;

public class PurposeForm
extends Form
implements FormProcessListener,
FormValidationListener,
Cancellable {
    private RequestLocal m_assigned;
    private Submit m_assign;
    private Submit m_remove;
    Label m_freeLabel;
    Label m_assignedLabel;
    public static final String FREE = "free";
    public static final String ASSIGNED = "assigned";
    public static final String ASSIGN = "assign";
    public static final String REMOVE = "remove";
    public static final int SELECT_WIDTH = 30;
    public static final int SELECT_HEIGHT = 10;
    public static final String FILLER_OPTION = StringUtils.repeat((String)"_", (int)30);
    private static final Logger s_log = Logger.getLogger(PurposeForm.class);
    private final CategoryRequestLocal m_category;
    private Submit m_cancelButton;

    public PurposeForm(CategoryRequestLocal category) {
        super("PurposeForm", (Container)new ColumnPanel(3));
        this.m_category = category;
        ColumnPanel panel = (ColumnPanel)this.getPanel();
        panel.setBorder(false);
        panel.setPadColor("#FFFFFF");
        panel.setColumnWidth(1, "0%");
        panel.setColumnWidth(2, "0%");
        panel.setColumnWidth(3, "0");
        panel.setWidth("0%");
        panel.setClassAttr("CMS Admin");
        this.m_assigned = new RequestLocal(){

            public Object initialValue(PageState state) {
                PurposeMap m = new PurposeMap();
                PurposeForm.this.initAssignedPurposes(state, m);
                return m;
            }
        };
        this.m_freeLabel = new Label(GlobalizationUtil.globalize("cms.ui.category.purpose_available"), false);
        this.m_freeLabel.setFontWeight("b");
        this.add((Component)this.m_freeLabel, 1);
        this.add((Component)new Label("&nbsp;", false));
        this.m_assignedLabel = new Label(GlobalizationUtil.globalize("cms.ui.category.purpose_assigned"), false);
        this.m_assignedLabel.setFontWeight("b");
        this.add((Component)this.m_assignedLabel, 1);
        SingleSelect freeWidget = new SingleSelect((ParameterModel)new BigDecimalParameter(FREE));
        try {
            freeWidget.addPrintListener((PrintListener)new FreePrintListener());
        }
        catch (TooManyListenersException e) {
            throw new UncheckedWrapperException("TooManyListeners" + e.getMessage(), (Throwable)e);
        }
        freeWidget.setSize(10);
        this.add((Component)freeWidget);
        BoxPanel box = new BoxPanel(2, true);
        box.setWidth("2%");
        this.addSubmitButtons((Container)box);
        this.add((Component)box, 18);
        SingleSelect assignedWidget = new SingleSelect((ParameterModel)new BigDecimalParameter(ASSIGNED));
        try {
            assignedWidget.addPrintListener((PrintListener)new AssignedPrintListener());
        }
        catch (TooManyListenersException e) {
            throw new UncheckedWrapperException("TooManyListeners" + e.getMessage(), (Throwable)e);
        }
        assignedWidget.setSize(10);
        this.add((Component)assignedWidget);
        this.addProcessListener(this);
        this.addValidationListener(this);
        this.setClassAttr("PurposeForm");
        this.m_cancelButton = new Submit("Finish");
        this.add((Component)this.m_cancelButton, 65);
    }

    protected void addSubmitButtons(Container c) {
        this.addAssignButton(c);
        this.addRemoveButton(c);
    }

    protected void addAssignButton(Container c) {
        this.m_assign = new Submit(ASSIGN, ">>");
        this.m_assign.setSize(10);
        c.add((Component)this.m_assign);
    }

    protected void addRemoveButton(Container c) {
        this.m_remove = new Submit(REMOVE, "<<");
        this.m_remove.setSize(10);
        c.add((Component)this.m_remove);
    }

    public void setUnassignedCaption(String caption) {
        this.m_freeLabel.setLabel(caption);
    }

    public void setAssignedCaption(String caption) {
        this.m_assignedLabel.setLabel(caption);
    }

    public PurposeMap getAssignedPurposes(PageState s) {
        return (PurposeMap)((Object)this.m_assigned.get(s));
    }

    protected void initAssignedPurposes(PageState state, PurposeMap map) {
        Category category = this.m_category.getCategory(state);
        Collection purposes = category.getPurposes();
        for (CategoryPurpose p : purposes) {
            map.add(p);
        }
    }

    public void assignPurpose(PageState state, CategoryPurpose purpose) {
        Category category = this.m_category.getCategory(state);
        if (category.canEdit()) {
            category.addPurpose(purpose);
            category.save();
        }
    }

    public void unassignPurpose(PageState state, CategoryPurpose purpose) {
        Category category = this.m_category.getCategory(state);
        if (category.canEdit()) {
            category.removePurpose(purpose);
            category.save();
        }
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        FormData data = e.getFormData();
        if (this.m_assign.isSelected(state)) {
            BigDecimal id = (BigDecimal)data.get((Object)FREE);
            try {
                CategoryPurpose purpose = new CategoryPurpose(new OID("com.arsdigita.categorization.CategoryPurpose", (Object)id));
                this.assignPurpose(state, purpose);
                data.put((Object)ASSIGNED, (Object)id);
            }
            catch (DataObjectNotFoundException ex) {
                s_log.error((Object)"Can't find CategoryPurpose", (Throwable)ex);
                throw new FormProcessException((Throwable)ex);
            }
            catch (PersistenceException pe) {
                s_log.error((Object)"Ignored persistence exception", (Throwable)pe);
            }
        } else if (this.m_remove.isSelected(state)) {
            BigDecimal id = (BigDecimal)data.get((Object)ASSIGNED);
            try {
                CategoryPurpose purpose = new CategoryPurpose(new OID("com.arsdigita.categorization.CategoryPurpose", (Object)id));
                this.unassignPurpose(state, purpose);
                data.put((Object)FREE, (Object)id);
            }
            catch (DataObjectNotFoundException ex) {
                s_log.error((Object)"Can't find CategoryPurpose", (Throwable)ex);
                throw new FormProcessException((Throwable)ex);
            }
        }
    }

    public void validate(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        FormData data = e.getFormData();
        if (this.m_assign.isSelected(state)) {
            if (data.get((Object)FREE) == null) {
                data.addError("Please select a purpose to assign");
            }
        } else if (this.m_remove.isSelected(state) && data.get((Object)ASSIGNED) == null) {
            data.addError("Please select a purpose to remove");
        }
    }

    private static void addFillerOption(OptionGroup o) {
        o.addOption(new Option("", FILLER_OPTION));
    }

    public Submit getCancelButton() {
        return this.m_cancelButton;
    }

    public boolean isCancelled(PageState state) {
        return this.m_cancelButton.isSelected(state);
    }

    protected static class PurposeMap
    extends SequentialMap {
        public void add(CategoryPurpose p) {
            super.put((Object)p.getID().toString(), (Object)p);
        }
    }

    private class AssignedPrintListener
    implements PrintListener {
        private AssignedPrintListener() {
        }

        public void prepare(PrintEvent e) {
            OptionGroup o = (OptionGroup)e.getTarget();
            PageState state = e.getPageState();
            PurposeMap m = PurposeForm.this.getAssignedPurposes(state);
            if (!m.isEmpty()) {
                for (CategoryPurpose p : m.values()) {
                    o.addOption(new Option(p.getID().toString(), p.getName()));
                }
            } else {
                o.addOption(new Option("", "-- none --"));
            }
            PurposeForm.addFillerOption(o);
        }
    }

    private class FreePrintListener
    implements PrintListener {
        private FreePrintListener() {
        }

        public void prepare(PrintEvent e) {
            OptionGroup o = (OptionGroup)e.getTarget();
            PageState state = e.getPageState();
            PurposeMap assigned = PurposeForm.this.getAssignedPurposes(state);
            for (CategoryPurpose purpose : CategoryPurpose.getAllPurposes()) {
                String id = purpose.getID().toString();
                String name = purpose.getName();
                if (assigned.containsKey(id) || name.length() <= 0) continue;
                o.addOption(new Option(id, name));
            }
            PurposeForm.addFillerOption(o);
        }
    }
}

