/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.category;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ParameterSingleSelectionModel;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.list.ListCellRenderer;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.categorization.Category;
import com.arsdigita.cms.ui.category.CategoryPurposeIteratorListModel;
import com.arsdigita.cms.ui.category.CategoryRequestLocal;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.util.LockableImpl;
import java.util.Collection;

public class PurposesList
extends List {
    public static final String PURPOSES_LIST = "pl";
    private final CategoryRequestLocal m_category;

    public PurposesList(CategoryRequestLocal category) {
        super((SingleSelectionModel)new ParameterSingleSelectionModel((ParameterModel)new BigDecimalParameter(PURPOSES_LIST)));
        this.setIdAttr("purposes_list");
        this.m_category = category;
        this.setModelBuilder(new CategoryPurposesModelBuilder());
        this.setCellRenderer(new ListCellRenderer(){

            public Component getComponent(List list, PageState state, Object value, String key, int index, boolean isSelected) {
                return new Label(value.toString());
            }
        });
        Label l = new Label(GlobalizationUtil.globalize("cms.ui.category.purpose_none"));
        l.setFontWeight("i");
        this.setEmptyView((Component)l);
    }

    private class CategoryPurposesModelBuilder
    extends LockableImpl
    implements ListModelBuilder {
        public ListModel makeModel(List l, PageState state) {
            Category category = PurposesList.this.m_category.getCategory(state);
            if (category != null && !category.isRoot()) {
                Collection purposes = category.getPurposes();
                return new CategoryPurposeIteratorListModel(purposes.iterator());
            }
            return List.EMPTY_MODEL;
        }
    }
}

